/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.dubbo;

import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.samplers.Sampler;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.sofa.tracer.plugins.dubbo.tracer.DubboConsumerSofaTracer;
import com.alipay.sofa.tracer.plugins.dubbo.tracer.DubboProviderSofaTracer;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.TimeoutException;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.support.RpcUtils;

@Activate(group={"provider", "consumer"}, value={"dubboSofaTracerFilter"}, order=1)
public class DubboSofaTracerFilter
implements Filter {
    private String appName = "";
    private static final String BLANK = "";
    private static final String SPAN_INVOKE_KEY = "sofa.current.span.key";
    private DubboConsumerSofaTracer dubboConsumerSofaTracer;
    private DubboProviderSofaTracer dubboProviderSofaTracer;
    private static Map<String, SofaTracerSpan> TracerSpanMap = new ConcurrentHashMap<String, SofaTracerSpan>();

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String spanKind;
        if ("$echo".equals(invocation.getMethodName())) {
            return invoker.invoke(invocation);
        }
        RpcContext rpcContext = RpcContext.getContext();
        if (StringUtils.isBlank((String)this.appName)) {
            this.appName = SofaTracerConfiguration.getProperty((String)"spring.application.name");
        }
        Result result = (spanKind = this.spanKind(rpcContext)).equals("server") ? this.doServerFilter(invoker, invocation) : this.doClientFilter(rpcContext, invoker, invocation);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result onResponse(Result result, Invoker<?> invoker, Invocation invocation) {
        String spanKey = this.getTracerSpanMapKey(invoker);
        try {
            boolean isAsync = RpcUtils.isAsync((URL)invoker.getUrl(), (Invocation)invocation);
            if (!isAsync) {
                Result result2 = result;
                return result2;
            }
            if (TracerSpanMap.containsKey(spanKey)) {
                SofaTracerSpan sofaTracerSpan = TracerSpanMap.get(spanKey);
                if (this.dubboConsumerSofaTracer == null) {
                    this.dubboConsumerSofaTracer = DubboConsumerSofaTracer.getDubboConsumerSofaTracerSingleton();
                }
                String resultCode = "00";
                if (result.hasException()) {
                    if (result.getException() instanceof RpcException) {
                        resultCode = Integer.toString(((RpcException)result.getException()).getCode());
                        sofaTracerSpan.setTag("result.code", resultCode);
                    } else {
                        resultCode = "99";
                    }
                }
                this.appendElapsedTimeTags(invocation, sofaTracerSpan, result, true);
                this.dubboConsumerSofaTracer.clientReceiveTagFinish(sofaTracerSpan, resultCode);
            }
        }
        finally {
            if (TracerSpanMap.containsKey(spanKey)) {
                TracerSpanMap.remove(spanKey);
            }
        }
        return result;
    }

    private Result doClientFilter(RpcContext rpcContext, Invoker<?> invoker, Invocation invocation) {
        Result result;
        if (this.dubboConsumerSofaTracer == null) {
            this.dubboConsumerSofaTracer = DubboConsumerSofaTracer.getDubboConsumerSofaTracerSingleton();
        }
        String methodName = rpcContext.getMethodName();
        String service = invoker.getInterface().getSimpleName();
        SofaTracerSpan sofaTracerSpan = this.dubboConsumerSofaTracer.clientSend(service + "#" + methodName);
        this.appendRpcClientSpanTags(invoker, sofaTracerSpan);
        String serializedSpanContext = sofaTracerSpan.getSofaTracerSpanContext().serializeSpanContext();
        invocation.getAttachments().put("dubbo.rpc.sofa.tracer", serializedSpanContext);
        boolean isAsync = RpcUtils.isAsync((URL)invoker.getUrl(), (Invocation)invocation);
        boolean isOneWay = false;
        if (isAsync) {
            sofaTracerSpan.setTag("invoke.type", "future");
        } else {
            isOneWay = RpcUtils.isOneway((URL)invoker.getUrl(), (Invocation)invocation);
            if (isOneWay) {
                sofaTracerSpan.setTag("invoke.type", "oneway");
            } else {
                sofaTracerSpan.setTag("invoke.type", "sync");
            }
        }
        Throwable exception = null;
        String resultCode = "00";
        try {
            result = invoker.invoke(invocation);
            if (result == null) {
                if (isOneWay) {
                    sofaTracerSpan.setTag("resp.size.bytes", (Number)0);
                }
            } else {
                this.appendElapsedTimeTags(invocation, sofaTracerSpan, result, true);
            }
        }
        catch (RpcException e) {
            exception = e;
            throw e;
        }
        catch (Throwable t) {
            exception = t;
            throw new RpcException(t);
        }
        finally {
            if (exception != null) {
                if (exception instanceof RpcException) {
                    sofaTracerSpan.setTag(Tags.ERROR.getKey(), exception.getMessage());
                    RpcException rpcException = (RpcException)exception;
                    resultCode = String.valueOf(rpcException.getCode());
                } else {
                    resultCode = "99";
                }
            }
            if (!isAsync) {
                this.dubboConsumerSofaTracer.clientReceive(resultCode);
            } else {
                SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
                SofaTracerSpan clientSpan = sofaTraceContext.pop();
                if (clientSpan != null) {
                    sofaTracerSpan.log("cs");
                }
                TracerSpanMap.put(this.getTracerSpanMapKey(invoker), sofaTracerSpan);
                if (clientSpan != null && clientSpan.getParentSofaTracerSpan() != null) {
                    sofaTraceContext.push(clientSpan.getParentSofaTracerSpan());
                }
                CompletableFuture future = (CompletableFuture)RpcContext.getContext().getFuture();
                future.whenComplete((object, throwable) -> {
                    if (throwable != null && throwable instanceof TimeoutException) {
                        sofaTracerSpan.setTag(Tags.ERROR.getKey(), throwable.getMessage());
                        this.dubboConsumerSofaTracer.clientReceiveTagFinish(sofaTracerSpan, "03");
                    }
                });
            }
        }
        return result;
    }

    private Result doServerFilter(Invoker<?> invoker, Invocation invocation) {
        if (this.dubboProviderSofaTracer == null) {
            this.dubboProviderSofaTracer = DubboProviderSofaTracer.getDubboProviderSofaTracerSingleton();
        }
        SofaTracerSpan sofaTracerSpan = this.serverReceived(invocation);
        this.appendRpcServerSpanTags(invoker, sofaTracerSpan);
        Throwable exception = null;
        try {
            Result result = invoker.invoke(invocation);
            if (result == null) {
                Result result2 = null;
                return result2;
            }
            this.appendElapsedTimeTags(invocation, sofaTracerSpan, result, false);
            if (result.hasException()) {
                exception = result.getException();
            }
            Result result3 = result;
            return result3;
        }
        catch (RpcException e) {
            exception = e;
            throw e;
        }
        catch (Throwable t) {
            exception = t;
            throw new RpcException(t);
        }
        finally {
            String resultCode = "00";
            if (exception != null) {
                if (exception instanceof RpcException) {
                    sofaTracerSpan.setTag(Tags.ERROR.getKey(), exception.getMessage());
                    RpcException rpcException = (RpcException)exception;
                    if (rpcException.isBiz()) {
                        resultCode = String.valueOf(rpcException.getCode());
                    }
                } else {
                    resultCode = "99";
                }
            }
            this.dubboProviderSofaTracer.serverSend(resultCode);
        }
    }

    private SofaTracerSpan serverReceived(Invocation invocation) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(Tags.SPAN_KIND.getKey(), "server");
        String serializeSpanContext = (String)invocation.getAttachments().get("dubbo.rpc.sofa.tracer");
        SofaTracerSpanContext sofaTracerSpanContext = SofaTracerSpanContext.deserializeFromString((String)serializeSpanContext);
        boolean isCalculateSampler = false;
        boolean isSampled = true;
        if (sofaTracerSpanContext == null) {
            SelfLog.error((String)"SpanContext created error when server received and root SpanContext created.");
            sofaTracerSpanContext = SofaTracerSpanContext.rootStart();
            isCalculateSampler = true;
        }
        String simpleName = invocation.getInvoker().getInterface().getSimpleName();
        SofaTracerSpan serverSpan = new SofaTracerSpan(this.dubboProviderSofaTracer.getSofaTracer(), System.currentTimeMillis(), simpleName, sofaTracerSpanContext, tags);
        if (isCalculateSampler) {
            Sampler sampler = this.dubboProviderSofaTracer.getSofaTracer().getSampler();
            if (sampler != null) {
                isSampled = sampler.sample(serverSpan).isSampled();
            }
            sofaTracerSpanContext.setSampled(isSampled);
        }
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        serverSpan.log("sr");
        sofaTraceContext.push(serverSpan);
        return serverSpan;
    }

    private void appendElapsedTimeTags(Invocation invocation, SofaTracerSpan sofaTracerSpan, Result result, boolean isClient) {
        if (sofaTracerSpan == null) {
            return;
        }
        if (isClient) {
            String reqSize = invocation.getAttachment("client.serialize.size");
            String elapsed = invocation.getAttachment("client.serialize.time");
            String respSize = result.getAttachment("client.deserialize.size");
            String deElapsed = result.getAttachment("client.deserialize.time");
            sofaTracerSpan.setTag("client.serialize.time", (Number)this.parseAttachment(elapsed, 0));
            sofaTracerSpan.setTag("client.deserialize.time", (Number)this.parseAttachment(deElapsed, 0));
            sofaTracerSpan.setTag("client.serialize.size", (Number)this.parseAttachment(reqSize, 0));
            sofaTracerSpan.setTag("client.deserialize.size", (Number)this.parseAttachment(respSize, 0));
        } else {
            String reqSize = invocation.getAttachment("server.deserialize.size");
            String deElapsed = invocation.getAttachment("server.deserialize.time");
            String respSize = result.getAttachment("server.serialize.size");
            String elapsed = result.getAttachment("server.serialize.time");
            sofaTracerSpan.setTag("server.deserialize.size", (Number)this.parseAttachment(reqSize, 0));
            sofaTracerSpan.setTag("server.deserialize.time", (Number)this.parseAttachment(deElapsed, 0));
            sofaTracerSpan.setTag("server.serialize.size", (Number)this.parseAttachment(respSize, 0));
            sofaTracerSpan.setTag("server.serialize.time", (Number)this.parseAttachment(elapsed, 0));
        }
    }

    private int parseAttachment(String value, int defaultVal) {
        try {
            if (StringUtils.isNotBlank((String)value)) {
                defaultVal = Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            SelfLog.error((String)"Failed to parse Dubbo plugin params.", (Throwable)e);
        }
        return defaultVal;
    }

    private void appendRpcServerSpanTags(Invoker<?> invoker, SofaTracerSpan sofaTracerSpan) {
        if (sofaTracerSpan == null) {
            return;
        }
        RpcContext rpcContext = RpcContext.getContext();
        Map tagsStr = sofaTracerSpan.getTagsWithStr();
        tagsStr.put(Tags.SPAN_KIND.getKey(), this.spanKind(rpcContext));
        String service = invoker.getInterface().getName();
        tagsStr.put("service", service == null ? BLANK : service);
        String methodName = rpcContext.getMethodName();
        tagsStr.put("method", methodName == null ? BLANK : methodName);
        String app = rpcContext.getUrl().getParameter("application");
        tagsStr.put("remote.host", rpcContext.getRemoteHost());
        tagsStr.put("local.app", app == null ? BLANK : app);
        tagsStr.put("current.thread.name", Thread.currentThread().getName());
        String protocol = rpcContext.getUrl().getProtocol();
        tagsStr.put("protocol", protocol == null ? BLANK : protocol);
        tagsStr.put("local.host", rpcContext.getRemoteHost());
        tagsStr.put("local.port", String.valueOf(rpcContext.getRemotePort()));
    }

    private void appendRpcClientSpanTags(Invoker<?> invoker, SofaTracerSpan sofaTracerSpan) {
        if (sofaTracerSpan == null) {
            return;
        }
        RpcContext rpcContext = RpcContext.getContext();
        Map tagsStr = sofaTracerSpan.getTagsWithStr();
        tagsStr.put(Tags.SPAN_KIND.getKey(), this.spanKind(rpcContext));
        String protocol = rpcContext.getUrl().getProtocol();
        tagsStr.put("protocol", protocol == null ? BLANK : protocol);
        String service = invoker.getInterface().getName();
        tagsStr.put("service", service == null ? BLANK : service);
        String methodName = rpcContext.getMethodName();
        tagsStr.put("method", methodName == null ? BLANK : methodName);
        tagsStr.put("current.thread.name", Thread.currentThread().getName());
        String app = rpcContext.getUrl().getParameter("application");
        tagsStr.put("local.app", app == null ? BLANK : app);
        tagsStr.put("remote.host", rpcContext.getRemoteHost());
        tagsStr.put("remote.port", String.valueOf(rpcContext.getRemotePort()));
        tagsStr.put("local.host", rpcContext.getLocalHost());
    }

    private String spanKind(RpcContext rpcContext) {
        return rpcContext.isConsumerSide() ? "client" : "server";
    }

    private String getTracerSpanMapKey(Invoker<?> invoker) {
        return "sofa.current.span.key." + invoker.hashCode();
    }
}

