/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.factory;

import com.alipay.sofa.common.log.SpaceId;
import com.alipay.sofa.common.log.adapter.level.AdapterLevel;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.common.log.spi.Log4j2FilterGenerator;
import com.alipay.sofa.common.log.spi.Log4j2ReInitializer;
import com.alipay.sofa.common.log.spi.ReInitializeChecker;
import com.alipay.sofa.common.utils.StringUtil;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.slf4j.Log4jLogger;
import org.slf4j.Logger;

public class Log4j2LoggerSpaceFactory
extends AbstractLoggerSpaceFactory {
    private ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();
    private SpaceId spaceId;
    private Properties properties;
    private LoggerContext loggerContext;
    private URL confFile;

    public Log4j2LoggerSpaceFactory(SpaceId spaceId, Properties properties, URL confFile, String source) throws Throwable {
        super(source);
        this.spaceId = spaceId;
        this.properties = properties;
        this.confFile = confFile;
        boolean willReinitialize = false;
        Iterator<ReInitializeChecker> checkers = ServiceLoader.load(ReInitializeChecker.class, this.getClass().getClassLoader()).iterator();
        while (checkers.hasNext()) {
            willReinitialize = !checkers.next().isReInitialize();
        }
        this.loggerContext = this.initialize(willReinitialize);
        Iterator<Log4j2FilterGenerator> matchers = ServiceLoader.load(Log4j2FilterGenerator.class, this.getClass().getClassLoader()).iterator();
        while (matchers.hasNext() & willReinitialize) {
            Log4j2FilterGenerator matcher = matchers.next();
            for (Filter filter : matcher.generatorFilters()) {
                this.loggerContext.addFilter(filter);
            }
        }
    }

    private LoggerContext initialize(boolean willReInitialize) throws Throwable {
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            ThreadContext.put((String)((String)entry.getKey()), (String)this.properties.getProperty((String)entry.getValue()));
        }
        LoggerContext context = willReInitialize ? new LoggerContext(this.spaceId.getSpaceName(), (Object)"sofa.log.first.initialize", this.confFile.toURI()) : new LoggerContext(this.spaceId.getSpaceName(), null, this.confFile.toURI());
        Configuration config = null;
        ConfigurationFactory configurationFactory = ConfigurationFactory.getInstance();
        try {
            Class[] parameterTypes = new Class[]{String.class, URI.class, ClassLoader.class};
            Method getConfigurationMethod = configurationFactory.getClass().getMethod("getConfiguration", parameterTypes);
            config = (Configuration)getConfigurationMethod.invoke((Object)configurationFactory, this.spaceId.getSpaceName(), this.confFile.toURI(), this.getClass().getClassLoader());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class[] parameterTypes = new Class[]{LoggerContext.class, String.class, URI.class, ClassLoader.class};
            Method getConfigurationMethod = configurationFactory.getClass().getMethod("getConfiguration", parameterTypes);
            config = (Configuration)getConfigurationMethod.invoke((Object)configurationFactory, context, this.spaceId.getSpaceName(), this.confFile.toURI(), this.getClass().getClassLoader());
        }
        if (config == null) {
            throw new RuntimeException("No log4j2 configuration are found.");
        }
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            config.getProperties().put((String)entry.getKey(), (String)entry.getValue());
        }
        context.start(config);
        return context;
    }

    public void reInitialize(Map<String, String> environment) {
        Iterator<Log4j2ReInitializer> matchers;
        String spaceLoggingConfig;
        this.properties.putAll(environment);
        String spaceLoggingPath = environment.get("logging.path." + this.spaceId.getSpaceName());
        if (!StringUtil.isBlank(spaceLoggingPath)) {
            this.properties.setProperty("logging.path." + this.spaceId.getSpaceName(), spaceLoggingPath);
        } else if (Boolean.TRUE.toString().equals(this.properties.getProperty("isDefaultLogPath"))) {
            this.properties.setProperty("logging.path." + this.spaceId.getSpaceName(), this.properties.getProperty("logging.path"));
        }
        String loggingLevelKey = "logging.level." + this.spaceId.getSpaceName();
        if (Boolean.TRUE.toString().equals(this.properties.getProperty("isDefaultLogLevel")) && StringUtil.isBlank(environment.get(loggingLevelKey))) {
            for (int i = "logging.level".length(); i < loggingLevelKey.length(); ++i) {
                String level;
                if (loggingLevelKey.charAt(i) != '.' || StringUtil.isBlank(level = environment.get(loggingLevelKey.substring(0, i + 1) + "*"))) continue;
                this.properties.setProperty(loggingLevelKey, level);
            }
        }
        if (!StringUtil.isBlank(spaceLoggingConfig = environment.get(String.format("logging.config.%s", this.spaceId.getSpaceName())))) {
            this.confFile = this.getClass().getClassLoader().getResource(spaceLoggingConfig);
        }
        if ((matchers = ServiceLoader.load(Log4j2ReInitializer.class, this.getClass().getClassLoader()).iterator()).hasNext()) {
            Log4j2ReInitializer log4j2ReInitializer = matchers.next();
            log4j2ReInitializer.reInitialize(this.spaceId, this.loggerContext, this.properties, this.confFile);
        }
    }

    @Override
    public Logger setLevel(String loggerName, AdapterLevel adapterLevel) {
        String key = "ROOT".equals(loggerName) ? "" : loggerName;
        org.apache.logging.log4j.core.Logger log4j2Logger = this.loggerContext.getLogger(key);
        Level log4j2Level = this.toLog4j2Level(adapterLevel);
        log4j2Logger.setLevel(log4j2Level);
        return this.getLogger(loggerName);
    }

    public Logger getLogger(String name) {
        Logger logger = (Logger)this.loggerMap.get(name);
        if (logger != null) {
            return logger;
        }
        this.loggerMap.putIfAbsent(name, this.newLogger(name, this.loggerContext));
        return (Logger)this.loggerMap.get(name);
    }

    private Logger newLogger(String name, LoggerContext loggerContext) {
        String key = "ROOT".equals(name) ? "" : name;
        return new Log4jLogger((ExtendedLogger)loggerContext.getLogger(key), name);
    }

    private Level toLog4j2Level(AdapterLevel adapterLevel) {
        if (adapterLevel == null) {
            throw new IllegalStateException("AdapterLevel is NULL when adapter to log4j2.");
        }
        switch (adapterLevel) {
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
        }
        throw new IllegalStateException((Object)((Object)adapterLevel) + " is unknown when adapter to log4j2.");
    }
}

