/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.util.parse;

import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.spring.util.AbstractConfigParse;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class DefaultYamlConfigParse
extends AbstractConfigParse {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultYamlConfigParse.class);
    private static final String YAML_ALLOW_COMPLEX_OBJECT = "yamlAllowComplexObject";

    private static boolean getYamlAllowComplexObject() {
        return Boolean.getBoolean(YAML_ALLOW_COMPLEX_OBJECT);
    }

    protected static Yaml createYaml() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setAllowDuplicateKeys(false);
        Object constructor = DefaultYamlConfigParse.getYamlAllowComplexObject() ? new Constructor(loaderOptions) : new SafeConstructor(loaderOptions);
        DumperOptions dumperOptions = new DumperOptions();
        Representer representer = new Representer(dumperOptions);
        LimitedResolver resolver = new LimitedResolver();
        return new Yaml((BaseConstructor)constructor, representer, dumperOptions, loaderOptions, (Resolver)resolver);
    }

    protected static boolean process(MatchCallback callback, Yaml yaml, String content) {
        int count = 0;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading from YAML: " + content);
        }
        for (Object object : yaml.loadAll(content)) {
            if (object == null || !DefaultYamlConfigParse.process(DefaultYamlConfigParse.asMap(object), callback)) continue;
            ++count;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loaded " + count + " document" + (count > 1 ? "s" : "") + " from YAML resource: " + content);
        }
        return count > 0;
    }

    protected static boolean process(Map<String, Object> map, MatchCallback callback) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Merging document (no matchers set): " + map);
        }
        callback.process(DefaultYamlConfigParse.getFlattenedMap(map));
        return true;
    }

    protected static Map<String, Object> asMap(Object object) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (!(object instanceof Map)) {
            result.put("document", object);
            return result;
        }
        Map map = (Map)object;
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                value = DefaultYamlConfigParse.asMap(value);
            }
            if (key instanceof CharSequence) {
                result.put(key.toString(), value);
                continue;
            }
            result.put("[" + key.toString() + "]", value);
        }
        return result;
    }

    protected static Map<String, Object> getFlattenedMap(Map<String, Object> source) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        DefaultYamlConfigParse.buildFlattenedMap(result, source, null);
        return result;
    }

    protected static void buildFlattenedMap(Map<String, Object> result, Map<String, Object> source, String path) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (!StringUtils.isBlank((CharSequence)path)) {
                key = key.startsWith("[") ? path + key : path + '.' + key;
            }
            if ((value = entry.getValue()) instanceof String) {
                result.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                DefaultYamlConfigParse.buildFlattenedMap(result, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count = 0;
                for (Object object : collection) {
                    DefaultYamlConfigParse.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            result.put(key, value != null ? value.toString() : "");
        }
    }

    @Override
    public Map<String, Object> parse(String configText) {
        final AtomicReference result = new AtomicReference();
        DefaultYamlConfigParse.process(new MatchCallback(){

            @Override
            public void process(Map<String, Object> map) {
                result.set(map);
            }
        }, DefaultYamlConfigParse.createYaml(), configText);
        return (Map)result.get();
    }

    @Override
    public String processType() {
        return ConfigType.YAML.getType();
    }

    private static class LimitedResolver
    extends Resolver {
        private LimitedResolver() {
        }

        public void addImplicitResolver(Tag tag, Pattern regexp, String first) {
            if (tag == Tag.TIMESTAMP) {
                return;
            }
            super.addImplicitResolver(tag, regexp, first);
        }
    }

    protected static interface MatchCallback {
        public void process(Map<String, Object> var1);
    }
}

