/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;

public class EnumSerializer
implements ObjectSerializer {
    public static final EnumSerializer instance = new EnumSerializer();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            serializer.getWriter().writeNull();
            return;
        }
        Enum e = (Enum)object;
        if (serializer.isEnabled(SerializerFeature.WriteEnumUsingName)) {
            serializer.write(e.name());
        } else if (serializer.isEnabled(SerializerFeature.WriteEnumUsingToString)) {
            serializer.write(e.toString());
        } else {
            out.writeInt(e.ordinal());
        }
    }
}

