/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jdk8DateCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final Jdk8DateCodec instance = new Jdk8DateCodec();

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 4) {
            String text = lexer.stringVal();
            lexer.nextToken();
            if (type == LocalDateTime.class) {
                LocalDateTime localDateTime = LocalDateTime.parse(text);
                return (T)localDateTime;
            }
            if (type == LocalDate.class) {
                LocalDate localDate = LocalDate.parse(text);
                return (T)localDate;
            }
            if (type == LocalTime.class) {
                LocalTime localDate = LocalTime.parse(text);
                return (T)localDate;
            }
            if (type == ZonedDateTime.class) {
                ZonedDateTime zonedDateTime = ZonedDateTime.parse(text);
                return (T)zonedDateTime;
            }
            if (type == OffsetDateTime.class) {
                OffsetDateTime offsetDateTime = OffsetDateTime.parse(text);
                return (T)offsetDateTime;
            }
            if (type == OffsetTime.class) {
                OffsetTime offsetTime = OffsetTime.parse(text);
                return (T)offsetTime;
            }
            if (type == ZoneId.class) {
                ZoneId offsetTime = ZoneId.of(text);
                return (T)offsetTime;
            }
            if (type == Period.class) {
                Period period = Period.parse(text);
                return (T)period;
            }
            if (type == Duration.class) {
                Duration duration = Duration.parse(text);
                return (T)duration;
            }
            if (type == Instant.class) {
                Instant instant = Instant.parse(text);
                return (T)instant;
            }
        } else {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            out.writeNull();
            return;
        }
        out.writeString(object.toString());
    }
}

