/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.domain;

import com.taobao.hsf.status.ProcessResult;
import java.io.Serializable;

public class HSFResponse
implements Serializable {
    private static final long serialVersionUID = -4364536436151723421L;
    private boolean isError = false;
    private String errorMsg;
    private Object appResponse;
    private transient String errorType;
    private transient boolean isTimeout = false;
    private transient ProcessResult processResult = ProcessResult.OK;
    private transient HSFResponseStatus status = HSFResponseStatus.OK;

    public Object getAppResponse() {
        return this.appResponse;
    }

    public void setAppResponse(Object response) {
        this.appResponse = response;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String error) {
        this.isError = true;
    }

    public boolean isError() {
        return this.isError;
    }

    public void setClientErrorMsg(String error) {
        this.isError = true;
        this.errorMsg = error;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public boolean isTimeout() {
        return this.isTimeout;
    }

    public void setIsTimeout(boolean isTimeout) {
        this.isTimeout = isTimeout;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HSFResponse[");
        sb.append("HSF\u51fa\u73b0\u5f02\u5e38=").append(this.isError).append(", ");
        sb.append("HSF\u5f02\u5e38\u6d88\u606f=").append(this.errorMsg).append(", ");
        sb.append("\u4e1a\u52a1\u5c42\u54cd\u5e94=").append(this.appResponse).append("]");
        return sb.toString();
    }

    public HSFResponseStatus getStatus() {
        return this.status;
    }

    public void setStatus(HSFResponseStatus status) {
        this.status = status;
    }

    public void setStatus(byte status) {
        this.status = HSFResponseStatus.fromCode(status);
    }

    public ProcessResult getProcessResult() {
        return this.processResult;
    }

    public void setProcessResult(ProcessResult processResult) {
        this.processResult = processResult;
    }

    public static final class HSFResponseStatus
    extends Enum<HSFResponseStatus> {
        public static final /* enum */ HSFResponseStatus SERVER_GETCODER;
        public static final /* enum */ HSFResponseStatus OK;
        public static final /* enum */ HSFResponseStatus CLIENT_TIMEOUT;
        public static final /* enum */ HSFResponseStatus SERVER_TIMEOUT;
        public static final /* enum */ HSFResponseStatus BAD_REQUEST;
        public static final /* enum */ HSFResponseStatus BAD_RESPONSE;
        public static final /* enum */ HSFResponseStatus SERVICE_NOT_FOUND;
        public static final /* enum */ HSFResponseStatus METHOD_NOT_FOUND;
        public static final /* enum */ HSFResponseStatus SERVICE_ERROR;
        public static final /* enum */ HSFResponseStatus SERVER_ERROR;
        public static final /* enum */ HSFResponseStatus THREADPOOL_BUSY;
        public static final /* enum */ HSFResponseStatus COMM_ERROR;
        public static final /* enum */ HSFResponseStatus UNKNOWN_CODE;
        public static final /* enum */ HSFResponseStatus SERVER_SERIALIZE_ERROR;
        public static final /* enum */ HSFResponseStatus SERVER_CLOSING;
        public static final /* enum */ HSFResponseStatus CLIENT_ERROR;
        public static final /* enum */ HSFResponseStatus UNKNOWN_ERROR;
        public static final /* enum */ HSFResponseStatus CLIENT_DESERIALIZE_ERROR;
        private static HSFResponseStatus[] enumArray;
        private final String message;
        private final byte code;
        private static final /* synthetic */ HSFResponseStatus[] $VALUES;

        public static HSFResponseStatus[] values() {
            return (HSFResponseStatus[])$VALUES.clone();
        }

        public static HSFResponseStatus valueOf(String name) {
            return Enum.valueOf(HSFResponseStatus.class, name);
        }

        private HSFResponseStatus(int code, String message) {
            this.code = (byte)code;
            this.message = message;
        }

        public static HSFResponseStatus fromCode(byte code) {
            HSFResponseStatus result = null;
            if (code > 0) {
                result = enumArray[code];
            }
            if (result == null) {
                result = UNKNOWN_CODE;
            }
            return result;
        }

        public String getMessage() {
            return this.message;
        }

        public byte getCode() {
            return this.code;
        }

        static {
            HSFResponseStatus[] values;
            SERVER_GETCODER = new HSFResponseStatus(10, "server send coders");
            OK = new HSFResponseStatus(20, "OK");
            CLIENT_TIMEOUT = new HSFResponseStatus(30, "client timeout");
            SERVER_TIMEOUT = new HSFResponseStatus(31, "server timeout");
            BAD_REQUEST = new HSFResponseStatus(40, "bad request");
            BAD_RESPONSE = new HSFResponseStatus(50, "bad response");
            SERVICE_NOT_FOUND = new HSFResponseStatus(60, "service not found");
            METHOD_NOT_FOUND = new HSFResponseStatus(61, "method not found");
            SERVICE_ERROR = new HSFResponseStatus(70, "service error");
            SERVER_ERROR = new HSFResponseStatus(80, "server error");
            THREADPOOL_BUSY = new HSFResponseStatus(81, "thread pool is busy");
            COMM_ERROR = new HSFResponseStatus(82, "communication error");
            UNKNOWN_CODE = new HSFResponseStatus(83, "unknown code");
            SERVER_SERIALIZE_ERROR = new HSFResponseStatus(84, "server serialize error");
            SERVER_CLOSING = new HSFResponseStatus(88, "server will close soon");
            CLIENT_ERROR = new HSFResponseStatus(90, "client error");
            UNKNOWN_ERROR = new HSFResponseStatus(91, "unknown error");
            CLIENT_DESERIALIZE_ERROR = new HSFResponseStatus(100, "server send coders");
            $VALUES = new HSFResponseStatus[]{SERVER_GETCODER, OK, CLIENT_TIMEOUT, SERVER_TIMEOUT, BAD_REQUEST, BAD_RESPONSE, SERVICE_NOT_FOUND, METHOD_NOT_FOUND, SERVICE_ERROR, SERVER_ERROR, THREADPOOL_BUSY, COMM_ERROR, UNKNOWN_CODE, SERVER_SERIALIZE_ERROR, SERVER_CLOSING, CLIENT_ERROR, UNKNOWN_ERROR, CLIENT_DESERIALIZE_ERROR};
            enumArray = new HSFResponseStatus[127];
            HSFResponseStatus[] arr$ = values = HSFResponseStatus.values();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                HSFResponseStatus value;
                HSFResponseStatus.enumArray[value.code] = value = arr$[i$];
            }
        }
    }
}

