/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.util;

import com.taobao.csp.sentinel.context.Context;
import com.taobao.csp.sentinel.context.ContextUtil;
import com.taobao.csp.sentinel.node.ClusterNode;
import com.taobao.csp.sentinel.node.DefaultNode;
import com.taobao.csp.sentinel.slots.block.BlockException;
import com.taobao.csp.sentinel.slots.block.authority.AuthorityRuleManager;
import com.taobao.csp.sentinel.slots.block.callbacks.CallbackManager;
import com.taobao.csp.sentinel.slots.block.callbacks.HsfProviderBlock;
import com.taobao.csp.sentinel.slots.block.callbacks.UrlBlock;
import com.taobao.csp.sentinel.slots.block.callbacks.UrlClean;
import com.taobao.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.taobao.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.taobao.csp.sentinel.slots.block.flow.ParamFlowRuleManager;
import com.taobao.csp.sentinel.util.ExceptionLogUtil;
import com.taobao.csp.sentinel.util.ExceptionUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;

public class SentinelUtil {
    private static final String[] IP_HEADERS = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "X-Real-IP", "NS-Client-IP"};
    public static final String BLOCL_EXCELTION_FLAG = "SentinelBlockException";
    public static String ip = "";

    public static boolean isBlockException(Throwable t) {
        if (null == t) {
            return false;
        }
        int counter = 0;
        for (Throwable cause = t; cause != null && counter++ < 50; cause = cause.getCause()) {
            if (!(cause instanceof BlockException) && !BLOCL_EXCELTION_FLAG.equals(cause.getMessage())) continue;
            return true;
        }
        return false;
    }

    public static void clearStactTrace(Throwable t) {
        t.setStackTrace(BlockException.sentinelStackTrace);
    }

    public static boolean hasAuthorityConfig(String resource) {
        return AuthorityRuleManager.hasConfig((String)resource);
    }

    public static boolean hasFlowConfig(String resource) {
        return FlowRuleManager.hasConfig((String)resource);
    }

    public static boolean hasParamflowConfig(String resource) {
        return ParamFlowRuleManager.hasConfig((String)resource);
    }

    public static boolean hasDegradeConfig(String resource) {
        return DegradeRuleManager.hasConfig((String)resource);
    }

    public static void registerUrlClean(UrlClean urlClean) {
        if (urlClean == null) {
            return;
        }
        CallbackManager.setUrlClean(urlClean);
    }

    public static void registerUrlBlock(UrlBlock urlBlock) {
        if (urlBlock == null) {
            return;
        }
        CallbackManager.setUrlBlock(urlBlock);
    }

    public static void registerHsfProviderBlock(HsfProviderBlock hsfProviderBlock) {
        if (hsfProviderBlock == null) {
            return;
        }
        CallbackManager.setHsfProviderBlock(hsfProviderBlock);
    }

    public static final String getRemoteAddress(HttpServletRequest request) {
        int index;
        String header;
        String ip = null;
        boolean valid = false;
        String[] arr$ = IP_HEADERS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(valid = SentinelUtil.checkIP(ip = request.getHeader(header = arr$[i$]))); ++i$) {
        }
        if (!valid) {
            ip = request.getRemoteAddr();
        }
        if ((index = ip.indexOf(44)) != -1) {
            String firstIp = ip.substring(0, index).trim();
            if (SentinelUtil.checkIP(ip)) {
                ip = firstIp;
            }
        }
        return ip;
    }

    private static final boolean checkIP(String ip) {
        return ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip);
    }

    public static void trace(Throwable e) {
        if (e instanceof BlockException) {
            return;
        }
        Context context = ContextUtil.getContext();
        if (context == null) {
            return;
        }
        DefaultNode cuNode = (DefaultNode)context.getCurNode();
        if (cuNode == null) {
            return;
        }
        ClusterNode clusNode = cuNode.getClusterNode();
        if (clusNode == null) {
            return;
        }
        String customKey = ExceptionUtil.filterUnderlyingThrowable((Throwable)e).getClass().getName();
        clusNode.trace(customKey);
        ExceptionLogUtil.log((String)customKey);
    }

    static {
        try {
            InetAddress hostInfo = InetAddress.getLocalHost();
            ip = hostInfo.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }
}

