/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import com.alibaba.druid.util.StringUtils;
import java.lang.reflect.Array;
import java.text.Collator;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;

public class MapComparator<K, V>
implements Comparator<Map<K, V>> {
    private boolean isDesc;
    private K orderByKey;

    public MapComparator(K orderByKey, boolean isDesc) {
        this.orderByKey = orderByKey;
        this.isDesc = isDesc;
    }

    @Override
    private int compare(Number o1, Number o2) {
        return (int)(o1.doubleValue() - o2.doubleValue());
    }

    @Override
    private int compare(String o1, String o2) {
        return Collator.getInstance().compare(o1, o2);
    }

    @Override
    private int compare(Date o1, Date o2) {
        return (int)(o1.getTime() - o2.getTime());
    }

    @Override
    public int compare(Map<K, V> o1, Map<K, V> o2) {
        int result = this.compare_0(o1, o2);
        if (this.isDesc) {
            result = -result;
        }
        return result;
    }

    private Object getValueByKey(Map<K, V> map, K key) {
        String keyStr;
        if (key instanceof String && (keyStr = (String)key).matches(".+\\[[0-9]+\\]")) {
            V value = map.get(keyStr.substring(0, keyStr.indexOf(91)));
            if (value == null) {
                return null;
            }
            Integer index = StringUtils.subStringToInteger(keyStr, "[", "]");
            if (value.getClass().isArray() && Array.getLength(value) >= index) {
                return Array.get(value, index);
            }
            return null;
        }
        return map.get(key);
    }

    private int compare_0(Map<K, V> o1, Map<K, V> o2) {
        Object v1 = this.getValueByKey(o1, this.orderByKey);
        Object v2 = this.getValueByKey(o2, this.orderByKey);
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if (v1 instanceof Number) {
            return this.compare((Number)v1, (Number)v2);
        }
        if (v1 instanceof String) {
            return this.compare((String)v1, (String)v2);
        }
        if (v1 instanceof Date) {
            return this.compare((Date)v1, (Date)v2);
        }
        return 0;
    }
}

