/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.stat;

import com.alibaba.druid.stat.JdbcResultSetStatMBean;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class JdbcResultSetStat
implements JdbcResultSetStatMBean {
    private final AtomicInteger openingCount = new AtomicInteger();
    private final AtomicInteger openingMax = new AtomicInteger();
    private final AtomicLong openCount = new AtomicLong();
    private final AtomicLong errorCount = new AtomicLong();
    private final AtomicLong aliveNanoTotal = new AtomicLong();
    private final AtomicLong aliveNanoMax = new AtomicLong();
    private final AtomicLong aliveNanoMin = new AtomicLong();
    private Throwable lastError;
    private long lastErrorTime;
    private long lastOpenTime = 0L;
    private final AtomicLong fetchRowCount = new AtomicLong(0L);
    private final AtomicLong closeCount = new AtomicLong(0L);

    public void reset() {
        this.openingMax.set(0);
        this.openCount.set(0L);
        this.errorCount.set(0L);
        this.aliveNanoTotal.set(0L);
        this.aliveNanoMax.set(0L);
        this.aliveNanoMin.set(0L);
        this.lastError = null;
        this.lastErrorTime = 0L;
        this.lastOpenTime = 0L;
        this.fetchRowCount.set(0L);
        this.closeCount.set(0L);
    }

    public void beforeOpen() {
        int max;
        int invoking = this.openingCount.incrementAndGet();
        while (invoking > (max = this.openingMax.get()) && !this.openingMax.compareAndSet(max, invoking)) {
        }
        this.openCount.incrementAndGet();
        this.lastOpenTime = System.currentTimeMillis();
    }

    @Override
    public long getErrorCount() {
        return this.errorCount.get();
    }

    @Override
    public int getOpeningCount() {
        return this.openingCount.get();
    }

    @Override
    public int getOpeningMax() {
        return this.openingMax.get();
    }

    @Override
    public long getOpenCount() {
        return this.openCount.get();
    }

    public Date getLastOpenTime() {
        if (this.lastOpenTime == 0L) {
            return null;
        }
        return new Date(this.lastOpenTime);
    }

    public long getAliveNanoTotal() {
        return this.aliveNanoTotal.get();
    }

    public long getAliveMillisTotal() {
        return this.aliveNanoTotal.get() / 1000000L;
    }

    public long getAliveMilisMin() {
        return this.aliveNanoMin.get() / 1000000L;
    }

    public long getAliveMilisMax() {
        return this.aliveNanoMax.get() / 1000000L;
    }

    public void afterClose(long aliveNano) {
        long min;
        long max;
        this.openingCount.decrementAndGet();
        this.aliveNanoTotal.addAndGet(aliveNano);
        while (aliveNano > (max = this.aliveNanoMax.get()) && !this.aliveNanoMax.compareAndSet(max, aliveNano)) {
        }
        while (aliveNano < (min = this.aliveNanoMin.get()) && !this.aliveNanoMin.compareAndSet(min, aliveNano)) {
        }
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public Date getLastErrorTime() {
        if (this.lastErrorTime <= 0L) {
            return null;
        }
        return new Date(this.lastErrorTime);
    }

    public void error(Throwable error) {
        this.errorCount.incrementAndGet();
        this.lastError = error;
        this.lastErrorTime = System.currentTimeMillis();
    }

    @Override
    public long getHoldMillisTotal() {
        return this.getAliveNanoTotal() / 1000000L;
    }

    @Override
    public long getFetchRowCount() {
        return this.fetchRowCount.get();
    }

    @Override
    public long getCloseCount() {
        return this.closeCount.get();
    }

    public void addFetchRowCount(long fetchCount) {
        this.fetchRowCount.addAndGet(fetchCount);
    }

    public void incrementCloseCounter() {
        this.closeCount.incrementAndGet();
    }
}

