/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.protocol;

import com.alibaba.dashscope.utils.Constants;
import java.time.Duration;
import java.util.Arrays;

public final class ClientOptions {
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(120L);
    private static final Duration DEFAULT_WRITE_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofSeconds(300L);
    private static final Duration DEFAULT_CONNECTION_IDLE_TIMEOUT = Duration.ofSeconds(300L);
    private static final Integer DEFAULT_CONNECTION_POOL_SIZE = 5;
    private static final String DEFAULT_IMPLEMENTATION = "okhttp";
    private static final String DEFAULT_PROTOCOL = "https";
    private static final String DEFAULT_NETWORK_LOGGING_LEVEL = "NONE";
    private static final String DEFAULT_SDK_LOGGING_LEVEL = "WARN";
    private Duration connectTimeout;
    private Duration writeTimeout;
    private Duration responseTimeout;
    private Duration readTimeout;
    private Integer connectionPoolSize;
    private Duration connectionIdleTimeout;
    private String implementation;
    private String protocol;
    private String networkLoggingLevel;
    private String sdkLoggingLevel;
    private String webSocketEndpoint;

    public String getWebSocketEndpoint() {
        if (this.webSocketEndpoint == null) {
            return Constants.baseWebsocketApiUrl;
        }
        return this.webSocketEndpoint;
    }

    public Duration getConnectTimeout() {
        return this.getDuration(this.connectTimeout, DEFAULT_CONNECT_TIMEOUT, "DASHSCOPE_CONNECTION_TIMEOUT");
    }

    public Duration getWriteTimeout() {
        return this.getDuration(this.writeTimeout, DEFAULT_WRITE_TIMEOUT, "DASHSCOPE_WRITE_TIMEOUT");
    }

    public Duration getReadTimeout() {
        return this.getDuration(this.readTimeout, DEFAULT_READ_TIMEOUT, "DASHSCOPE_READ_TIMEOUT");
    }

    public Duration getConnectionIdelTimeout() {
        return this.getDuration(this.connectionIdleTimeout, DEFAULT_CONNECTION_IDLE_TIMEOUT, "DASHSCOPE_CONNECTION_IDLE_TIME");
    }

    public Integer getConnectionPoolSize() {
        try {
            Integer n = Integer.parseInt(System.getenv("DASHSCOPE_CONNECTION_POOL_SIZE"));
            return n;
        }
        catch (NumberFormatException e) {
            return DEFAULT_CONNECTION_POOL_SIZE;
        }
    }

    public String getImplementation() {
        if (this.implementation != null) {
            return this.implementation;
        }
        return DEFAULT_IMPLEMENTATION;
    }

    public String getProtocol() {
        if (this.protocol != null) {
            return this.protocol;
        }
        return DEFAULT_PROTOCOL;
    }

    public String getNetworkLoggingLevel() {
        if (this.networkLoggingLevel != null) {
            return this.networkLoggingLevel;
        }
        String logLevel = System.getenv().getOrDefault("DASHSCOPE_NETWORK_LOGGING_LEVEL", DEFAULT_NETWORK_LOGGING_LEVEL);
        if (Arrays.asList(DEFAULT_NETWORK_LOGGING_LEVEL, "BASIC", "HEADERS", "BODY").contains(logLevel)) {
            return logLevel;
        }
        return DEFAULT_NETWORK_LOGGING_LEVEL;
    }

    public String getSdkLoggingLevel() {
        if (this.sdkLoggingLevel != null) {
            return this.sdkLoggingLevel;
        }
        return System.getenv().getOrDefault("DASHSCOPE_SDK_LOGGING_LEVEL", DEFAULT_SDK_LOGGING_LEVEL);
    }

    private Duration getDuration(Duration target, Duration defaultValue, String env) {
        if (target == null) {
            try {
                long dur = Integer.parseInt(System.getenv(env));
                return Duration.ofSeconds(dur);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return target;
    }

    protected ClientOptions(ClientOptionsBuilder<?, ?> b) {
        this.connectTimeout = ((ClientOptionsBuilder)b).connectTimeout;
        this.writeTimeout = ((ClientOptionsBuilder)b).writeTimeout;
        this.responseTimeout = ((ClientOptionsBuilder)b).responseTimeout;
        this.readTimeout = ((ClientOptionsBuilder)b).readTimeout;
        this.connectionPoolSize = ((ClientOptionsBuilder)b).connectionPoolSize;
        this.connectionIdleTimeout = ((ClientOptionsBuilder)b).connectionIdleTimeout;
        this.implementation = ((ClientOptionsBuilder)b).implementation;
        this.protocol = ((ClientOptionsBuilder)b).protocol;
        this.networkLoggingLevel = ((ClientOptionsBuilder)b).networkLoggingLevel;
        this.sdkLoggingLevel = ((ClientOptionsBuilder)b).sdkLoggingLevel;
        this.webSocketEndpoint = ((ClientOptionsBuilder)b).webSocketEndpoint;
    }

    public static ClientOptionsBuilder<?, ?> builder() {
        return new ClientOptionsBuilderImpl();
    }

    public Duration getResponseTimeout() {
        return this.responseTimeout;
    }

    public Duration getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setWriteTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setResponseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setConnectionPoolSize(Integer connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public void setConnectionIdleTimeout(Duration connectionIdleTimeout) {
        this.connectionIdleTimeout = connectionIdleTimeout;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setNetworkLoggingLevel(String networkLoggingLevel) {
        this.networkLoggingLevel = networkLoggingLevel;
    }

    public void setSdkLoggingLevel(String sdkLoggingLevel) {
        this.sdkLoggingLevel = sdkLoggingLevel;
    }

    public void setWebSocketEndpoint(String webSocketEndpoint) {
        this.webSocketEndpoint = webSocketEndpoint;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientOptions)) {
            return false;
        }
        ClientOptions other = (ClientOptions)o;
        Integer this$connectionPoolSize = this.getConnectionPoolSize();
        Integer other$connectionPoolSize = other.getConnectionPoolSize();
        if (this$connectionPoolSize == null ? other$connectionPoolSize != null : !((Object)this$connectionPoolSize).equals(other$connectionPoolSize)) {
            return false;
        }
        Duration this$connectTimeout = this.getConnectTimeout();
        Duration other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Duration this$writeTimeout = this.getWriteTimeout();
        Duration other$writeTimeout = other.getWriteTimeout();
        if (this$writeTimeout == null ? other$writeTimeout != null : !((Object)this$writeTimeout).equals(other$writeTimeout)) {
            return false;
        }
        Duration this$responseTimeout = this.getResponseTimeout();
        Duration other$responseTimeout = other.getResponseTimeout();
        if (this$responseTimeout == null ? other$responseTimeout != null : !((Object)this$responseTimeout).equals(other$responseTimeout)) {
            return false;
        }
        Duration this$readTimeout = this.getReadTimeout();
        Duration other$readTimeout = other.getReadTimeout();
        if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
            return false;
        }
        Duration this$connectionIdleTimeout = this.getConnectionIdleTimeout();
        Duration other$connectionIdleTimeout = other.getConnectionIdleTimeout();
        if (this$connectionIdleTimeout == null ? other$connectionIdleTimeout != null : !((Object)this$connectionIdleTimeout).equals(other$connectionIdleTimeout)) {
            return false;
        }
        String this$implementation = this.getImplementation();
        String other$implementation = other.getImplementation();
        if (this$implementation == null ? other$implementation != null : !this$implementation.equals(other$implementation)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$networkLoggingLevel = this.getNetworkLoggingLevel();
        String other$networkLoggingLevel = other.getNetworkLoggingLevel();
        if (this$networkLoggingLevel == null ? other$networkLoggingLevel != null : !this$networkLoggingLevel.equals(other$networkLoggingLevel)) {
            return false;
        }
        String this$sdkLoggingLevel = this.getSdkLoggingLevel();
        String other$sdkLoggingLevel = other.getSdkLoggingLevel();
        if (this$sdkLoggingLevel == null ? other$sdkLoggingLevel != null : !this$sdkLoggingLevel.equals(other$sdkLoggingLevel)) {
            return false;
        }
        String this$webSocketEndpoint = this.getWebSocketEndpoint();
        String other$webSocketEndpoint = other.getWebSocketEndpoint();
        return !(this$webSocketEndpoint == null ? other$webSocketEndpoint != null : !this$webSocketEndpoint.equals(other$webSocketEndpoint));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $connectionPoolSize = this.getConnectionPoolSize();
        result = result * 59 + ($connectionPoolSize == null ? 43 : ((Object)$connectionPoolSize).hashCode());
        Duration $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Duration $writeTimeout = this.getWriteTimeout();
        result = result * 59 + ($writeTimeout == null ? 43 : ((Object)$writeTimeout).hashCode());
        Duration $responseTimeout = this.getResponseTimeout();
        result = result * 59 + ($responseTimeout == null ? 43 : ((Object)$responseTimeout).hashCode());
        Duration $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        Duration $connectionIdleTimeout = this.getConnectionIdleTimeout();
        result = result * 59 + ($connectionIdleTimeout == null ? 43 : ((Object)$connectionIdleTimeout).hashCode());
        String $implementation = this.getImplementation();
        result = result * 59 + ($implementation == null ? 43 : $implementation.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $networkLoggingLevel = this.getNetworkLoggingLevel();
        result = result * 59 + ($networkLoggingLevel == null ? 43 : $networkLoggingLevel.hashCode());
        String $sdkLoggingLevel = this.getSdkLoggingLevel();
        result = result * 59 + ($sdkLoggingLevel == null ? 43 : $sdkLoggingLevel.hashCode());
        String $webSocketEndpoint = this.getWebSocketEndpoint();
        result = result * 59 + ($webSocketEndpoint == null ? 43 : $webSocketEndpoint.hashCode());
        return result;
    }

    public String toString() {
        return "ClientOptions(connectTimeout=" + this.getConnectTimeout() + ", writeTimeout=" + this.getWriteTimeout() + ", responseTimeout=" + this.getResponseTimeout() + ", readTimeout=" + this.getReadTimeout() + ", connectionPoolSize=" + this.getConnectionPoolSize() + ", connectionIdleTimeout=" + this.getConnectionIdleTimeout() + ", implementation=" + this.getImplementation() + ", protocol=" + this.getProtocol() + ", networkLoggingLevel=" + this.getNetworkLoggingLevel() + ", sdkLoggingLevel=" + this.getSdkLoggingLevel() + ", webSocketEndpoint=" + this.getWebSocketEndpoint() + ")";
    }

    private static final class ClientOptionsBuilderImpl
    extends ClientOptionsBuilder<ClientOptions, ClientOptionsBuilderImpl> {
        private ClientOptionsBuilderImpl() {
        }

        @Override
        protected ClientOptionsBuilderImpl self() {
            return this;
        }

        @Override
        public ClientOptions build() {
            return new ClientOptions(this);
        }
    }

    public static abstract class ClientOptionsBuilder<C extends ClientOptions, B extends ClientOptionsBuilder<C, B>> {
        private Duration connectTimeout;
        private Duration writeTimeout;
        private Duration responseTimeout;
        private Duration readTimeout;
        private Integer connectionPoolSize;
        private Duration connectionIdleTimeout;
        private String implementation;
        private String protocol;
        private String networkLoggingLevel;
        private String sdkLoggingLevel;
        private String webSocketEndpoint;

        public B connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this.self();
        }

        public B writeTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this.self();
        }

        public B responseTimeout(Duration responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this.self();
        }

        public B readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this.self();
        }

        public B connectionPoolSize(Integer connectionPoolSize) {
            this.connectionPoolSize = connectionPoolSize;
            return this.self();
        }

        public B connectionIdleTimeout(Duration connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
            return this.self();
        }

        public B implementation(String implementation) {
            this.implementation = implementation;
            return this.self();
        }

        public B protocol(String protocol) {
            this.protocol = protocol;
            return this.self();
        }

        public B networkLoggingLevel(String networkLoggingLevel) {
            this.networkLoggingLevel = networkLoggingLevel;
            return this.self();
        }

        public B sdkLoggingLevel(String sdkLoggingLevel) {
            this.sdkLoggingLevel = sdkLoggingLevel;
            return this.self();
        }

        public B webSocketEndpoint(String webSocketEndpoint) {
            this.webSocketEndpoint = webSocketEndpoint;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "ClientOptions.ClientOptionsBuilder(connectTimeout=" + this.connectTimeout + ", writeTimeout=" + this.writeTimeout + ", responseTimeout=" + this.responseTimeout + ", readTimeout=" + this.readTimeout + ", connectionPoolSize=" + this.connectionPoolSize + ", connectionIdleTimeout=" + this.connectionIdleTimeout + ", implementation=" + this.implementation + ", protocol=" + this.protocol + ", networkLoggingLevel=" + this.networkLoggingLevel + ", sdkLoggingLevel=" + this.sdkLoggingLevel + ", webSocketEndpoint=" + this.webSocketEndpoint + ")";
        }
    }
}

