/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client;

import com.alibaba.csp.sentinel.cluster.ClusterTransportClient;
import com.alibaba.csp.sentinel.cluster.client.codec.netty.NettyRequestEncoder;
import com.alibaba.csp.sentinel.cluster.client.codec.netty.NettyResponseDecoder;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfigManager;
import com.alibaba.csp.sentinel.cluster.client.handler.TokenClientHandler;
import com.alibaba.csp.sentinel.cluster.client.handler.TokenClientPromiseHolder;
import com.alibaba.csp.sentinel.cluster.exception.SentinelClusterException;
import com.alibaba.csp.sentinel.cluster.request.ClusterRequest;
import com.alibaba.csp.sentinel.cluster.request.Request;
import com.alibaba.csp.sentinel.cluster.response.ClusterResponse;
import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.AssertUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.AbstractMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class NettyTransportClient
implements ClusterTransportClient {
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("sentinel-cluster-transport-client-scheduler"));
    public static final int RECONNECT_DELAY_MS = 2000;
    private final String host;
    private final int port;
    private Channel channel;
    private NioEventLoopGroup eventLoopGroup;
    private TokenClientHandler clientHandler;
    private final AtomicInteger idGenerator = new AtomicInteger(0);
    private final AtomicInteger currentState = new AtomicInteger(0);
    private final AtomicInteger failConnectedTime = new AtomicInteger(0);
    private final AtomicBoolean shouldRetry = new AtomicBoolean(true);
    private Runnable disconnectCallback = new Runnable(){

        @Override
        public void run() {
            if (!NettyTransportClient.this.shouldRetry.get()) {
                return;
            }
            SCHEDULER.schedule(new Runnable(){

                @Override
                public void run() {
                    if (NettyTransportClient.this.shouldRetry.get()) {
                        RecordLog.info((String)("[NettyTransportClient] Reconnecting to server <" + NettyTransportClient.this.host + ":" + NettyTransportClient.this.port + ">"), (Object[])new Object[0]);
                        try {
                            NettyTransportClient.this.startInternal();
                        }
                        catch (Exception e) {
                            RecordLog.warn((String)"[NettyTransportClient] Failed to reconnect to server", (Throwable)e);
                        }
                    }
                }
            }, (long)(2000 * (NettyTransportClient.this.failConnectedTime.get() + 1)), TimeUnit.MILLISECONDS);
            NettyTransportClient.this.cleanUp();
        }
    };
    private static final int MAX_ID = 999999999;

    public NettyTransportClient(String host, int port) {
        AssertUtil.assertNotBlank((String)host, (String)"remote host cannot be blank");
        AssertUtil.isTrue((port > 0 ? 1 : 0) != 0, (String)"port should be positive");
        this.host = host;
        this.port = port;
    }

    private Bootstrap initClientBootstrap() {
        Bootstrap b = new Bootstrap();
        this.eventLoopGroup = new NioEventLoopGroup();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)ClusterClientConfigManager.getConnectTimeout())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                NettyTransportClient.this.clientHandler = new TokenClientHandler(NettyTransportClient.this.currentState, NettyTransportClient.this.disconnectCallback);
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(1024, 0, 2, 0, 2)});
                pipeline.addLast(new ChannelHandler[]{new NettyResponseDecoder()});
                pipeline.addLast(new ChannelHandler[]{new LengthFieldPrepender(2)});
                pipeline.addLast(new ChannelHandler[]{new NettyRequestEncoder()});
                pipeline.addLast(new ChannelHandler[]{NettyTransportClient.this.clientHandler});
            }
        });
        return b;
    }

    private void connect(Bootstrap b) {
        if (this.currentState.compareAndSet(0, 1)) {
            b.connect(this.host, this.port).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                public void operationComplete(ChannelFuture future) {
                    if (future.cause() != null) {
                        RecordLog.warn((String)String.format("[NettyTransportClient] Could not connect to <%s:%d> after %d times", NettyTransportClient.this.host, NettyTransportClient.this.port, NettyTransportClient.this.failConnectedTime.get()), (Throwable)future.cause());
                        NettyTransportClient.this.failConnectedTime.incrementAndGet();
                        NettyTransportClient.this.channel = null;
                    } else {
                        NettyTransportClient.this.failConnectedTime.set(0);
                        NettyTransportClient.this.channel = future.channel();
                        RecordLog.info((String)("[NettyTransportClient] Successfully connect to server <" + NettyTransportClient.this.host + ":" + NettyTransportClient.this.port + ">"), (Object[])new Object[0]);
                    }
                }
            });
        }
    }

    public void start() throws Exception {
        this.shouldRetry.set(true);
        this.startInternal();
    }

    private void startInternal() {
        this.connect(this.initClientBootstrap());
    }

    private void cleanUp() {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        if (this.eventLoopGroup != null) {
            this.eventLoopGroup.shutdownGracefully();
        }
    }

    public void stop() throws Exception {
        this.shouldRetry.set(false);
        while (this.currentState.get() == 1) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
        this.cleanUp();
        this.failConnectedTime.set(0);
        RecordLog.info((String)"[NettyTransportClient] Cluster transport client stopped", (Object[])new Object[0]);
    }

    private boolean validRequest(Request request) {
        return request != null && request.getType() >= 0;
    }

    public boolean isReady() {
        return this.channel != null && this.clientHandler != null && this.clientHandler.hasStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterResponse sendRequest(ClusterRequest request) throws Exception {
        if (!this.isReady()) {
            throw new SentinelClusterException("client not ready (not running or initializing)");
        }
        if (!this.validRequest((Request)request)) {
            throw new SentinelClusterException("bad request");
        }
        int xid = this.getCurrentId();
        try {
            request.setId(xid);
            this.channel.writeAndFlush((Object)request);
            ChannelPromise promise = this.channel.newPromise();
            TokenClientPromiseHolder.putPromise(xid, promise);
            if (!promise.await((long)ClusterClientConfigManager.getRequestTimeout())) {
                throw new SentinelClusterException("request time out");
            }
            AbstractMap.SimpleEntry<ChannelPromise, ClusterResponse> entry = TokenClientPromiseHolder.getEntry(xid);
            if (entry == null || entry.getValue() == null) {
                throw new SentinelClusterException("unexpected status");
            }
            ClusterResponse clusterResponse = entry.getValue();
            return clusterResponse;
        }
        finally {
            TokenClientPromiseHolder.remove(xid);
        }
    }

    private int getCurrentId() {
        if (this.idGenerator.get() > 999999999) {
            this.idGenerator.set(0);
        }
        return this.idGenerator.incrementAndGet();
    }
}

