/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.handler;

import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfigManager;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import java.net.URLDecoder;

@CommandMapping(name="cluster/client/modifyConfig")
public class ModifyClusterClientConfigHandler
implements CommandHandler<String> {
    public CommandResponse<String> handle(CommandRequest request) {
        String data = request.getParam("data");
        if (StringUtil.isBlank((String)data)) {
            return CommandResponse.ofFailure((Throwable)new IllegalArgumentException("empty data"));
        }
        try {
            data = URLDecoder.decode(data, "utf-8");
            RecordLog.info((String)("[ModifyClusterClientConfigHandler] Receiving cluster client config: " + data), (Object[])new Object[0]);
            ClusterClientConfig clusterClientConfig = (ClusterClientConfig)JSON.parseObject((String)data, ClusterClientConfig.class);
            ClusterClientConfigManager.applyNewConfig(clusterClientConfig);
            return CommandResponse.ofSuccess((Object)"success");
        }
        catch (Exception e) {
            RecordLog.warn((String)"[ModifyClusterClientConfigHandler] Decode client cluster config error", (Throwable)e);
            return CommandResponse.ofFailure((Throwable)e, (Object)"decode client cluster config error");
        }
    }
}

