/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.registry;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.registry.NacosAutoServiceRegistration;
import com.alibaba.nacos.common.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.lang.NonNull;

public class NacosGracefulShutdownDelegate
implements ApplicationListener<ContextClosedEvent>,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(NacosGracefulShutdownDelegate.class);
    private final NacosAutoServiceRegistration autoServiceRegistration;
    private final NacosDiscoveryProperties nacosDiscoveryProperties;
    private ApplicationContext applicationContext;

    public NacosGracefulShutdownDelegate(NacosAutoServiceRegistration autoServiceRegistration, NacosDiscoveryProperties nacosDiscoveryProperties) {
        this.autoServiceRegistration = autoServiceRegistration;
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(@NonNull ContextClosedEvent event) {
        if (!this.applicationContext.equals(event.getApplicationContext())) {
            log.debug("Nacos client graceful shutdown will NOT be executed for Spring context source: {}", (Object)event.getApplicationContext());
            return;
        }
        this.doGracefulShutdown();
    }

    protected void doGracefulShutdown() {
        try {
            this.autoServiceRegistration.stop();
            Integer gracefulShutdownWaitTime = this.nacosDiscoveryProperties.getGracefulShutdownWaitTime();
            if (gracefulShutdownWaitTime != null && gracefulShutdownWaitTime > 0) {
                ThreadUtils.sleep((long)gracefulShutdownWaitTime.intValue());
                log.info("Nacos client graceful shutdown has been executed successfully. Graceful shutdown wait time is {}", (Object)gracefulShutdownWaitTime);
            }
        }
        catch (Throwable t) {
            log.error("Error occurred while performing Nacos client graceful shutdown", t);
        }
    }

    public boolean supportsAsyncExecution() {
        return false;
    }
}

