/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alicloud.oss.endpoint;

import com.aliyun.oss.OSSClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.ApplicationContext;

@Endpoint(id="oss")
public class OssEndpoint {
    @Autowired
    private ApplicationContext applicationContext;

    @ReadOperation
    public Map<String, Object> invoke() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map ossClientMap = this.applicationContext.getBeansOfType(OSSClient.class);
        int size = ossClientMap.size();
        ArrayList ossClientList = new ArrayList();
        ossClientMap.keySet().forEach(beanName -> {
            HashMap<String, Object> ossProperties = new HashMap<String, Object>();
            OSSClient client = (OSSClient)ossClientMap.get(beanName);
            ossProperties.put("beanName", beanName);
            ossProperties.put("endpoint", client.getEndpoint().toString());
            ossProperties.put("clientConfiguration", client.getClientConfiguration());
            ossProperties.put("credentials", client.getCredentialsProvider().getCredentials());
            ossProperties.put("bucketList", client.listBuckets().stream().map(bucket -> bucket.getName()).toArray());
            ossClientList.add(ossProperties);
        });
        result.put("size", size);
        result.put("info", ossClientList);
        return result;
    }
}

