/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.searches;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum SearchEnum {
    TAVILY("tavily", "tavilySearch"),
    BAIDU("baidu", "baiduSearch"),
    SERPAPI("serpapi", "serpApiSearch"),
    ALIYUN("aliyun", "aliyunAiSearch"),
    METASO("metaso", "metasoService");

    private final String name;
    private final String toolName;

    private SearchEnum(String name, String toolName) {
        this.name = name;
        this.toolName = toolName;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public String getToolName() {
        return this.toolName;
    }

    public String toString() {
        return "SearchEnum{name='" + this.name + "', toolName='" + this.toolName + "'}";
    }

    @JsonCreator
    public static SearchEnum fromName(String name) {
        for (SearchEnum searchEnum : SearchEnum.values()) {
            if (!searchEnum.getName().equalsIgnoreCase(name)) continue;
            return searchEnum;
        }
        throw new IllegalArgumentException("Invalid Search name: " + name);
    }

    public static SearchEnum fromToolName(String toolName) {
        for (SearchEnum searchEnum : SearchEnum.values()) {
            if (!searchEnum.getToolName().equals(toolName)) continue;
            return searchEnum;
        }
        throw new IllegalArgumentException("Invalid Search tool name: " + toolName);
    }
}

