/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.handler;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskLogConverter;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLog;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CallbackRetryTaskHandler {
    private static final Logger log = LoggerFactory.getLogger(CallbackRetryTaskHandler.class);
    private static final String CALLBACK_UNIQUE_ID_RULE = "{}_{}";
    @Autowired
    protected AccessTemplate accessTemplate;
    @Autowired
    private RetryTaskLogMapper retryTaskLogMapper;
    @Autowired
    private SystemProperties systemProperties;

    @Transactional
    public void create(RetryTask retryTask) {
        if (!SyetemTaskTypeEnum.RETRY.getType().equals(retryTask.getTaskType())) {
            return;
        }
        RetryTask callbackRetryTask = RetryTaskConverter.INSTANCE.toRetryTask(retryTask);
        callbackRetryTask.setTaskType(SyetemTaskTypeEnum.CALLBACK.getType());
        callbackRetryTask.setId(null);
        callbackRetryTask.setUniqueId(this.generatorCallbackUniqueId(retryTask.getUniqueId()));
        callbackRetryTask.setRetryStatus(RetryStatusEnum.RUNNING.getStatus());
        callbackRetryTask.setRetryCount(Integer.valueOf(0));
        callbackRetryTask.setCreateDt(LocalDateTime.now());
        callbackRetryTask.setUpdateDt(LocalDateTime.now());
        long triggerInterval = this.systemProperties.getCallback().getTriggerInterval();
        WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)WaitStrategies.WaitStrategyEnum.FIXED.getType());
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        waitStrategyContext.setNextTriggerAt(DateUtils.toNowMilli());
        waitStrategyContext.setTriggerInterval(String.valueOf(triggerInterval));
        callbackRetryTask.setNextTriggerAt(DateUtils.toLocalDateTime((long)waitStrategy.computeTriggerTime(waitStrategyContext)));
        try {
            Assert.isTrue((1 == this.accessTemplate.getRetryTaskAccess().insert(callbackRetryTask.getGroupName(), callbackRetryTask.getNamespaceId(), (Object)callbackRetryTask) ? 1 : 0) != 0, () -> new SnailJobServerException("failed to report data"));
        }
        catch (DuplicateKeyException e) {
            log.warn("\u56de\u8c03\u6570\u636e\u91cd\u590d\u65b0\u589e. [{}]", (Object)JsonUtil.toJsonString((Object)retryTask));
            return;
        }
        RetryTaskLog retryTaskLog = RetryTaskLogConverter.INSTANCE.toRetryTask(callbackRetryTask);
        retryTaskLog.setTaskType(SyetemTaskTypeEnum.CALLBACK.getType());
        retryTaskLog.setCreateDt(LocalDateTime.now());
        Assert.isTrue((1 == this.retryTaskLogMapper.insert((Object)retryTaskLog) ? 1 : 0) != 0, () -> new SnailJobServerException("\u65b0\u589e\u91cd\u8bd5\u65e5\u5fd7\u5931\u8d25"));
    }

    public String generatorCallbackUniqueId(String uniqueId) {
        FormattingTuple callbackUniqueId = MessageFormatter.arrayFormat((String)CALLBACK_UNIQUE_ID_RULE, (Object[])new Object[]{this.systemProperties.getCallback().getPrefix(), uniqueId});
        return callbackUniqueId.getMessage();
    }

    public String getRetryTaskUniqueId(String callbackTaskUniqueId) {
        return callbackTaskUniqueId.substring(callbackTaskUniqueId.lastIndexOf("_") + 1);
    }
}

