/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.prepare.workflow;

import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.JobBlockStrategyEnum;
import com.aizuda.snailjob.common.core.enums.JobNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.dto.WorkflowTaskFailAlarmEventDTO;
import com.aizuda.snailjob.server.job.task.dto.WorkflowTaskPrepareDTO;
import com.aizuda.snailjob.server.job.task.support.BlockStrategy;
import com.aizuda.snailjob.server.job.task.support.WorkflowTaskConverter;
import com.aizuda.snailjob.server.job.task.support.alarm.event.WorkflowTaskFailAlarmEvent;
import com.aizuda.snailjob.server.job.task.support.block.workflow.WorkflowBlockStrategyContext;
import com.aizuda.snailjob.server.job.task.support.block.workflow.WorkflowBlockStrategyFactory;
import com.aizuda.snailjob.server.job.task.support.handler.WorkflowBatchHandler;
import com.aizuda.snailjob.server.job.task.support.prepare.workflow.AbstractWorkflowPrePareHandler;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;

@Component
public class RunningWorkflowPrepareHandler
extends AbstractWorkflowPrePareHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RunningWorkflowPrepareHandler.class);
    private final WorkflowBatchHandler workflowBatchHandler;

    @Override
    public boolean matches(Integer status) {
        return Objects.nonNull(status) && JobTaskBatchStatusEnum.RUNNING.getStatus() == status.intValue();
    }

    @Override
    protected void doHandler(WorkflowTaskPrepareDTO prepare) {
        log.debug("Running tasks exist. Prepare:[{}]", (Object)JsonUtil.toJsonString((Object)prepare));
        int blockStrategy = prepare.getBlockStrategy();
        if (this.workflowBatchHandler.complete(prepare.getWorkflowTaskBatchId())) {
            blockStrategy = JobBlockStrategyEnum.CONCURRENCY.getBlockStrategy();
        } else {
            long delay = DateUtils.toNowMilli() - prepare.getExecutionAt();
            if (delay > DateUtils.toEpochMilli((long)prepare.getExecutorTimeout().intValue())) {
                this.workflowBatchHandler.stop(prepare.getWorkflowTaskBatchId(), JobOperationReasonEnum.TASK_EXECUTION_TIMEOUT.getReason());
                String reason = String.format("Task execution timeout. Workflow task batch ID:[%s] Delay:[%s] Executor timeout:[%s]", prepare.getWorkflowTaskBatchId(), delay, DateUtils.toEpochMilli((long)prepare.getExecutorTimeout().intValue()));
                SnailSpringContext.getContext().publishEvent((ApplicationEvent)new WorkflowTaskFailAlarmEvent(WorkflowTaskFailAlarmEventDTO.builder().workflowTaskBatchId(prepare.getWorkflowTaskBatchId()).notifyScene(JobNotifySceneEnum.WORKFLOW_TASK_ERROR.getNotifyScene()).reason(reason).build()));
                log.info(reason);
            }
        }
        if (prepare.isOnlyTimeoutCheck()) {
            return;
        }
        BlockStrategy blockStrategyInterface = WorkflowBlockStrategyFactory.getBlockStrategy(blockStrategy);
        WorkflowBlockStrategyContext workflowBlockStrategyContext = WorkflowTaskConverter.INSTANCE.toWorkflowBlockStrategyContext(prepare);
        blockStrategyInterface.block(workflowBlockStrategyContext);
    }

    @Generated
    public RunningWorkflowPrepareHandler(WorkflowBatchHandler workflowBatchHandler) {
        this.workflowBatchHandler = workflowBatchHandler;
    }
}

