/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataframeAnalyticsFieldSelection
implements JsonpSerializable {
    private final boolean isIncluded;
    private final boolean isRequired;
    @Nullable
    private final String featureType;
    private final List<String> mappingTypes;
    private final String name;
    @Nullable
    private final String reason;
    public static final JsonpDeserializer<DataframeAnalyticsFieldSelection> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalyticsFieldSelection::setupDataframeAnalyticsFieldSelectionDeserializer);

    private DataframeAnalyticsFieldSelection(Builder builder) {
        this.isIncluded = ApiTypeHelper.requireNonNull(builder.isIncluded, this, "isIncluded");
        this.isRequired = ApiTypeHelper.requireNonNull(builder.isRequired, this, "isRequired");
        this.featureType = builder.featureType;
        this.mappingTypes = ApiTypeHelper.unmodifiableRequired(builder.mappingTypes, (Object)this, "mappingTypes");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.reason = builder.reason;
    }

    public static DataframeAnalyticsFieldSelection of(Function<Builder, ObjectBuilder<DataframeAnalyticsFieldSelection>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean isIncluded() {
        return this.isIncluded;
    }

    public final boolean isRequired() {
        return this.isRequired;
    }

    @Nullable
    public final String featureType() {
        return this.featureType;
    }

    public final List<String> mappingTypes() {
        return this.mappingTypes;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final String reason() {
        return this.reason;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("is_included");
        generator.write(this.isIncluded);
        generator.writeKey("is_required");
        generator.write(this.isRequired);
        if (this.featureType != null) {
            generator.writeKey("feature_type");
            generator.write(this.featureType);
        }
        if (ApiTypeHelper.isDefined(this.mappingTypes)) {
            generator.writeKey("mapping_types");
            generator.writeStartArray();
            for (String item0 : this.mappingTypes) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("name");
        generator.write(this.name);
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
    }

    protected static void setupDataframeAnalyticsFieldSelectionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::isIncluded, JsonpDeserializer.booleanDeserializer(), "is_included");
        op.add(Builder::isRequired, JsonpDeserializer.booleanDeserializer(), "is_required");
        op.add(Builder::featureType, JsonpDeserializer.stringDeserializer(), "feature_type");
        op.add(Builder::mappingTypes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "mapping_types");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataframeAnalyticsFieldSelection> {
        private Boolean isIncluded;
        private Boolean isRequired;
        @Nullable
        private String featureType;
        private List<String> mappingTypes;
        private String name;
        @Nullable
        private String reason;

        public final Builder isIncluded(boolean value) {
            this.isIncluded = value;
            return this;
        }

        public final Builder isRequired(boolean value) {
            this.isRequired = value;
            return this;
        }

        public final Builder featureType(@Nullable String value) {
            this.featureType = value;
            return this;
        }

        public final Builder mappingTypes(List<String> list) {
            this.mappingTypes = Builder._listAddAll(this.mappingTypes, list);
            return this;
        }

        public final Builder mappingTypes(String value, String ... values) {
            this.mappingTypes = Builder._listAdd(this.mappingTypes, value, values);
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeAnalyticsFieldSelection build() {
            this._checkSingleUse();
            return new DataframeAnalyticsFieldSelection(this);
        }
    }
}

