/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyQuery;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyQueryVariant;
import co.elastic.clients.elasticsearch.security.query_role.RoleQuery;
import co.elastic.clients.elasticsearch.security.query_role.RoleQueryVariant;
import co.elastic.clients.elasticsearch.security.query_user.UserQuery;
import co.elastic.clients.elasticsearch.security.query_user.UserQueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TermQuery
extends QueryBase
implements ApiKeyQueryVariant,
QueryVariant,
RoleQueryVariant,
UserQueryVariant {
    private final String field;
    private final FieldValue value;
    @Nullable
    private final Boolean caseInsensitive;
    public static final JsonpDeserializer<TermQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermQuery::setupTermQueryDeserializer);

    private TermQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
        this.caseInsensitive = builder.caseInsensitive;
    }

    public static TermQuery of(Function<Builder, ObjectBuilder<TermQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public ApiKeyQuery.Kind _apiKeyQueryKind() {
        return ApiKeyQuery.Kind.Term;
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Term;
    }

    @Override
    public RoleQuery.Kind _roleQueryKind() {
        return RoleQuery.Kind.Term;
    }

    @Override
    public UserQuery.Kind _userQueryKind() {
        return UserQuery.Kind.Term;
    }

    public final String field() {
        return this.field;
    }

    public final FieldValue value() {
        return this.value;
    }

    @Nullable
    public final Boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        generator.writeKey("value");
        this.value.serialize(generator, mapper);
        if (this.caseInsensitive != null) {
            generator.writeKey("case_insensitive");
            generator.write(this.caseInsensitive.booleanValue());
        }
        generator.writeEnd();
    }

    protected static void setupTermQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::value, FieldValue._DESERIALIZER, "value");
        op.add(Builder::caseInsensitive, JsonpDeserializer.booleanDeserializer(), "case_insensitive");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
        op.shortcutProperty("value", true);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TermQuery> {
        private String field;
        private FieldValue value;
        @Nullable
        private Boolean caseInsensitive;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder value(FieldValue value) {
            this.value = value;
            return this;
        }

        public final Builder value(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.value(fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder value(String value) {
            this.value = FieldValue.of(value);
            return this;
        }

        public final Builder value(long value) {
            this.value = FieldValue.of(value);
            return this;
        }

        public final Builder value(double value) {
            this.value = FieldValue.of(value);
            return this;
        }

        public final Builder value(boolean value) {
            this.value = FieldValue.of(value);
            return this;
        }

        public final Builder caseInsensitive(@Nullable Boolean value) {
            this.caseInsensitive = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TermQuery build() {
            this._checkSingleUse();
            return new TermQuery(this);
        }
    }
}

