/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Collector
implements JsonpSerializable {
    private final String name;
    private final String reason;
    private final long timeInNanos;
    private final List<Collector> children;
    public static final JsonpDeserializer<Collector> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Collector::setupCollectorDeserializer);

    private Collector(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
        this.timeInNanos = ApiTypeHelper.requireNonNull(builder.timeInNanos, this, "timeInNanos");
        this.children = ApiTypeHelper.unmodifiable(builder.children);
    }

    public static Collector of(Function<Builder, ObjectBuilder<Collector>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final String reason() {
        return this.reason;
    }

    public final long timeInNanos() {
        return this.timeInNanos;
    }

    public final List<Collector> children() {
        return this.children;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("reason");
        generator.write(this.reason);
        generator.writeKey("time_in_nanos");
        generator.write(this.timeInNanos);
        if (ApiTypeHelper.isDefined(this.children)) {
            generator.writeKey("children");
            generator.writeStartArray();
            for (Collector item0 : this.children) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupCollectorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::timeInNanos, JsonpDeserializer.longDeserializer(), "time_in_nanos");
        op.add(Builder::children, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "children");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Collector> {
        private String name;
        private String reason;
        private Long timeInNanos;
        @Nullable
        private List<Collector> children;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder reason(String value) {
            this.reason = value;
            return this;
        }

        public final Builder timeInNanos(long value) {
            this.timeInNanos = value;
            return this;
        }

        public final Builder children(List<Collector> list) {
            this.children = Builder._listAddAll(this.children, list);
            return this;
        }

        public final Builder children(Collector value, Collector ... values) {
            this.children = Builder._listAdd(this.children, value, values);
            return this;
        }

        public final Builder children(Function<Builder, ObjectBuilder<Collector>> fn) {
            return this.children(fn.apply(new Builder()).build(), new Collector[0]);
        }

        @Override
        public Collector build() {
            this._checkSingleUse();
            return new Collector(this);
        }
    }
}

