/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.util;

import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.util.NoCopyByteArrayOutputStream;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public interface BinaryData {
    public void writeTo(OutputStream var1) throws IOException;

    public ByteBuffer asByteBuffer();

    public long size();

    public static BinaryData of(Object value, JsonpMapper mapper) {
        if (value == null) {
            return null;
        }
        if (value instanceof BinaryData) {
            return (BinaryData)value;
        }
        NoCopyByteArrayOutputStream out = new NoCopyByteArrayOutputStream();
        JsonGenerator generator = mapper.jsonProvider().createGenerator((OutputStream)out);
        mapper.serialize(value, generator);
        generator.close();
        return new ByteArrayBinaryData(out.array(), 0, out.size());
    }

    public static BinaryData of(byte[] bytes) {
        return new ByteArrayBinaryData(bytes, 0, bytes.length);
    }

    public static BinaryData of(byte[] value, int offset, int length) {
        return new ByteArrayBinaryData(value, offset, length);
    }

    public static class ByteArrayBinaryData
    implements BinaryData {
        private final byte[] bytes;
        private final int offset;
        private final int length;

        ByteArrayBinaryData(byte[] bytes, int offset, int length) {
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            out.write(this.bytes, this.offset, this.length);
        }

        @Override
        public long size() {
            return this.length;
        }

        @Override
        public ByteBuffer asByteBuffer() {
            return ByteBuffer.wrap(this.bytes, this.offset, this.length);
        }
    }
}

