/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup.delete_job;

import co.elastic.clients.elasticsearch.rollup.delete_job.TaskFailureReason;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TaskFailure
implements JsonpSerializable {
    private final String taskId;
    private final String nodeId;
    private final String status;
    private final TaskFailureReason reason;
    public static final JsonpDeserializer<TaskFailure> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TaskFailure::setupTaskFailureDeserializer);

    private TaskFailure(Builder builder) {
        this.taskId = ApiTypeHelper.requireNonNull(builder.taskId, this, "taskId");
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
    }

    public static TaskFailure of(Function<Builder, ObjectBuilder<TaskFailure>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String taskId() {
        return this.taskId;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final String status() {
        return this.status;
    }

    public final TaskFailureReason reason() {
        return this.reason;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("task_id");
        generator.write(this.taskId);
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("status");
        generator.write(this.status);
        generator.writeKey("reason");
        this.reason.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTaskFailureDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::taskId, JsonpDeserializer.stringDeserializer(), "task_id");
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
        op.add(Builder::status, JsonpDeserializer.stringDeserializer(), "status");
        op.add(Builder::reason, TaskFailureReason._DESERIALIZER, "reason");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TaskFailure> {
        private String taskId;
        private String nodeId;
        private String status;
        private TaskFailureReason reason;

        public final Builder taskId(String value) {
            this.taskId = value;
            return this;
        }

        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public final Builder status(String value) {
            this.status = value;
            return this;
        }

        public final Builder reason(TaskFailureReason value) {
            this.reason = value;
            return this;
        }

        public final Builder reason(Function<TaskFailureReason.Builder, ObjectBuilder<TaskFailureReason>> fn) {
            return this.reason(fn.apply(new TaskFailureReason.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TaskFailure build() {
            this._checkSingleUse();
            return new TaskFailure(this);
        }
    }
}

