/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponseBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SplitResponse
extends AcknowledgedResponseBase {
    private final boolean shardsAcknowledged;
    private final String index;
    public static final JsonpDeserializer<SplitResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SplitResponse::setupSplitResponseDeserializer);

    private SplitResponse(Builder builder) {
        super(builder);
        this.shardsAcknowledged = ApiTypeHelper.requireNonNull(builder.shardsAcknowledged, this, "shardsAcknowledged");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
    }

    public static SplitResponse of(Function<Builder, ObjectBuilder<SplitResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean shardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    public final String index() {
        return this.index;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("shards_acknowledged");
        generator.write(this.shardsAcknowledged);
        generator.writeKey("index");
        generator.write(this.index);
    }

    protected static void setupSplitResponseDeserializer(ObjectDeserializer<Builder> op) {
        AcknowledgedResponseBase.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(Builder::shardsAcknowledged, JsonpDeserializer.booleanDeserializer(), "shards_acknowledged");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
    }

    public static class Builder
    extends AcknowledgedResponseBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SplitResponse> {
        private Boolean shardsAcknowledged;
        private String index;

        public final Builder shardsAcknowledged(boolean value) {
            this.shardsAcknowledged = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SplitResponse build() {
            this._checkSingleUse();
            return new SplitResponse(this);
        }
    }
}

