/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.elasticsearch._types.aggregations.StandardDeviationBounds;
import co.elastic.clients.elasticsearch._types.aggregations.StandardDeviationBoundsAsString;
import co.elastic.clients.elasticsearch._types.aggregations.StatsAggregate;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ExtendedStatsAggregate
extends StatsAggregate
implements AggregateVariant {
    private final double sumOfSquares;
    private final double variance;
    private final double variancePopulation;
    private final double varianceSampling;
    private final double stdDeviation;
    private final double stdDeviationPopulation;
    private final double stdDeviationSampling;
    @Nullable
    private final StandardDeviationBounds stdDeviationBounds;
    @Nullable
    private final String sumOfSquaresAsString;
    @Nullable
    private final String varianceAsString;
    @Nullable
    private final String variancePopulationAsString;
    @Nullable
    private final String varianceSamplingAsString;
    @Nullable
    private final String stdDeviationAsString;
    @Nullable
    private final StandardDeviationBoundsAsString stdDeviationBoundsAsString;
    public static final JsonpDeserializer<ExtendedStatsAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExtendedStatsAggregate::setupExtendedStatsAggregateDeserializer);

    protected ExtendedStatsAggregate(AbstractBuilder<?> builder) {
        super((StatsAggregate.AbstractBuilder<?>)builder);
        this.sumOfSquares = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).sumOfSquares, this, "sumOfSquares");
        this.variance = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).variance, this, "variance");
        this.variancePopulation = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).variancePopulation, this, "variancePopulation");
        this.varianceSampling = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).varianceSampling, this, "varianceSampling");
        this.stdDeviation = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).stdDeviation, this, "stdDeviation");
        this.stdDeviationPopulation = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).stdDeviationPopulation, this, "stdDeviationPopulation");
        this.stdDeviationSampling = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).stdDeviationSampling, this, "stdDeviationSampling");
        this.stdDeviationBounds = ((AbstractBuilder)builder).stdDeviationBounds;
        this.sumOfSquaresAsString = ((AbstractBuilder)builder).sumOfSquaresAsString;
        this.varianceAsString = ((AbstractBuilder)builder).varianceAsString;
        this.variancePopulationAsString = ((AbstractBuilder)builder).variancePopulationAsString;
        this.varianceSamplingAsString = ((AbstractBuilder)builder).varianceSamplingAsString;
        this.stdDeviationAsString = ((AbstractBuilder)builder).stdDeviationAsString;
        this.stdDeviationBoundsAsString = ((AbstractBuilder)builder).stdDeviationBoundsAsString;
    }

    public static ExtendedStatsAggregate extendedStatsAggregateOf(Function<Builder, ObjectBuilder<ExtendedStatsAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.ExtendedStats;
    }

    public final double sumOfSquares() {
        return this.sumOfSquares;
    }

    public final double variance() {
        return this.variance;
    }

    public final double variancePopulation() {
        return this.variancePopulation;
    }

    public final double varianceSampling() {
        return this.varianceSampling;
    }

    public final double stdDeviation() {
        return this.stdDeviation;
    }

    public final double stdDeviationPopulation() {
        return this.stdDeviationPopulation;
    }

    public final double stdDeviationSampling() {
        return this.stdDeviationSampling;
    }

    @Nullable
    public final StandardDeviationBounds stdDeviationBounds() {
        return this.stdDeviationBounds;
    }

    @Nullable
    public final String sumOfSquaresAsString() {
        return this.sumOfSquaresAsString;
    }

    @Nullable
    public final String varianceAsString() {
        return this.varianceAsString;
    }

    @Nullable
    public final String variancePopulationAsString() {
        return this.variancePopulationAsString;
    }

    @Nullable
    public final String varianceSamplingAsString() {
        return this.varianceSamplingAsString;
    }

    @Nullable
    public final String stdDeviationAsString() {
        return this.stdDeviationAsString;
    }

    @Nullable
    public final StandardDeviationBoundsAsString stdDeviationBoundsAsString() {
        return this.stdDeviationBoundsAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("sum_of_squares");
        JsonpUtils.serializeDoubleOrNull(generator, this.sumOfSquares, 0.0);
        generator.writeKey("variance");
        JsonpUtils.serializeDoubleOrNull(generator, this.variance, 0.0);
        generator.writeKey("variance_population");
        JsonpUtils.serializeDoubleOrNull(generator, this.variancePopulation, 0.0);
        generator.writeKey("variance_sampling");
        JsonpUtils.serializeDoubleOrNull(generator, this.varianceSampling, 0.0);
        generator.writeKey("std_deviation");
        JsonpUtils.serializeDoubleOrNull(generator, this.stdDeviation, 0.0);
        generator.writeKey("std_deviation_population");
        JsonpUtils.serializeDoubleOrNull(generator, this.stdDeviationPopulation, 0.0);
        generator.writeKey("std_deviation_sampling");
        JsonpUtils.serializeDoubleOrNull(generator, this.stdDeviationSampling, 0.0);
        if (this.stdDeviationBounds != null) {
            generator.writeKey("std_deviation_bounds");
            this.stdDeviationBounds.serialize(generator, mapper);
        }
        if (this.sumOfSquaresAsString != null) {
            generator.writeKey("sum_of_squares_as_string");
            generator.write(this.sumOfSquaresAsString);
        }
        if (this.varianceAsString != null) {
            generator.writeKey("variance_as_string");
            generator.write(this.varianceAsString);
        }
        if (this.variancePopulationAsString != null) {
            generator.writeKey("variance_population_as_string");
            generator.write(this.variancePopulationAsString);
        }
        if (this.varianceSamplingAsString != null) {
            generator.writeKey("variance_sampling_as_string");
            generator.write(this.varianceSamplingAsString);
        }
        if (this.stdDeviationAsString != null) {
            generator.writeKey("std_deviation_as_string");
            generator.write(this.stdDeviationAsString);
        }
        if (this.stdDeviationBoundsAsString != null) {
            generator.writeKey("std_deviation_bounds_as_string");
            this.stdDeviationBoundsAsString.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupExtendedStatsAggregateDeserializer(ObjectDeserializer<BuilderT> op) {
        StatsAggregate.setupStatsAggregateDeserializer(op);
        op.add(AbstractBuilder::sumOfSquares, JsonpDeserializer.doubleOrNullDeserializer(0.0), "sum_of_squares");
        op.add(AbstractBuilder::variance, JsonpDeserializer.doubleOrNullDeserializer(0.0), "variance");
        op.add(AbstractBuilder::variancePopulation, JsonpDeserializer.doubleOrNullDeserializer(0.0), "variance_population");
        op.add(AbstractBuilder::varianceSampling, JsonpDeserializer.doubleOrNullDeserializer(0.0), "variance_sampling");
        op.add(AbstractBuilder::stdDeviation, JsonpDeserializer.doubleOrNullDeserializer(0.0), "std_deviation");
        op.add(AbstractBuilder::stdDeviationPopulation, JsonpDeserializer.doubleOrNullDeserializer(0.0), "std_deviation_population");
        op.add(AbstractBuilder::stdDeviationSampling, JsonpDeserializer.doubleOrNullDeserializer(0.0), "std_deviation_sampling");
        op.add(AbstractBuilder::stdDeviationBounds, StandardDeviationBounds._DESERIALIZER, "std_deviation_bounds");
        op.add(AbstractBuilder::sumOfSquaresAsString, JsonpDeserializer.stringDeserializer(), "sum_of_squares_as_string");
        op.add(AbstractBuilder::varianceAsString, JsonpDeserializer.stringDeserializer(), "variance_as_string");
        op.add(AbstractBuilder::variancePopulationAsString, JsonpDeserializer.stringDeserializer(), "variance_population_as_string");
        op.add(AbstractBuilder::varianceSamplingAsString, JsonpDeserializer.stringDeserializer(), "variance_sampling_as_string");
        op.add(AbstractBuilder::stdDeviationAsString, JsonpDeserializer.stringDeserializer(), "std_deviation_as_string");
        op.add(AbstractBuilder::stdDeviationBoundsAsString, StandardDeviationBoundsAsString._DESERIALIZER, "std_deviation_bounds_as_string");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends StatsAggregate.AbstractBuilder<BuilderT> {
        private Double sumOfSquares;
        private Double variance;
        private Double variancePopulation;
        private Double varianceSampling;
        private Double stdDeviation;
        private Double stdDeviationPopulation;
        private Double stdDeviationSampling;
        @Nullable
        private StandardDeviationBounds stdDeviationBounds;
        @Nullable
        private String sumOfSquaresAsString;
        @Nullable
        private String varianceAsString;
        @Nullable
        private String variancePopulationAsString;
        @Nullable
        private String varianceSamplingAsString;
        @Nullable
        private String stdDeviationAsString;
        @Nullable
        private StandardDeviationBoundsAsString stdDeviationBoundsAsString;

        protected AbstractBuilder() {
        }

        public final BuilderT sumOfSquares(double value) {
            this.sumOfSquares = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT variance(double value) {
            this.variance = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT variancePopulation(double value) {
            this.variancePopulation = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT varianceSampling(double value) {
            this.varianceSampling = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT stdDeviation(double value) {
            this.stdDeviation = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT stdDeviationPopulation(double value) {
            this.stdDeviationPopulation = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT stdDeviationSampling(double value) {
            this.stdDeviationSampling = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT stdDeviationBounds(@Nullable StandardDeviationBounds value) {
            this.stdDeviationBounds = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT stdDeviationBounds(Function<StandardDeviationBounds.Builder, ObjectBuilder<StandardDeviationBounds>> fn) {
            return this.stdDeviationBounds(fn.apply(new StandardDeviationBounds.Builder()).build());
        }

        public final BuilderT sumOfSquaresAsString(@Nullable String value) {
            this.sumOfSquaresAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT varianceAsString(@Nullable String value) {
            this.varianceAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT variancePopulationAsString(@Nullable String value) {
            this.variancePopulationAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT varianceSamplingAsString(@Nullable String value) {
            this.varianceSamplingAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT stdDeviationAsString(@Nullable String value) {
            this.stdDeviationAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT stdDeviationBoundsAsString(@Nullable StandardDeviationBoundsAsString value) {
            this.stdDeviationBoundsAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT stdDeviationBoundsAsString(Function<StandardDeviationBoundsAsString.Builder, ObjectBuilder<StandardDeviationBoundsAsString>> fn) {
            return this.stdDeviationBoundsAsString(fn.apply(new StandardDeviationBoundsAsString.Builder()).build());
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<ExtendedStatsAggregate> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExtendedStatsAggregate build() {
            this._checkSingleUse();
            return new ExtendedStatsAggregate(this);
        }
    }
}

