/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch.tasks.Info;
import co.elastic.clients.elasticsearch.tasks.TaskExecutingNode;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ListResponse
implements JsonpSerializable {
    private final List<ErrorCause> nodeFailures;
    private final Map<String, TaskExecutingNode> nodes;
    private final Map<String, Info> tasks;
    public static final JsonpDeserializer<ListResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ListResponse::setupListResponseDeserializer);

    protected ListResponse(AbstractBuilder<?> builder) {
        this.nodeFailures = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).nodeFailures);
        this.nodes = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).nodes);
        this.tasks = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).tasks);
    }

    public static ListResponse listResponseOf(Function<Builder, ObjectBuilder<ListResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ErrorCause> nodeFailures() {
        return this.nodeFailures;
    }

    public final Map<String, TaskExecutingNode> nodes() {
        return this.nodes;
    }

    public final Map<String, Info> tasks() {
        return this.tasks;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.nodeFailures)) {
            generator.writeKey("node_failures");
            generator.writeStartArray();
            for (ErrorCause errorCause : this.nodeFailures) {
                errorCause.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.nodes)) {
            generator.writeKey("nodes");
            generator.writeStartObject();
            for (Map.Entry entry : this.nodes.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((TaskExecutingNode)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.tasks)) {
            generator.writeKey("tasks");
            generator.writeStartObject();
            for (Map.Entry entry : this.tasks.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((Info)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupListResponseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::nodeFailures, JsonpDeserializer.arrayDeserializer(ErrorCause._DESERIALIZER), "node_failures");
        op.add(AbstractBuilder::nodes, JsonpDeserializer.stringMapDeserializer(TaskExecutingNode._DESERIALIZER), "nodes");
        op.add(AbstractBuilder::tasks, JsonpDeserializer.stringMapDeserializer(Info._DESERIALIZER), "tasks");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private List<ErrorCause> nodeFailures;
        @Nullable
        private Map<String, TaskExecutingNode> nodes;
        @Nullable
        private Map<String, Info> tasks;

        protected AbstractBuilder() {
        }

        public final BuilderT nodeFailures(List<ErrorCause> list) {
            this.nodeFailures = AbstractBuilder._listAddAll(this.nodeFailures, list);
            return (BuilderT)this.self();
        }

        public final BuilderT nodeFailures(ErrorCause value, ErrorCause ... values) {
            this.nodeFailures = AbstractBuilder._listAdd(this.nodeFailures, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT nodeFailures(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.nodeFailures(fn.apply(new ErrorCause.Builder()).build(), new ErrorCause[0]);
        }

        public final BuilderT nodes(Map<String, TaskExecutingNode> map) {
            this.nodes = AbstractBuilder._mapPutAll(this.nodes, map);
            return (BuilderT)this.self();
        }

        public final BuilderT nodes(String key, TaskExecutingNode value) {
            this.nodes = AbstractBuilder._mapPut(this.nodes, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT nodes(String key, Function<TaskExecutingNode.Builder, ObjectBuilder<TaskExecutingNode>> fn) {
            return this.nodes(key, fn.apply(new TaskExecutingNode.Builder()).build());
        }

        public final BuilderT tasks(Map<String, Info> map) {
            this.tasks = AbstractBuilder._mapPutAll(this.tasks, map);
            return (BuilderT)this.self();
        }

        public final BuilderT tasks(String key, Info value) {
            this.tasks = AbstractBuilder._mapPut(this.tasks, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT tasks(String key, Function<Info.Builder, ObjectBuilder<Info>> fn) {
            return this.tasks(key, fn.apply(new Info.Builder()).build());
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<ListResponse> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ListResponse build() {
            this._checkSingleUse();
            return new ListResponse(this);
        }
    }
}

