/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.DataStreamsStatsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DataStreamsStatsRequest
extends RequestBase {
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final String name;
    public static final Endpoint<DataStreamsStatsRequest, DataStreamsStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DataStreamsStatsRequest, DataStreamsStatsResponse>("es/indices.data_streams_stats", request -> "GET", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_data_stream");
            buf.append("/_stats");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_data_stream");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            buf.append("/_stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DataStreamsStatsResponse._DESERIALIZER);

    private DataStreamsStatsRequest(Builder builder) {
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.name = builder.name;
    }

    public static DataStreamsStatsRequest of(Function<Builder, ObjectBuilder<DataStreamsStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DataStreamsStatsRequest> {
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private String name;

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Override
        public DataStreamsStatsRequest build() {
            this._checkSingleUse();
            return new DataStreamsStatsRequest(this);
        }
    }
}

