/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.AsciiFoldingTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.CommonGramsTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.ConditionTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.DelimitedPayloadTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.DictionaryDecompounderTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.EdgeNGramTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.ElisionTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.FingerprintTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.HunspellTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.HyphenationDecompounderTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.IcuCollationTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.IcuFoldingTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.IcuNormalizationTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.IcuTokenizer;
import co.elastic.clients.elasticsearch._types.analysis.IcuTransformTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.KStemTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.KeepTypesTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.KeepWordsTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.KeywordMarkerTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.KuromojiPartOfSpeechTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.KuromojiReadingFormTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.KuromojiStemmerTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.LengthTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.LimitTokenCountTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.LowercaseTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.MultiplexerTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.NGramTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.NoriPartOfSpeechTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.PatternCaptureTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.PatternReplaceTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.PhoneticTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.PorterStemTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.PredicateTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.RemoveDuplicatesTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.ReverseTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.ShingleTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.SnowballTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.StemmerOverrideTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.StemmerTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.StopTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.SynonymGraphTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.SynonymTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.elasticsearch._types.analysis.TrimTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.TruncateTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.UniqueTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.UppercaseTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.WordDelimiterGraphTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.WordDelimiterTokenFilter;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TokenFilterDefinition
implements TaggedUnion<Kind, TokenFilterDefinitionVariant>,
JsonpSerializable {
    private final Kind _kind;
    private final TokenFilterDefinitionVariant _value;
    public static final JsonpDeserializer<TokenFilterDefinition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TokenFilterDefinition::setupTokenFilterDefinitionDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final TokenFilterDefinitionVariant _get() {
        return this._value;
    }

    public TokenFilterDefinition(TokenFilterDefinitionVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._tokenFilterDefinitionKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private TokenFilterDefinition(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static TokenFilterDefinition of(Function<Builder, ObjectBuilder<TokenFilterDefinition>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isAsciifolding() {
        return this._kind == Kind.Asciifolding;
    }

    public AsciiFoldingTokenFilter asciifolding() {
        return (AsciiFoldingTokenFilter)TaggedUnionUtils.get(this, Kind.Asciifolding);
    }

    public boolean isCommonGrams() {
        return this._kind == Kind.CommonGrams;
    }

    public CommonGramsTokenFilter commonGrams() {
        return (CommonGramsTokenFilter)TaggedUnionUtils.get(this, Kind.CommonGrams);
    }

    public boolean isCondition() {
        return this._kind == Kind.Condition;
    }

    public ConditionTokenFilter condition() {
        return (ConditionTokenFilter)TaggedUnionUtils.get(this, Kind.Condition);
    }

    public boolean isDelimitedPayload() {
        return this._kind == Kind.DelimitedPayload;
    }

    public DelimitedPayloadTokenFilter delimitedPayload() {
        return (DelimitedPayloadTokenFilter)TaggedUnionUtils.get(this, Kind.DelimitedPayload);
    }

    public boolean isDictionaryDecompounder() {
        return this._kind == Kind.DictionaryDecompounder;
    }

    public DictionaryDecompounderTokenFilter dictionaryDecompounder() {
        return (DictionaryDecompounderTokenFilter)TaggedUnionUtils.get(this, Kind.DictionaryDecompounder);
    }

    public boolean isEdgeNgram() {
        return this._kind == Kind.EdgeNgram;
    }

    public EdgeNGramTokenFilter edgeNgram() {
        return (EdgeNGramTokenFilter)TaggedUnionUtils.get(this, Kind.EdgeNgram);
    }

    public boolean isElision() {
        return this._kind == Kind.Elision;
    }

    public ElisionTokenFilter elision() {
        return (ElisionTokenFilter)TaggedUnionUtils.get(this, Kind.Elision);
    }

    public boolean isFingerprint() {
        return this._kind == Kind.Fingerprint;
    }

    public FingerprintTokenFilter fingerprint() {
        return (FingerprintTokenFilter)TaggedUnionUtils.get(this, Kind.Fingerprint);
    }

    public boolean isHunspell() {
        return this._kind == Kind.Hunspell;
    }

    public HunspellTokenFilter hunspell() {
        return (HunspellTokenFilter)TaggedUnionUtils.get(this, Kind.Hunspell);
    }

    public boolean isHyphenationDecompounder() {
        return this._kind == Kind.HyphenationDecompounder;
    }

    public HyphenationDecompounderTokenFilter hyphenationDecompounder() {
        return (HyphenationDecompounderTokenFilter)TaggedUnionUtils.get(this, Kind.HyphenationDecompounder);
    }

    public boolean isIcuCollation() {
        return this._kind == Kind.IcuCollation;
    }

    public IcuCollationTokenFilter icuCollation() {
        return (IcuCollationTokenFilter)TaggedUnionUtils.get(this, Kind.IcuCollation);
    }

    public boolean isIcuFolding() {
        return this._kind == Kind.IcuFolding;
    }

    public IcuFoldingTokenFilter icuFolding() {
        return (IcuFoldingTokenFilter)TaggedUnionUtils.get(this, Kind.IcuFolding);
    }

    public boolean isIcuNormalizer() {
        return this._kind == Kind.IcuNormalizer;
    }

    public IcuNormalizationTokenFilter icuNormalizer() {
        return (IcuNormalizationTokenFilter)TaggedUnionUtils.get(this, Kind.IcuNormalizer);
    }

    public boolean isIcuTokenizer() {
        return this._kind == Kind.IcuTokenizer;
    }

    public IcuTokenizer icuTokenizer() {
        return (IcuTokenizer)TaggedUnionUtils.get(this, Kind.IcuTokenizer);
    }

    public boolean isIcuTransform() {
        return this._kind == Kind.IcuTransform;
    }

    public IcuTransformTokenFilter icuTransform() {
        return (IcuTransformTokenFilter)TaggedUnionUtils.get(this, Kind.IcuTransform);
    }

    public boolean isKstem() {
        return this._kind == Kind.Kstem;
    }

    public KStemTokenFilter kstem() {
        return (KStemTokenFilter)TaggedUnionUtils.get(this, Kind.Kstem);
    }

    public boolean isKeepTypes() {
        return this._kind == Kind.KeepTypes;
    }

    public KeepTypesTokenFilter keepTypes() {
        return (KeepTypesTokenFilter)TaggedUnionUtils.get(this, Kind.KeepTypes);
    }

    public boolean isKeep() {
        return this._kind == Kind.Keep;
    }

    public KeepWordsTokenFilter keep() {
        return (KeepWordsTokenFilter)TaggedUnionUtils.get(this, Kind.Keep);
    }

    public boolean isKeywordMarker() {
        return this._kind == Kind.KeywordMarker;
    }

    public KeywordMarkerTokenFilter keywordMarker() {
        return (KeywordMarkerTokenFilter)TaggedUnionUtils.get(this, Kind.KeywordMarker);
    }

    public boolean isKuromojiPartOfSpeech() {
        return this._kind == Kind.KuromojiPartOfSpeech;
    }

    public KuromojiPartOfSpeechTokenFilter kuromojiPartOfSpeech() {
        return (KuromojiPartOfSpeechTokenFilter)TaggedUnionUtils.get(this, Kind.KuromojiPartOfSpeech);
    }

    public boolean isKuromojiReadingform() {
        return this._kind == Kind.KuromojiReadingform;
    }

    public KuromojiReadingFormTokenFilter kuromojiReadingform() {
        return (KuromojiReadingFormTokenFilter)TaggedUnionUtils.get(this, Kind.KuromojiReadingform);
    }

    public boolean isKuromojiStemmer() {
        return this._kind == Kind.KuromojiStemmer;
    }

    public KuromojiStemmerTokenFilter kuromojiStemmer() {
        return (KuromojiStemmerTokenFilter)TaggedUnionUtils.get(this, Kind.KuromojiStemmer);
    }

    public boolean isLength() {
        return this._kind == Kind.Length;
    }

    public LengthTokenFilter length() {
        return (LengthTokenFilter)TaggedUnionUtils.get(this, Kind.Length);
    }

    public boolean isLimit() {
        return this._kind == Kind.Limit;
    }

    public LimitTokenCountTokenFilter limit() {
        return (LimitTokenCountTokenFilter)TaggedUnionUtils.get(this, Kind.Limit);
    }

    public boolean isLowercase() {
        return this._kind == Kind.Lowercase;
    }

    public LowercaseTokenFilter lowercase() {
        return (LowercaseTokenFilter)TaggedUnionUtils.get(this, Kind.Lowercase);
    }

    public boolean isMultiplexer() {
        return this._kind == Kind.Multiplexer;
    }

    public MultiplexerTokenFilter multiplexer() {
        return (MultiplexerTokenFilter)TaggedUnionUtils.get(this, Kind.Multiplexer);
    }

    public boolean isNgram() {
        return this._kind == Kind.Ngram;
    }

    public NGramTokenFilter ngram() {
        return (NGramTokenFilter)TaggedUnionUtils.get(this, Kind.Ngram);
    }

    public boolean isNoriPartOfSpeech() {
        return this._kind == Kind.NoriPartOfSpeech;
    }

    public NoriPartOfSpeechTokenFilter noriPartOfSpeech() {
        return (NoriPartOfSpeechTokenFilter)TaggedUnionUtils.get(this, Kind.NoriPartOfSpeech);
    }

    public boolean isPatternCapture() {
        return this._kind == Kind.PatternCapture;
    }

    public PatternCaptureTokenFilter patternCapture() {
        return (PatternCaptureTokenFilter)TaggedUnionUtils.get(this, Kind.PatternCapture);
    }

    public boolean isPatternReplace() {
        return this._kind == Kind.PatternReplace;
    }

    public PatternReplaceTokenFilter patternReplace() {
        return (PatternReplaceTokenFilter)TaggedUnionUtils.get(this, Kind.PatternReplace);
    }

    public boolean isPhonetic() {
        return this._kind == Kind.Phonetic;
    }

    public PhoneticTokenFilter phonetic() {
        return (PhoneticTokenFilter)TaggedUnionUtils.get(this, Kind.Phonetic);
    }

    public boolean isPorterStem() {
        return this._kind == Kind.PorterStem;
    }

    public PorterStemTokenFilter porterStem() {
        return (PorterStemTokenFilter)TaggedUnionUtils.get(this, Kind.PorterStem);
    }

    public boolean isPredicateTokenFilter() {
        return this._kind == Kind.PredicateTokenFilter;
    }

    public PredicateTokenFilter predicateTokenFilter() {
        return (PredicateTokenFilter)TaggedUnionUtils.get(this, Kind.PredicateTokenFilter);
    }

    public boolean isRemoveDuplicates() {
        return this._kind == Kind.RemoveDuplicates;
    }

    public RemoveDuplicatesTokenFilter removeDuplicates() {
        return (RemoveDuplicatesTokenFilter)TaggedUnionUtils.get(this, Kind.RemoveDuplicates);
    }

    public boolean isReverse() {
        return this._kind == Kind.Reverse;
    }

    public ReverseTokenFilter reverse() {
        return (ReverseTokenFilter)TaggedUnionUtils.get(this, Kind.Reverse);
    }

    public boolean isShingle() {
        return this._kind == Kind.Shingle;
    }

    public ShingleTokenFilter shingle() {
        return (ShingleTokenFilter)TaggedUnionUtils.get(this, Kind.Shingle);
    }

    public boolean isSnowball() {
        return this._kind == Kind.Snowball;
    }

    public SnowballTokenFilter snowball() {
        return (SnowballTokenFilter)TaggedUnionUtils.get(this, Kind.Snowball);
    }

    public boolean isStemmerOverride() {
        return this._kind == Kind.StemmerOverride;
    }

    public StemmerOverrideTokenFilter stemmerOverride() {
        return (StemmerOverrideTokenFilter)TaggedUnionUtils.get(this, Kind.StemmerOverride);
    }

    public boolean isStemmer() {
        return this._kind == Kind.Stemmer;
    }

    public StemmerTokenFilter stemmer() {
        return (StemmerTokenFilter)TaggedUnionUtils.get(this, Kind.Stemmer);
    }

    public boolean isStop() {
        return this._kind == Kind.Stop;
    }

    public StopTokenFilter stop() {
        return (StopTokenFilter)TaggedUnionUtils.get(this, Kind.Stop);
    }

    public boolean isSynonymGraph() {
        return this._kind == Kind.SynonymGraph;
    }

    public SynonymGraphTokenFilter synonymGraph() {
        return (SynonymGraphTokenFilter)TaggedUnionUtils.get(this, Kind.SynonymGraph);
    }

    public boolean isSynonym() {
        return this._kind == Kind.Synonym;
    }

    public SynonymTokenFilter synonym() {
        return (SynonymTokenFilter)TaggedUnionUtils.get(this, Kind.Synonym);
    }

    public boolean isTrim() {
        return this._kind == Kind.Trim;
    }

    public TrimTokenFilter trim() {
        return (TrimTokenFilter)TaggedUnionUtils.get(this, Kind.Trim);
    }

    public boolean isTruncate() {
        return this._kind == Kind.Truncate;
    }

    public TruncateTokenFilter truncate() {
        return (TruncateTokenFilter)TaggedUnionUtils.get(this, Kind.Truncate);
    }

    public boolean isUnique() {
        return this._kind == Kind.Unique;
    }

    public UniqueTokenFilter unique() {
        return (UniqueTokenFilter)TaggedUnionUtils.get(this, Kind.Unique);
    }

    public boolean isUppercase() {
        return this._kind == Kind.Uppercase;
    }

    public UppercaseTokenFilter uppercase() {
        return (UppercaseTokenFilter)TaggedUnionUtils.get(this, Kind.Uppercase);
    }

    public boolean isWordDelimiterGraph() {
        return this._kind == Kind.WordDelimiterGraph;
    }

    public WordDelimiterGraphTokenFilter wordDelimiterGraph() {
        return (WordDelimiterGraphTokenFilter)TaggedUnionUtils.get(this, Kind.WordDelimiterGraph);
    }

    public boolean isWordDelimiter() {
        return this._kind == Kind.WordDelimiter;
    }

    public WordDelimiterTokenFilter wordDelimiter() {
        return (WordDelimiterTokenFilter)TaggedUnionUtils.get(this, Kind.WordDelimiter);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize(this._value, generator);
    }

    protected static void setupTokenFilterDefinitionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::asciifolding, AsciiFoldingTokenFilter._DESERIALIZER, "asciifolding");
        op.add(Builder::commonGrams, CommonGramsTokenFilter._DESERIALIZER, "common_grams");
        op.add(Builder::condition, ConditionTokenFilter._DESERIALIZER, "condition");
        op.add(Builder::delimitedPayload, DelimitedPayloadTokenFilter._DESERIALIZER, "delimited_payload");
        op.add(Builder::dictionaryDecompounder, DictionaryDecompounderTokenFilter._DESERIALIZER, "dictionary_decompounder");
        op.add(Builder::edgeNgram, EdgeNGramTokenFilter._DESERIALIZER, "edge_ngram");
        op.add(Builder::elision, ElisionTokenFilter._DESERIALIZER, "elision");
        op.add(Builder::fingerprint, FingerprintTokenFilter._DESERIALIZER, "fingerprint");
        op.add(Builder::hunspell, HunspellTokenFilter._DESERIALIZER, "hunspell");
        op.add(Builder::hyphenationDecompounder, HyphenationDecompounderTokenFilter._DESERIALIZER, "hyphenation_decompounder");
        op.add(Builder::icuCollation, IcuCollationTokenFilter._DESERIALIZER, "icu_collation");
        op.add(Builder::icuFolding, IcuFoldingTokenFilter._DESERIALIZER, "icu_folding");
        op.add(Builder::icuNormalizer, IcuNormalizationTokenFilter._DESERIALIZER, "icu_normalizer");
        op.add(Builder::icuTokenizer, IcuTokenizer._DESERIALIZER, "icu_tokenizer");
        op.add(Builder::icuTransform, IcuTransformTokenFilter._DESERIALIZER, "icu_transform");
        op.add(Builder::kstem, KStemTokenFilter._DESERIALIZER, "kstem");
        op.add(Builder::keepTypes, KeepTypesTokenFilter._DESERIALIZER, "keep_types");
        op.add(Builder::keep, KeepWordsTokenFilter._DESERIALIZER, "keep");
        op.add(Builder::keywordMarker, KeywordMarkerTokenFilter._DESERIALIZER, "keyword_marker");
        op.add(Builder::kuromojiPartOfSpeech, KuromojiPartOfSpeechTokenFilter._DESERIALIZER, "kuromoji_part_of_speech");
        op.add(Builder::kuromojiReadingform, KuromojiReadingFormTokenFilter._DESERIALIZER, "kuromoji_readingform");
        op.add(Builder::kuromojiStemmer, KuromojiStemmerTokenFilter._DESERIALIZER, "kuromoji_stemmer");
        op.add(Builder::length, LengthTokenFilter._DESERIALIZER, "length");
        op.add(Builder::limit, LimitTokenCountTokenFilter._DESERIALIZER, "limit");
        op.add(Builder::lowercase, LowercaseTokenFilter._DESERIALIZER, "lowercase");
        op.add(Builder::multiplexer, MultiplexerTokenFilter._DESERIALIZER, "multiplexer");
        op.add(Builder::ngram, NGramTokenFilter._DESERIALIZER, "ngram");
        op.add(Builder::noriPartOfSpeech, NoriPartOfSpeechTokenFilter._DESERIALIZER, "nori_part_of_speech");
        op.add(Builder::patternCapture, PatternCaptureTokenFilter._DESERIALIZER, "pattern_capture");
        op.add(Builder::patternReplace, PatternReplaceTokenFilter._DESERIALIZER, "pattern_replace");
        op.add(Builder::phonetic, PhoneticTokenFilter._DESERIALIZER, "phonetic");
        op.add(Builder::porterStem, PorterStemTokenFilter._DESERIALIZER, "porter_stem");
        op.add(Builder::predicateTokenFilter, PredicateTokenFilter._DESERIALIZER, "predicate_token_filter");
        op.add(Builder::removeDuplicates, RemoveDuplicatesTokenFilter._DESERIALIZER, "remove_duplicates");
        op.add(Builder::reverse, ReverseTokenFilter._DESERIALIZER, "reverse");
        op.add(Builder::shingle, ShingleTokenFilter._DESERIALIZER, "shingle");
        op.add(Builder::snowball, SnowballTokenFilter._DESERIALIZER, "snowball");
        op.add(Builder::stemmerOverride, StemmerOverrideTokenFilter._DESERIALIZER, "stemmer_override");
        op.add(Builder::stemmer, StemmerTokenFilter._DESERIALIZER, "stemmer");
        op.add(Builder::stop, StopTokenFilter._DESERIALIZER, "stop");
        op.add(Builder::synonymGraph, SynonymGraphTokenFilter._DESERIALIZER, "synonym_graph");
        op.add(Builder::synonym, SynonymTokenFilter._DESERIALIZER, "synonym");
        op.add(Builder::trim, TrimTokenFilter._DESERIALIZER, "trim");
        op.add(Builder::truncate, TruncateTokenFilter._DESERIALIZER, "truncate");
        op.add(Builder::unique, UniqueTokenFilter._DESERIALIZER, "unique");
        op.add(Builder::uppercase, UppercaseTokenFilter._DESERIALIZER, "uppercase");
        op.add(Builder::wordDelimiterGraph, WordDelimiterGraphTokenFilter._DESERIALIZER, "word_delimiter_graph");
        op.add(Builder::wordDelimiter, WordDelimiterTokenFilter._DESERIALIZER, "word_delimiter");
        op.setTypeProperty("type", null);
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TokenFilterDefinition> {
        private Kind _kind;
        private TokenFilterDefinitionVariant _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> asciifolding(AsciiFoldingTokenFilter v) {
            this._kind = Kind.Asciifolding;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> asciifolding(Function<AsciiFoldingTokenFilter.Builder, ObjectBuilder<AsciiFoldingTokenFilter>> fn) {
            return this.asciifolding(fn.apply(new AsciiFoldingTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> commonGrams(CommonGramsTokenFilter v) {
            this._kind = Kind.CommonGrams;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> commonGrams(Function<CommonGramsTokenFilter.Builder, ObjectBuilder<CommonGramsTokenFilter>> fn) {
            return this.commonGrams(fn.apply(new CommonGramsTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> condition(ConditionTokenFilter v) {
            this._kind = Kind.Condition;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> condition(Function<ConditionTokenFilter.Builder, ObjectBuilder<ConditionTokenFilter>> fn) {
            return this.condition(fn.apply(new ConditionTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> delimitedPayload(DelimitedPayloadTokenFilter v) {
            this._kind = Kind.DelimitedPayload;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> delimitedPayload(Function<DelimitedPayloadTokenFilter.Builder, ObjectBuilder<DelimitedPayloadTokenFilter>> fn) {
            return this.delimitedPayload(fn.apply(new DelimitedPayloadTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> dictionaryDecompounder(DictionaryDecompounderTokenFilter v) {
            this._kind = Kind.DictionaryDecompounder;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> dictionaryDecompounder(Function<DictionaryDecompounderTokenFilter.Builder, ObjectBuilder<DictionaryDecompounderTokenFilter>> fn) {
            return this.dictionaryDecompounder(fn.apply(new DictionaryDecompounderTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> edgeNgram(EdgeNGramTokenFilter v) {
            this._kind = Kind.EdgeNgram;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> edgeNgram(Function<EdgeNGramTokenFilter.Builder, ObjectBuilder<EdgeNGramTokenFilter>> fn) {
            return this.edgeNgram(fn.apply(new EdgeNGramTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> elision(ElisionTokenFilter v) {
            this._kind = Kind.Elision;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> elision(Function<ElisionTokenFilter.Builder, ObjectBuilder<ElisionTokenFilter>> fn) {
            return this.elision(fn.apply(new ElisionTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> fingerprint(FingerprintTokenFilter v) {
            this._kind = Kind.Fingerprint;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> fingerprint(Function<FingerprintTokenFilter.Builder, ObjectBuilder<FingerprintTokenFilter>> fn) {
            return this.fingerprint(fn.apply(new FingerprintTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> hunspell(HunspellTokenFilter v) {
            this._kind = Kind.Hunspell;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> hunspell(Function<HunspellTokenFilter.Builder, ObjectBuilder<HunspellTokenFilter>> fn) {
            return this.hunspell(fn.apply(new HunspellTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> hyphenationDecompounder(HyphenationDecompounderTokenFilter v) {
            this._kind = Kind.HyphenationDecompounder;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> hyphenationDecompounder(Function<HyphenationDecompounderTokenFilter.Builder, ObjectBuilder<HyphenationDecompounderTokenFilter>> fn) {
            return this.hyphenationDecompounder(fn.apply(new HyphenationDecompounderTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> icuCollation(IcuCollationTokenFilter v) {
            this._kind = Kind.IcuCollation;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> icuCollation(Function<IcuCollationTokenFilter.Builder, ObjectBuilder<IcuCollationTokenFilter>> fn) {
            return this.icuCollation(fn.apply(new IcuCollationTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> icuFolding(IcuFoldingTokenFilter v) {
            this._kind = Kind.IcuFolding;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> icuFolding(Function<IcuFoldingTokenFilter.Builder, ObjectBuilder<IcuFoldingTokenFilter>> fn) {
            return this.icuFolding(fn.apply(new IcuFoldingTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> icuNormalizer(IcuNormalizationTokenFilter v) {
            this._kind = Kind.IcuNormalizer;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> icuNormalizer(Function<IcuNormalizationTokenFilter.Builder, ObjectBuilder<IcuNormalizationTokenFilter>> fn) {
            return this.icuNormalizer(fn.apply(new IcuNormalizationTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> icuTokenizer(IcuTokenizer v) {
            this._kind = Kind.IcuTokenizer;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> icuTokenizer(Function<IcuTokenizer.Builder, ObjectBuilder<IcuTokenizer>> fn) {
            return this.icuTokenizer(fn.apply(new IcuTokenizer.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> icuTransform(IcuTransformTokenFilter v) {
            this._kind = Kind.IcuTransform;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> icuTransform(Function<IcuTransformTokenFilter.Builder, ObjectBuilder<IcuTransformTokenFilter>> fn) {
            return this.icuTransform(fn.apply(new IcuTransformTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> kstem(KStemTokenFilter v) {
            this._kind = Kind.Kstem;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> kstem(Function<KStemTokenFilter.Builder, ObjectBuilder<KStemTokenFilter>> fn) {
            return this.kstem(fn.apply(new KStemTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> keepTypes(KeepTypesTokenFilter v) {
            this._kind = Kind.KeepTypes;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> keepTypes(Function<KeepTypesTokenFilter.Builder, ObjectBuilder<KeepTypesTokenFilter>> fn) {
            return this.keepTypes(fn.apply(new KeepTypesTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> keep(KeepWordsTokenFilter v) {
            this._kind = Kind.Keep;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> keep(Function<KeepWordsTokenFilter.Builder, ObjectBuilder<KeepWordsTokenFilter>> fn) {
            return this.keep(fn.apply(new KeepWordsTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> keywordMarker(KeywordMarkerTokenFilter v) {
            this._kind = Kind.KeywordMarker;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> keywordMarker(Function<KeywordMarkerTokenFilter.Builder, ObjectBuilder<KeywordMarkerTokenFilter>> fn) {
            return this.keywordMarker(fn.apply(new KeywordMarkerTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> kuromojiPartOfSpeech(KuromojiPartOfSpeechTokenFilter v) {
            this._kind = Kind.KuromojiPartOfSpeech;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> kuromojiPartOfSpeech(Function<KuromojiPartOfSpeechTokenFilter.Builder, ObjectBuilder<KuromojiPartOfSpeechTokenFilter>> fn) {
            return this.kuromojiPartOfSpeech(fn.apply(new KuromojiPartOfSpeechTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> kuromojiReadingform(KuromojiReadingFormTokenFilter v) {
            this._kind = Kind.KuromojiReadingform;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> kuromojiReadingform(Function<KuromojiReadingFormTokenFilter.Builder, ObjectBuilder<KuromojiReadingFormTokenFilter>> fn) {
            return this.kuromojiReadingform(fn.apply(new KuromojiReadingFormTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> kuromojiStemmer(KuromojiStemmerTokenFilter v) {
            this._kind = Kind.KuromojiStemmer;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> kuromojiStemmer(Function<KuromojiStemmerTokenFilter.Builder, ObjectBuilder<KuromojiStemmerTokenFilter>> fn) {
            return this.kuromojiStemmer(fn.apply(new KuromojiStemmerTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> length(LengthTokenFilter v) {
            this._kind = Kind.Length;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> length(Function<LengthTokenFilter.Builder, ObjectBuilder<LengthTokenFilter>> fn) {
            return this.length(fn.apply(new LengthTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> limit(LimitTokenCountTokenFilter v) {
            this._kind = Kind.Limit;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> limit(Function<LimitTokenCountTokenFilter.Builder, ObjectBuilder<LimitTokenCountTokenFilter>> fn) {
            return this.limit(fn.apply(new LimitTokenCountTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> lowercase(LowercaseTokenFilter v) {
            this._kind = Kind.Lowercase;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> lowercase(Function<LowercaseTokenFilter.Builder, ObjectBuilder<LowercaseTokenFilter>> fn) {
            return this.lowercase(fn.apply(new LowercaseTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> multiplexer(MultiplexerTokenFilter v) {
            this._kind = Kind.Multiplexer;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> multiplexer(Function<MultiplexerTokenFilter.Builder, ObjectBuilder<MultiplexerTokenFilter>> fn) {
            return this.multiplexer(fn.apply(new MultiplexerTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> ngram(NGramTokenFilter v) {
            this._kind = Kind.Ngram;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> ngram(Function<NGramTokenFilter.Builder, ObjectBuilder<NGramTokenFilter>> fn) {
            return this.ngram(fn.apply(new NGramTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> noriPartOfSpeech(NoriPartOfSpeechTokenFilter v) {
            this._kind = Kind.NoriPartOfSpeech;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> noriPartOfSpeech(Function<NoriPartOfSpeechTokenFilter.Builder, ObjectBuilder<NoriPartOfSpeechTokenFilter>> fn) {
            return this.noriPartOfSpeech(fn.apply(new NoriPartOfSpeechTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> patternCapture(PatternCaptureTokenFilter v) {
            this._kind = Kind.PatternCapture;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> patternCapture(Function<PatternCaptureTokenFilter.Builder, ObjectBuilder<PatternCaptureTokenFilter>> fn) {
            return this.patternCapture(fn.apply(new PatternCaptureTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> patternReplace(PatternReplaceTokenFilter v) {
            this._kind = Kind.PatternReplace;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> patternReplace(Function<PatternReplaceTokenFilter.Builder, ObjectBuilder<PatternReplaceTokenFilter>> fn) {
            return this.patternReplace(fn.apply(new PatternReplaceTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> phonetic(PhoneticTokenFilter v) {
            this._kind = Kind.Phonetic;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> phonetic(Function<PhoneticTokenFilter.Builder, ObjectBuilder<PhoneticTokenFilter>> fn) {
            return this.phonetic(fn.apply(new PhoneticTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> porterStem(PorterStemTokenFilter v) {
            this._kind = Kind.PorterStem;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> porterStem(Function<PorterStemTokenFilter.Builder, ObjectBuilder<PorterStemTokenFilter>> fn) {
            return this.porterStem(fn.apply(new PorterStemTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> predicateTokenFilter(PredicateTokenFilter v) {
            this._kind = Kind.PredicateTokenFilter;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> predicateTokenFilter(Function<PredicateTokenFilter.Builder, ObjectBuilder<PredicateTokenFilter>> fn) {
            return this.predicateTokenFilter(fn.apply(new PredicateTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> removeDuplicates(RemoveDuplicatesTokenFilter v) {
            this._kind = Kind.RemoveDuplicates;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> removeDuplicates(Function<RemoveDuplicatesTokenFilter.Builder, ObjectBuilder<RemoveDuplicatesTokenFilter>> fn) {
            return this.removeDuplicates(fn.apply(new RemoveDuplicatesTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> reverse(ReverseTokenFilter v) {
            this._kind = Kind.Reverse;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> reverse(Function<ReverseTokenFilter.Builder, ObjectBuilder<ReverseTokenFilter>> fn) {
            return this.reverse(fn.apply(new ReverseTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> shingle(ShingleTokenFilter v) {
            this._kind = Kind.Shingle;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> shingle(Function<ShingleTokenFilter.Builder, ObjectBuilder<ShingleTokenFilter>> fn) {
            return this.shingle(fn.apply(new ShingleTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> snowball(SnowballTokenFilter v) {
            this._kind = Kind.Snowball;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> snowball(Function<SnowballTokenFilter.Builder, ObjectBuilder<SnowballTokenFilter>> fn) {
            return this.snowball(fn.apply(new SnowballTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> stemmerOverride(StemmerOverrideTokenFilter v) {
            this._kind = Kind.StemmerOverride;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> stemmerOverride(Function<StemmerOverrideTokenFilter.Builder, ObjectBuilder<StemmerOverrideTokenFilter>> fn) {
            return this.stemmerOverride(fn.apply(new StemmerOverrideTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> stemmer(StemmerTokenFilter v) {
            this._kind = Kind.Stemmer;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> stemmer(Function<StemmerTokenFilter.Builder, ObjectBuilder<StemmerTokenFilter>> fn) {
            return this.stemmer(fn.apply(new StemmerTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> stop(StopTokenFilter v) {
            this._kind = Kind.Stop;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> stop(Function<StopTokenFilter.Builder, ObjectBuilder<StopTokenFilter>> fn) {
            return this.stop(fn.apply(new StopTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> synonymGraph(SynonymGraphTokenFilter v) {
            this._kind = Kind.SynonymGraph;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> synonymGraph(Function<SynonymGraphTokenFilter.Builder, ObjectBuilder<SynonymGraphTokenFilter>> fn) {
            return this.synonymGraph(fn.apply(new SynonymGraphTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> synonym(SynonymTokenFilter v) {
            this._kind = Kind.Synonym;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> synonym(Function<SynonymTokenFilter.Builder, ObjectBuilder<SynonymTokenFilter>> fn) {
            return this.synonym(fn.apply(new SynonymTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> trim(TrimTokenFilter v) {
            this._kind = Kind.Trim;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> trim(Function<TrimTokenFilter.Builder, ObjectBuilder<TrimTokenFilter>> fn) {
            return this.trim(fn.apply(new TrimTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> truncate(TruncateTokenFilter v) {
            this._kind = Kind.Truncate;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> truncate(Function<TruncateTokenFilter.Builder, ObjectBuilder<TruncateTokenFilter>> fn) {
            return this.truncate(fn.apply(new TruncateTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> unique(UniqueTokenFilter v) {
            this._kind = Kind.Unique;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> unique(Function<UniqueTokenFilter.Builder, ObjectBuilder<UniqueTokenFilter>> fn) {
            return this.unique(fn.apply(new UniqueTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> uppercase(UppercaseTokenFilter v) {
            this._kind = Kind.Uppercase;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> uppercase(Function<UppercaseTokenFilter.Builder, ObjectBuilder<UppercaseTokenFilter>> fn) {
            return this.uppercase(fn.apply(new UppercaseTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> wordDelimiterGraph(WordDelimiterGraphTokenFilter v) {
            this._kind = Kind.WordDelimiterGraph;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> wordDelimiterGraph(Function<WordDelimiterGraphTokenFilter.Builder, ObjectBuilder<WordDelimiterGraphTokenFilter>> fn) {
            return this.wordDelimiterGraph(fn.apply(new WordDelimiterGraphTokenFilter.Builder()).build());
        }

        public ObjectBuilder<TokenFilterDefinition> wordDelimiter(WordDelimiterTokenFilter v) {
            this._kind = Kind.WordDelimiter;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenFilterDefinition> wordDelimiter(Function<WordDelimiterTokenFilter.Builder, ObjectBuilder<WordDelimiterTokenFilter>> fn) {
            return this.wordDelimiter(fn.apply(new WordDelimiterTokenFilter.Builder()).build());
        }

        @Override
        public TokenFilterDefinition build() {
            this._checkSingleUse();
            return new TokenFilterDefinition(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Asciifolding("asciifolding"),
        CommonGrams("common_grams"),
        Condition("condition"),
        DelimitedPayload("delimited_payload"),
        DictionaryDecompounder("dictionary_decompounder"),
        EdgeNgram("edge_ngram"),
        Elision("elision"),
        Fingerprint("fingerprint"),
        Hunspell("hunspell"),
        HyphenationDecompounder("hyphenation_decompounder"),
        IcuCollation("icu_collation"),
        IcuFolding("icu_folding"),
        IcuNormalizer("icu_normalizer"),
        IcuTokenizer("icu_tokenizer"),
        IcuTransform("icu_transform"),
        Kstem("kstem"),
        KeepTypes("keep_types"),
        Keep("keep"),
        KeywordMarker("keyword_marker"),
        KuromojiPartOfSpeech("kuromoji_part_of_speech"),
        KuromojiReadingform("kuromoji_readingform"),
        KuromojiStemmer("kuromoji_stemmer"),
        Length("length"),
        Limit("limit"),
        Lowercase("lowercase"),
        Multiplexer("multiplexer"),
        Ngram("ngram"),
        NoriPartOfSpeech("nori_part_of_speech"),
        PatternCapture("pattern_capture"),
        PatternReplace("pattern_replace"),
        Phonetic("phonetic"),
        PorterStem("porter_stem"),
        PredicateTokenFilter("predicate_token_filter"),
        RemoveDuplicates("remove_duplicates"),
        Reverse("reverse"),
        Shingle("shingle"),
        Snowball("snowball"),
        StemmerOverride("stemmer_override"),
        Stemmer("stemmer"),
        Stop("stop"),
        SynonymGraph("synonym_graph"),
        Synonym("synonym"),
        Trim("trim"),
        Truncate("truncate"),
        Unique("unique"),
        Uppercase("uppercase"),
        WordDelimiterGraph("word_delimiter_graph"),
        WordDelimiter("word_delimiter");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

