/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.IndicesOptions;
import co.elastic.clients.elasticsearch._types.ScriptField;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.ml.ChunkingConfig;
import co.elastic.clients.elasticsearch.ml.DelayedDataCheckConfig;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutDatafeedResponse
implements JsonpSerializable {
    private final Map<String, Aggregation> aggregations;
    private final ChunkingConfig chunkingConfig;
    @Nullable
    private final DelayedDataCheckConfig delayedDataCheckConfig;
    private final String datafeedId;
    private final Time frequency;
    private final List<String> indices;
    private final String jobId;
    @Nullable
    private final IndicesOptions indicesOptions;
    private final int maxEmptySearches;
    private final Query query;
    private final Time queryDelay;
    private final Map<String, RuntimeField> runtimeMappings;
    private final Map<String, ScriptField> scriptFields;
    private final int scrollSize;
    public static final JsonpDeserializer<PutDatafeedResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutDatafeedResponse::setupPutDatafeedResponseDeserializer);

    private PutDatafeedResponse(Builder builder) {
        this.aggregations = ApiTypeHelper.unmodifiableRequired(builder.aggregations, (Object)this, "aggregations");
        this.chunkingConfig = ApiTypeHelper.requireNonNull(builder.chunkingConfig, this, "chunkingConfig");
        this.delayedDataCheckConfig = builder.delayedDataCheckConfig;
        this.datafeedId = ApiTypeHelper.requireNonNull(builder.datafeedId, this, "datafeedId");
        this.frequency = ApiTypeHelper.requireNonNull(builder.frequency, this, "frequency");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.indicesOptions = builder.indicesOptions;
        this.maxEmptySearches = ApiTypeHelper.requireNonNull(builder.maxEmptySearches, this, "maxEmptySearches");
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.queryDelay = ApiTypeHelper.requireNonNull(builder.queryDelay, this, "queryDelay");
        this.runtimeMappings = ApiTypeHelper.unmodifiable(builder.runtimeMappings);
        this.scriptFields = ApiTypeHelper.unmodifiable(builder.scriptFields);
        this.scrollSize = ApiTypeHelper.requireNonNull(builder.scrollSize, this, "scrollSize");
    }

    public static PutDatafeedResponse of(Function<Builder, ObjectBuilder<PutDatafeedResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Aggregation> aggregations() {
        return this.aggregations;
    }

    public final ChunkingConfig chunkingConfig() {
        return this.chunkingConfig;
    }

    @Nullable
    public final DelayedDataCheckConfig delayedDataCheckConfig() {
        return this.delayedDataCheckConfig;
    }

    public final String datafeedId() {
        return this.datafeedId;
    }

    public final Time frequency() {
        return this.frequency;
    }

    public final List<String> indices() {
        return this.indices;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public final int maxEmptySearches() {
        return this.maxEmptySearches;
    }

    public final Query query() {
        return this.query;
    }

    public final Time queryDelay() {
        return this.queryDelay;
    }

    public final Map<String, RuntimeField> runtimeMappings() {
        return this.runtimeMappings;
    }

    public final Map<String, ScriptField> scriptFields() {
        return this.scriptFields;
    }

    public final int scrollSize() {
        return this.scrollSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("chunking_config");
        this.chunkingConfig.serialize(generator, mapper);
        if (this.delayedDataCheckConfig != null) {
            generator.writeKey("delayed_data_check_config");
            this.delayedDataCheckConfig.serialize(generator, mapper);
        }
        generator.writeKey("datafeed_id");
        generator.write(this.datafeedId);
        generator.writeKey("frequency");
        this.frequency.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String string : this.indices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("job_id");
        generator.write(this.jobId);
        if (this.indicesOptions != null) {
            generator.writeKey("indices_options");
            this.indicesOptions.serialize(generator, mapper);
        }
        generator.writeKey("max_empty_searches");
        generator.write(this.maxEmptySearches);
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        generator.writeKey("query_delay");
        this.queryDelay.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.runtimeMappings)) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtimeMappings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.scriptFields)) {
            generator.writeKey("script_fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.scriptFields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ScriptField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("scroll_size");
        generator.write(this.scrollSize);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupPutDatafeedResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggregations");
        op.add(Builder::chunkingConfig, ChunkingConfig._DESERIALIZER, "chunking_config");
        op.add(Builder::delayedDataCheckConfig, DelayedDataCheckConfig._DESERIALIZER, "delayed_data_check_config");
        op.add(Builder::datafeedId, JsonpDeserializer.stringDeserializer(), "datafeed_id");
        op.add(Builder::frequency, Time._DESERIALIZER, "frequency");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::indicesOptions, IndicesOptions._DESERIALIZER, "indices_options");
        op.add(Builder::maxEmptySearches, JsonpDeserializer.integerDeserializer(), "max_empty_searches");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::queryDelay, Time._DESERIALIZER, "query_delay");
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime_mappings");
        op.add(Builder::scriptFields, JsonpDeserializer.stringMapDeserializer(ScriptField._DESERIALIZER), "script_fields");
        op.add(Builder::scrollSize, JsonpDeserializer.integerDeserializer(), "scroll_size");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PutDatafeedResponse> {
        private Map<String, Aggregation> aggregations;
        private ChunkingConfig chunkingConfig;
        @Nullable
        private DelayedDataCheckConfig delayedDataCheckConfig;
        private String datafeedId;
        private Time frequency;
        private List<String> indices;
        private String jobId;
        @Nullable
        private IndicesOptions indicesOptions;
        private Integer maxEmptySearches;
        private Query query;
        private Time queryDelay;
        @Nullable
        private Map<String, RuntimeField> runtimeMappings;
        @Nullable
        private Map<String, ScriptField> scriptFields;
        private Integer scrollSize;

        public final Builder aggregations(Map<String, Aggregation> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        public final Builder aggregations(String key, Aggregation value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        public final Builder aggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggregations(key, fn.apply(new Aggregation.Builder()).build());
        }

        public final Builder chunkingConfig(ChunkingConfig value) {
            this.chunkingConfig = value;
            return this;
        }

        public final Builder chunkingConfig(Function<ChunkingConfig.Builder, ObjectBuilder<ChunkingConfig>> fn) {
            return this.chunkingConfig(fn.apply(new ChunkingConfig.Builder()).build());
        }

        public final Builder delayedDataCheckConfig(@Nullable DelayedDataCheckConfig value) {
            this.delayedDataCheckConfig = value;
            return this;
        }

        public final Builder delayedDataCheckConfig(Function<DelayedDataCheckConfig.Builder, ObjectBuilder<DelayedDataCheckConfig>> fn) {
            return this.delayedDataCheckConfig(fn.apply(new DelayedDataCheckConfig.Builder()).build());
        }

        public final Builder datafeedId(String value) {
            this.datafeedId = value;
            return this;
        }

        public final Builder frequency(Time value) {
            this.frequency = value;
            return this;
        }

        public final Builder frequency(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.frequency(fn.apply(new Time.Builder()).build());
        }

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder indicesOptions(@Nullable IndicesOptions value) {
            this.indicesOptions = value;
            return this;
        }

        public final Builder indicesOptions(Function<IndicesOptions.Builder, ObjectBuilder<IndicesOptions>> fn) {
            return this.indicesOptions(fn.apply(new IndicesOptions.Builder()).build());
        }

        public final Builder maxEmptySearches(int value) {
            this.maxEmptySearches = value;
            return this;
        }

        public final Builder query(Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder queryDelay(Time value) {
            this.queryDelay = value;
            return this;
        }

        public final Builder queryDelay(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.queryDelay(fn.apply(new Time.Builder()).build());
        }

        public final Builder runtimeMappings(Map<String, RuntimeField> map) {
            this.runtimeMappings = Builder._mapPutAll(this.runtimeMappings, map);
            return this;
        }

        public final Builder runtimeMappings(String key, RuntimeField value) {
            this.runtimeMappings = Builder._mapPut(this.runtimeMappings, key, value);
            return this;
        }

        public final Builder runtimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtimeMappings(key, fn.apply(new RuntimeField.Builder()).build());
        }

        public final Builder scriptFields(Map<String, ScriptField> map) {
            this.scriptFields = Builder._mapPutAll(this.scriptFields, map);
            return this;
        }

        public final Builder scriptFields(String key, ScriptField value) {
            this.scriptFields = Builder._mapPut(this.scriptFields, key, value);
            return this;
        }

        public final Builder scriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.scriptFields(key, fn.apply(new ScriptField.Builder()).build());
        }

        public final Builder scrollSize(int value) {
            this.scrollSize = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutDatafeedResponse build() {
            this._checkSingleUse();
            return new PutDatafeedResponse(this);
        }
    }
}

