/*
 * Decompiled with CFR 0.152.
 */
package me.codeleep.jsondiff.common.utils;

import me.codeleep.jsondiff.common.exception.JsonDiffException;
import me.codeleep.jsondiff.common.model.neat.JsonBuilder;

public enum ImplType {
    FASTJSON("fastjson", "me.codeleep.jsondiff.impl.fastjson.FastJsonBuilder"),
    FASTJSON2("fastjson2", "me.codeleep.jsondiff.impl.fastjson2.FastJson2Builder"),
    JACKSON("jackson", "me.codeleep.jsondiff.impl.gson.GsonBuilder"),
    GSON("gson", "me.codeleep.jsondiff.impl.jackson.JacksonBuilder");

    private String type;
    private String builderClassName;

    private ImplType(String type, String builderClassName) {
        this.type = type;
        this.builderClassName = builderClassName;
    }

    public JsonBuilder getBuilder() {
        try {
            return (JsonBuilder)Class.forName(this.builderClassName).newInstance();
        }
        catch (Exception e) {
            throw new JsonDiffException("Failed to create JsonBuilder instance for " + this.type, e);
        }
    }

    public static ImplType detectJsonParser() {
        for (ImplType implType : ImplType.values()) {
            try {
                Class.forName(implType.builderClassName);
                return implType;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new JsonDiffException("No JSON parsing framework found, at least one of which implements. fastjson,fastjson2,jackson,gson");
    }
}

