/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.user.controller;

import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.annotation.BusinessLog;
import cn.stylefeng.roses.kernel.rule.enums.ResBizTypeEnum;
import cn.stylefeng.roses.kernel.rule.pojo.dict.SimpleDict;
import cn.stylefeng.roses.kernel.rule.pojo.request.BaseRequest;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.pojo.response.SuccessResponseData;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import cn.stylefeng.roses.kernel.system.api.pojo.user.SysUserDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.user.UserSelectTreeNode;
import cn.stylefeng.roses.kernel.system.api.pojo.user.request.SysUserRequest;
import cn.stylefeng.roses.kernel.system.modular.user.entity.SysUserRole;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserRoleService;
import cn.stylefeng.roses.kernel.system.modular.user.service.SysUserService;
import cn.stylefeng.roses.kernel.system.modular.user.wrapper.UserExpandWrapper;
import cn.stylefeng.roses.kernel.wrapper.api.annotation.Wrapper;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResource(name="\u7528\u6237\u7ba1\u7406", resBizType=ResBizTypeEnum.SYSTEM)
public class SysUserController {
    @Resource
    private SysUserService sysUserService;
    @Resource
    private SysUserRoleService sysUserRoleService;

    @PostResource(name="\u7cfb\u7edf\u7528\u6237_\u589e\u52a0", path={"/sysUser/add"})
    @BusinessLog
    public ResponseData<?> add(@RequestBody @Validated(value={BaseRequest.add.class}) SysUserRequest sysUserRequest) {
        this.sysUserService.add(sysUserRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u7cfb\u7edf\u7528\u6237_\u5220\u9664", path={"/sysUser/delete"})
    @BusinessLog
    public ResponseData<?> delete(@RequestBody @Validated(value={BaseRequest.delete.class}) SysUserRequest sysUserRequest) {
        this.sysUserService.del(sysUserRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u7cfb\u7edf\u7528\u6237_\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u7528\u6237", path={"/sysUser/batchDelete"})
    @BusinessLog
    public ResponseData<?> batchDelete(@RequestBody @Validated(value={BaseRequest.batchDelete.class}) SysUserRequest sysUserRequest) {
        this.sysUserService.batchDelete(sysUserRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u7cfb\u7edf\u7528\u6237_\u7f16\u8f91", path={"/sysUser/edit"})
    @BusinessLog
    public ResponseData<?> edit(@RequestBody @Validated(value={BaseRequest.edit.class}) SysUserRequest sysUserRequest) {
        this.sysUserService.edit(sysUserRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u7cfb\u7edf\u7528\u6237_\u4fee\u6539\u72b6\u6001", path={"/sysUser/changeStatus"})
    @BusinessLog
    public ResponseData<?> changeStatus(@RequestBody @Validated(value={SysUserRequest.changeStatus.class}) SysUserRequest sysUserRequest) {
        this.sysUserService.editStatus(sysUserRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u7cfb\u7edf\u7528\u6237_\u91cd\u7f6e\u5bc6\u7801", path={"/sysUser/resetPwd"})
    @BusinessLog
    public ResponseData<?> resetPwd(@RequestBody @Validated(value={SysUserRequest.resetPwd.class}) SysUserRequest sysUserRequest) {
        this.sysUserService.resetPassword(sysUserRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u7cfb\u7edf\u7528\u6237_\u6388\u6743\u89d2\u8272", path={"/sysUser/grantRole"})
    @BusinessLog
    public ResponseData<?> grantRole(@RequestBody @Validated(value={SysUserRequest.grantRole.class}) SysUserRequest sysUserRequest) {
        this.sysUserService.grantRole(sysUserRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u7cfb\u7edf\u7528\u6237_\u6388\u6743\u6570\u636e", path={"/sysUser/grantData"})
    @BusinessLog
    public ResponseData<?> grantData(@RequestBody @Validated(value={SysUserRequest.grantData.class}) SysUserRequest sysUserRequest) {
        this.sysUserService.grantData(sysUserRequest);
        return new SuccessResponseData();
    }

    @GetResource(name="\u7cfb\u7edf\u7528\u6237_\u67e5\u770b", path={"/sysUser/detail"})
    public ResponseData<SysUserDTO> detail(@Validated(value={BaseRequest.detail.class}) SysUserRequest sysUserRequest) {
        return new SuccessResponseData((Object)this.sysUserService.detail(sysUserRequest));
    }

    @GetResource(name="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u4fe1\u606f", path={"/sysUser/currentUserInfo"}, requiredPermission=false)
    public ResponseData<SysUserDTO> currentUserInfo() {
        LoginUser loginUser = LoginContext.me().getLoginUser();
        SysUserRequest sysUserRequest = new SysUserRequest();
        sysUserRequest.setUserId(loginUser.getUserId());
        return new SuccessResponseData((Object)this.sysUserService.detail(sysUserRequest));
    }

    @GetResource(name="\u7cfb\u7edf\u7528\u6237_\u67e5\u8be2", path={"/sysUser/page"})
    @Wrapper(value={UserExpandWrapper.class})
    public ResponseData<PageResult<SysUserDTO>> page(SysUserRequest sysUserRequest) {
        return new SuccessResponseData(this.sysUserService.findPage(sysUserRequest));
    }

    @GetResource(name="\u7cfb\u7edf\u7528\u6237_\u5bfc\u51fa", path={"/sysUser/export"})
    @BusinessLog
    public void export(HttpServletResponse response) {
        this.sysUserService.export(response);
    }

    @GetResource(name="\u83b7\u53d6\u7528\u6237\u9009\u62e9\u6811\u6570\u636e\uff08\u7528\u5728\u7cfb\u7edf\u901a\u77e5\uff0c\u9009\u62e9\u53d1\u9001\u4eba\u7684\u65f6\u5019\uff09", path={"/sysUser/getUserSelectTree"})
    public ResponseData<List<UserSelectTreeNode>> getUserTree() {
        return new SuccessResponseData(this.sysUserService.userSelectTree(new SysUserRequest()));
    }

    @GetResource(name="\u7cfb\u7edf\u7528\u6237_\u83b7\u53d6\u7528\u6237\u6570\u636e\u8303\u56f4\u5217\u8868", path={"/sysUser/getUserDataScope"})
    public ResponseData<List<Long>> ownData(@Validated(value={BaseRequest.detail.class}) SysUserRequest sysUserRequest) {
        List userBindDataScope = this.sysUserService.getUserBindDataScope(sysUserRequest.getUserId());
        return new SuccessResponseData((Object)userBindDataScope);
    }

    @GetResource(name="\u7cfb\u7edf\u7528\u6237_\u83b7\u53d6\u7528\u6237\u7684\u89d2\u8272\u5217\u8868", path={"/sysUser/getUserRoles"})
    public ResponseData<List<SysUserRole>> ownRole(@Validated(value={BaseRequest.detail.class}) SysUserRequest sysUserRequest) {
        Long userId = sysUserRequest.getUserId();
        return new SuccessResponseData(this.sysUserRoleService.findListByUserId(userId));
    }

    @GetResource(name="\u7cfb\u7edf\u7528\u6237_\u9009\u62e9\u5668", path={"/sysUser/selector"})
    public ResponseData<List<SimpleDict>> selector(SysUserRequest sysUserRequest) {
        return new SuccessResponseData(this.sysUserService.selector(sysUserRequest));
    }

    @GetResource(name="\u7cfb\u7edf\u7528\u6237_\u9009\u62e9\u5668(\u6743\u9650)", path={"/sysUser/selectorByAuthority"}, requiredPermission=false)
    public ResponseData<List<SimpleDict>> selectorByAuthority(SysUserRequest sysUserRequest) {
        return new SuccessResponseData(this.sysUserService.selectorByAuthority(sysUserRequest));
    }

    @GetResource(name="\u7cfb\u7edf\u7528\u6237_\u9009\u62e9\u5668", path={"/sysUser/selectorAll"})
    public ResponseData<List<SimpleDict>> selectorAll(SysUserRequest sysUserRequest) {
        return new SuccessResponseData(this.sysUserService.selectorWithAdmin(sysUserRequest));
    }

    @GetResource(name="\u83b7\u53d6\u6240\u6709\u7528\u6237ID\u548c\u540d\u79f0\u5217\u8868", path={"/sysUser/getAllUserIdList"})
    public ResponseData<List<SysUserRequest>> getAllUserIdList() {
        return new SuccessResponseData(this.sysUserService.getAllUserIdList());
    }

    @GetResource(name="\u8fd0\u7ef4\u5e73\u53f0\u63a5\u53e3\u68c0\u6d4b", path={"/sysUser/devopsApiCheck"}, requiredLogin=false, requiredPermission=false)
    public ResponseData<Integer> devopsApiCheck(SysUserRequest sysUserRequest) {
        return new SuccessResponseData((Object)this.sysUserService.devopsApiCheck(sysUserRequest));
    }

    @GetResource(name="\u6839\u636e\u7528\u6237\u4e3b\u952e\u83b7\u53d6\u7528\u6237\u5bf9\u5e94\u7684token", path={"/sysUser/getTokenByUserId"})
    public ResponseData<String> getTokenByUserId(Long userId) {
        return new SuccessResponseData((Object)this.sysUserService.getTokenByUserId(userId));
    }

    @GetResource(name="\u6839\u636e\u6761\u4ef6\u7b5b\u9009\u7528\u6237", path={"/sysUser/getUserListByConditions"})
    public ResponseData<List<SimpleDict>> getUserListByConditions(SysUserRequest sysUserRequest) {
        return new SuccessResponseData(this.sysUserService.getUserListByConditions(sysUserRequest));
    }

    @PostResource(name="\u83b7\u53d6\u7528\u6237\u5217\u8868\uff0c\u901a\u8fc7\u7528\u6237id\u96c6\u5408", path={"/sysUser/getUsersByUserIds"})
    public ResponseData<List<SysUserDTO>> getUsersByUserIds(@RequestBody @Validated(value={SysUserRequest.getUserList.class}) SysUserRequest sysUserRequest) {
        return new SuccessResponseData((Object)this.sysUserService.getUserInfoList(sysUserRequest.getUserIds()));
    }
}

