/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.theme.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.theme.SysThemeExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.exception.enums.theme.SysThemeTemplateExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.theme.SysThemeTemplateDataDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.theme.SysThemeTemplateRequest;
import cn.stylefeng.roses.kernel.system.modular.theme.entity.SysTheme;
import cn.stylefeng.roses.kernel.system.modular.theme.entity.SysThemeTemplate;
import cn.stylefeng.roses.kernel.system.modular.theme.entity.SysThemeTemplateRel;
import cn.stylefeng.roses.kernel.system.modular.theme.mapper.SysThemeTemplateMapper;
import cn.stylefeng.roses.kernel.system.modular.theme.service.SysThemeService;
import cn.stylefeng.roses.kernel.system.modular.theme.service.SysThemeTemplateRelService;
import cn.stylefeng.roses.kernel.system.modular.theme.service.SysThemeTemplateService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysThemeTemplateServiceImpl
extends ServiceImpl<SysThemeTemplateMapper, SysThemeTemplate>
implements SysThemeTemplateService {
    @Resource
    private SysThemeTemplateMapper sysThemeTemplateMapper;
    @Resource
    private SysThemeService sysThemeService;
    @Resource
    private SysThemeTemplateRelService sysThemeTemplateRelService;

    @Override
    public void add(SysThemeTemplateRequest sysThemeTemplateRequest) {
        SysThemeTemplate sysThemeTemplate = new SysThemeTemplate();
        BeanUtil.copyProperties((Object)sysThemeTemplateRequest, (Object)((Object)sysThemeTemplate), (String[])new String[0]);
        sysThemeTemplate.setStatusFlag(Character.valueOf(YesOrNotEnum.N.getCode().charAt(0)));
        this.save((Object)sysThemeTemplate);
    }

    @Override
    public void edit(SysThemeTemplateRequest sysThemeTemplateRequest) {
        SysThemeTemplate sysThemeTemplate = this.querySysThemeTemplateById(sysThemeTemplateRequest);
        if (YesOrNotEnum.Y.getCode().equals(sysThemeTemplate.getStatusFlag().toString())) {
            throw new SystemModularException((AbstractExceptionEnum)SysThemeTemplateExceptionEnum.TEMPLATE_IS_USED);
        }
        BeanUtil.copyProperties((Object)sysThemeTemplateRequest, (Object)((Object)sysThemeTemplate), (String[])new String[0]);
        this.updateById((Object)sysThemeTemplate);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(SysThemeTemplateRequest sysThemeTemplateRequest) {
        SysThemeTemplate sysThemeTemplate = this.querySysThemeTemplateById(sysThemeTemplateRequest);
        if (sysThemeTemplate.getTemplateCode().toUpperCase(Locale.ROOT).startsWith("GUNS")) {
            throw new SystemModularException((AbstractExceptionEnum)SysThemeExceptionEnum.THEME_IS_SYSTEM);
        }
        if (YesOrNotEnum.Y.getCode().equals(sysThemeTemplate.getStatusFlag().toString())) {
            throw new SystemModularException((AbstractExceptionEnum)SysThemeTemplateExceptionEnum.TEMPLATE_IS_ENABLE);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysThemeTemplateRel::getTemplateId, (Object)sysThemeTemplate.getTemplateId());
        this.sysThemeTemplateRelService.remove((Wrapper)queryWrapper);
        this.removeById((Object)sysThemeTemplate);
    }

    @Override
    public PageResult<SysThemeTemplate> findPage(SysThemeTemplateRequest sysThemeTemplateRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(StrUtil.isNotBlank((CharSequence)sysThemeTemplateRequest.getTemplateName()), SysThemeTemplate::getTemplateName, (Object)sysThemeTemplateRequest.getTemplateName());
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)queryWrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public List<SysThemeTemplate> findList(SysThemeTemplateRequest sysThemeTemplateRequest) {
        return this.list();
    }

    @Override
    public void updateTemplateStatus(SysThemeTemplateRequest sysThemeTemplateRequest) {
        SysThemeTemplate sysThemeTemplate = this.querySysThemeTemplateById(sysThemeTemplateRequest);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysTheme::getTemplateId, (Object)sysThemeTemplate.getTemplateId());
        long sysThemeNum = this.sysThemeService.count((Wrapper)queryWrapper);
        if (sysThemeNum > 0L) {
            throw new SystemModularException((AbstractExceptionEnum)SysThemeTemplateExceptionEnum.TEMPLATE_IS_USED);
        }
        if (YesOrNotEnum.Y.getCode().equals(sysThemeTemplate.getStatusFlag().toString())) {
            sysThemeTemplate.setStatusFlag(Character.valueOf(YesOrNotEnum.N.getCode().charAt(0)));
        } else {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysThemeTemplateRel::getTemplateId, (Object)sysThemeTemplate.getTemplateId());
            List sysThemeTemplateRels = this.sysThemeTemplateRelService.list((Wrapper)wrapper);
            if (sysThemeTemplateRels.size() <= 0) {
                throw new SystemModularException((AbstractExceptionEnum)SysThemeTemplateExceptionEnum.TEMPLATE_NOT_ATTRIBUTE);
            }
            sysThemeTemplate.setStatusFlag(Character.valueOf(YesOrNotEnum.Y.getCode().charAt(0)));
        }
        this.updateById((Object)sysThemeTemplate);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<SysThemeTemplateDataDTO> detail(SysThemeTemplateRequest sysThemeTemplateRequest) {
        return this.sysThemeTemplateMapper.sysThemeTemplateDetail(sysThemeTemplateRequest.getTemplateId());
    }

    private SysThemeTemplate querySysThemeTemplateById(SysThemeTemplateRequest sysThemeTemplateRequest) {
        SysThemeTemplate sysThemeTemplate = (SysThemeTemplate)((Object)this.getById(sysThemeTemplateRequest.getTemplateId()));
        if (ObjectUtil.isNull((Object)((Object)sysThemeTemplate))) {
            throw new SystemModularException((AbstractExceptionEnum)SysThemeTemplateExceptionEnum.TEMPLATE_NOT_EXIT);
        }
        return sysThemeTemplate;
    }
}

