/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.theme.service.impl;

import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.theme.SysThemeTemplateExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.theme.SysThemeTemplateRelRequest;
import cn.stylefeng.roses.kernel.system.modular.theme.entity.SysThemeTemplate;
import cn.stylefeng.roses.kernel.system.modular.theme.entity.SysThemeTemplateRel;
import cn.stylefeng.roses.kernel.system.modular.theme.mapper.SysThemeTemplateRelMapper;
import cn.stylefeng.roses.kernel.system.modular.theme.service.SysThemeTemplateRelService;
import cn.stylefeng.roses.kernel.system.modular.theme.service.SysThemeTemplateService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysThemeTemplateRelServiceImpl
extends ServiceImpl<SysThemeTemplateRelMapper, SysThemeTemplateRel>
implements SysThemeTemplateRelService {
    @Resource
    private SysThemeTemplateService sysThemeTemplateService;

    @Override
    public void add(SysThemeTemplateRelRequest sysThemeTemplateRelRequest) {
        this.checkTemplateStatus(sysThemeTemplateRelRequest);
        String[] fieldCodes = sysThemeTemplateRelRequest.getFieldCodes();
        ArrayList<SysThemeTemplateRel> sysThemeTemplateRels = new ArrayList<SysThemeTemplateRel>();
        for (String fieldCode : fieldCodes) {
            SysThemeTemplateRel sysThemeTemplateRel = new SysThemeTemplateRel();
            sysThemeTemplateRel.setTemplateId(sysThemeTemplateRelRequest.getTemplateId());
            sysThemeTemplateRel.setFieldCode(fieldCode);
            sysThemeTemplateRels.add(sysThemeTemplateRel);
        }
        this.saveBatch(sysThemeTemplateRels);
    }

    private void checkTemplateStatus(SysThemeTemplateRelRequest sysThemeTemplateRelRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysThemeTemplate::getTemplateId, (Object)sysThemeTemplateRelRequest.getTemplateId());
        SysThemeTemplate sysThemeTemplate = (SysThemeTemplate)((Object)this.sysThemeTemplateService.getOne((Wrapper)queryWrapper, true));
        if (YesOrNotEnum.Y.getCode().equals(sysThemeTemplate.getStatusFlag().toString())) {
            throw new SystemModularException((AbstractExceptionEnum)SysThemeTemplateExceptionEnum.TEMPLATE_IS_USED);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(SysThemeTemplateRelRequest sysThemeTemplateRelRequest) {
        this.checkTemplateStatus(sysThemeTemplateRelRequest);
        Object[] fieldCodes = sysThemeTemplateRelRequest.getFieldCodes();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysThemeTemplateRel::getFieldCode, fieldCodes);
        this.remove((Wrapper)queryWrapper);
    }
}

