/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.theme.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.theme.SysThemeExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.exception.enums.theme.SysThemeTemplateFieldExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.theme.SysThemeTemplateFieldRequest;
import cn.stylefeng.roses.kernel.system.modular.theme.entity.SysThemeTemplateField;
import cn.stylefeng.roses.kernel.system.modular.theme.entity.SysThemeTemplateRel;
import cn.stylefeng.roses.kernel.system.modular.theme.enums.ThemeFieldTypeEnum;
import cn.stylefeng.roses.kernel.system.modular.theme.mapper.SysThemeTemplateFieldMapper;
import cn.stylefeng.roses.kernel.system.modular.theme.service.SysThemeTemplateFieldService;
import cn.stylefeng.roses.kernel.system.modular.theme.service.SysThemeTemplateRelService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysThemeTemplateFieldServiceImpl
extends ServiceImpl<SysThemeTemplateFieldMapper, SysThemeTemplateField>
implements SysThemeTemplateFieldService {
    @Resource
    private SysThemeTemplateRelService sysThemeTemplateRelService;

    @Override
    public void add(SysThemeTemplateFieldRequest sysThemeTemplateFieldRequest) {
        SysThemeTemplateField sysThemeTemplateField = new SysThemeTemplateField();
        BeanUtil.copyProperties((Object)sysThemeTemplateFieldRequest, (Object)((Object)sysThemeTemplateField), (String[])new String[0]);
        sysThemeTemplateField.setFieldRequired(Character.valueOf(StringUtils.isBlank((CharSequence)sysThemeTemplateFieldRequest.getFieldType()) ? YesOrNotEnum.N.getCode().charAt(0) : sysThemeTemplateFieldRequest.getFieldRequired().charValue()));
        this.save((Object)sysThemeTemplateField);
    }

    @Override
    public void del(SysThemeTemplateFieldRequest sysThemeTemplateFieldRequest) {
        SysThemeTemplateField sysThemeTemplateField = this.queryThemeTemplateFieldById(sysThemeTemplateFieldRequest);
        if (sysThemeTemplateField.getFieldCode().toUpperCase(Locale.ROOT).startsWith("GUNS")) {
            throw new SystemModularException((AbstractExceptionEnum)SysThemeExceptionEnum.THEME_IS_SYSTEM);
        }
        this.verificationAttributeUsage(sysThemeTemplateField);
        this.removeById(sysThemeTemplateField.getFieldId());
    }

    private void verificationAttributeUsage(SysThemeTemplateField sysThemeTemplateField) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysThemeTemplateRel::getFieldCode, (Object)sysThemeTemplateField.getFieldCode());
        List themeTemplateRels = this.sysThemeTemplateRelService.list((Wrapper)queryWrapper);
        if (themeTemplateRels.size() > 0) {
            throw new SystemModularException((AbstractExceptionEnum)SysThemeTemplateFieldExceptionEnum.FIELD_IS_USED);
        }
    }

    @Override
    public void edit(SysThemeTemplateFieldRequest sysThemeTemplateFieldRequest) {
        SysThemeTemplateField sysThemeTemplateField = this.queryThemeTemplateFieldById(sysThemeTemplateFieldRequest);
        sysThemeTemplateFieldRequest.setFieldCode(null);
        BeanUtil.copyProperties((Object)sysThemeTemplateFieldRequest, (Object)((Object)sysThemeTemplateField), (String[])new String[0]);
        this.updateById((Object)sysThemeTemplateField);
    }

    @Override
    public SysThemeTemplateField detail(SysThemeTemplateFieldRequest sysThemeTemplateFieldRequest) {
        return this.queryThemeTemplateFieldById(sysThemeTemplateFieldRequest);
    }

    @Override
    public PageResult<SysThemeTemplateField> findPage(SysThemeTemplateFieldRequest sysThemeTemplateFieldRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(StrUtil.isNotBlank((CharSequence)sysThemeTemplateFieldRequest.getFieldName()), SysThemeTemplateField::getFieldName, (Object)sysThemeTemplateFieldRequest.getFieldName());
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)queryWrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public List<SysThemeTemplateField> findRelList(SysThemeTemplateFieldRequest sysThemeTemplateFieldRequest) {
        List<String> fieldCodes = this.getFieldCodes(sysThemeTemplateFieldRequest, this.sysThemeTemplateRelService);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List sysThemeTemplateFields = null;
        if (fieldCodes.size() > 0) {
            queryWrapper.in(SysThemeTemplateField::getFieldCode, fieldCodes);
            sysThemeTemplateFields = this.list((Wrapper)queryWrapper);
        }
        return sysThemeTemplateFields;
    }

    private List<String> getFieldCodes(SysThemeTemplateFieldRequest sysThemeTemplateFieldRequest, SysThemeTemplateRelService sysThemeTemplateRelService) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysThemeTemplateRel::getTemplateId, (Object)sysThemeTemplateFieldRequest.getTemplateId());
        List sysThemeTemplateRels = sysThemeTemplateRelService.list((Wrapper)queryWrapper);
        List<String> fieldCodes = sysThemeTemplateRels.stream().map(SysThemeTemplateRel::getFieldCode).collect(Collectors.toList());
        return fieldCodes;
    }

    @Override
    public List<SysThemeTemplateField> findNotRelList(SysThemeTemplateFieldRequest sysThemeTemplateFieldRequest) {
        List sysThemeTemplateFields;
        List<String> fieldCodes = this.getFieldCodes(sysThemeTemplateFieldRequest, this.sysThemeTemplateRelService);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (fieldCodes.size() > 0) {
            queryWrapper.notIn(SysThemeTemplateField::getFieldCode, fieldCodes);
            sysThemeTemplateFields = this.list((Wrapper)queryWrapper);
        } else {
            sysThemeTemplateFields = this.list();
        }
        return sysThemeTemplateFields;
    }

    @Override
    public boolean getKeyFileFlag(String code) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysThemeTemplateField::getFieldCode, (Object)code);
        wrapper.select(new SFunction[]{SysThemeTemplateField::getFieldType});
        SysThemeTemplateField sysThemeTemplateField = (SysThemeTemplateField)((Object)this.getOne((Wrapper)wrapper, false));
        if (sysThemeTemplateField == null) {
            return false;
        }
        return ThemeFieldTypeEnum.FILE.getCode().equals(sysThemeTemplateField.getFieldType());
    }

    private SysThemeTemplateField queryThemeTemplateFieldById(SysThemeTemplateFieldRequest sysThemeTemplateFieldRequest) {
        SysThemeTemplateField sysThemeTemplateField = (SysThemeTemplateField)((Object)this.getById(sysThemeTemplateFieldRequest.getFieldId()));
        if (ObjectUtil.isNull((Object)((Object)sysThemeTemplateField))) {
            throw new SystemModularException((AbstractExceptionEnum)SysThemeTemplateFieldExceptionEnum.FIELD_NOT_EXIST);
        }
        return sysThemeTemplateField;
    }
}

