/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.role.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.enums.DataScopeTypeEnum;
import cn.stylefeng.roses.kernel.auth.api.exception.AuthException;
import cn.stylefeng.roses.kernel.auth.api.exception.enums.AuthExceptionEnum;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.basic.SimpleRoleInfo;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.rule.pojo.dict.SimpleDict;
import cn.stylefeng.roses.kernel.system.api.MenuServiceApi;
import cn.stylefeng.roses.kernel.system.api.UserServiceApi;
import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.role.SysRoleExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.role.dto.SysRoleDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.role.dto.SysRoleMenuButtonDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.role.dto.SysRoleMenuDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.role.dto.SysRoleResourceDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.role.request.SysRoleMenuButtonRequest;
import cn.stylefeng.roses.kernel.system.api.pojo.role.request.SysRoleRequest;
import cn.stylefeng.roses.kernel.system.api.util.DataScopeUtil;
import cn.stylefeng.roses.kernel.system.modular.role.entity.SysRole;
import cn.stylefeng.roses.kernel.system.modular.role.entity.SysRoleDataScope;
import cn.stylefeng.roses.kernel.system.modular.role.entity.SysRoleMenu;
import cn.stylefeng.roses.kernel.system.modular.role.entity.SysRoleMenuButton;
import cn.stylefeng.roses.kernel.system.modular.role.entity.SysRoleResource;
import cn.stylefeng.roses.kernel.system.modular.role.mapper.SysRoleMapper;
import cn.stylefeng.roses.kernel.system.modular.role.service.SysRoleDataScopeService;
import cn.stylefeng.roses.kernel.system.modular.role.service.SysRoleMenuButtonService;
import cn.stylefeng.roses.kernel.system.modular.role.service.SysRoleMenuService;
import cn.stylefeng.roses.kernel.system.modular.role.service.SysRoleResourceService;
import cn.stylefeng.roses.kernel.system.modular.role.service.SysRoleService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysRoleServiceImpl
extends ServiceImpl<SysRoleMapper, SysRole>
implements SysRoleService {
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private SysRoleResourceService sysRoleResourceService;
    @Resource
    private SysRoleDataScopeService sysRoleDataScopeService;
    @Resource
    private SysRoleMenuService roleMenuService;
    @Resource
    private SysRoleMenuButtonService sysRoleMenuButtonService;
    @Resource
    private MenuServiceApi menuServiceApi;
    @Resource
    private CacheOperatorApi<SysRole> roleInfoCacheApi;
    @Resource(name="roleResourceCacheApi")
    private CacheOperatorApi<List<String>> roleResourceCacheApi;
    @Resource(name="roleDataScopeCacheApi")
    private CacheOperatorApi<List<Long>> roleDataScopeCacheApi;

    @Override
    public void add(SysRoleRequest sysRoleRequest) {
        SysRole sysRole = new SysRole();
        BeanUtil.copyProperties((Object)sysRoleRequest, (Object)((Object)sysRole), (String[])new String[0]);
        sysRole.setStatusFlag(StatusEnum.ENABLE.getCode());
        sysRole.setRoleSystemFlag(YesOrNotEnum.N.getCode());
        sysRole.setDataScopeType(DataScopeTypeEnum.SELF.getCode());
        this.save((Object)sysRole);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(SysRoleRequest sysRoleRequest) {
        SysRole sysRole = this.querySysRole(sysRoleRequest);
        if (YesOrNotEnum.Y.getCode().equals(sysRole.getRoleSystemFlag())) {
            throw new ServiceException((AbstractExceptionEnum)SysRoleExceptionEnum.SYSTEM_ROLE_CANT_DELETE);
        }
        sysRole.setDelFlag(YesOrNotEnum.Y.getCode());
        this.updateById((Object)sysRole);
        Long roleId = sysRole.getRoleId();
        this.sysRoleDataScopeService.delByRoleId(roleId);
        this.userServiceApi.deleteUserRoleListByRoleId(roleId);
        this.sysRoleResourceService.deleteRoleResourceListByRoleId(roleId);
        this.roleInfoCacheApi.remove(new String[]{String.valueOf(roleId)});
        this.roleDataScopeCacheApi.remove(new String[]{String.valueOf(sysRoleRequest.getRoleId())});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(SysRoleRequest sysRoleRequest) {
        SysRole sysRole = this.querySysRole(sysRoleRequest);
        if ("superAdmin".equals(sysRole.getRoleCode()) && !sysRole.getRoleCode().equals(sysRoleRequest.getRoleCode())) {
            throw new SystemModularException((AbstractExceptionEnum)SysRoleExceptionEnum.SUPER_ADMIN_ROLE_CODE_ERROR);
        }
        BeanUtil.copyProperties((Object)sysRoleRequest, (Object)((Object)sysRole), (String[])new String[0]);
        sysRole.setStatusFlag(null);
        this.updateById((Object)sysRole);
        this.roleInfoCacheApi.remove(new String[]{String.valueOf(sysRoleRequest.getRoleId())});
    }

    @Override
    public SysRoleDTO detail(SysRoleRequest sysRoleRequest) {
        SysRole sysRole = this.querySysRole(sysRoleRequest);
        SysRoleDTO roleResponse = new SysRoleDTO();
        BeanUtil.copyProperties((Object)((Object)sysRole), (Object)roleResponse, (String[])new String[0]);
        roleResponse.setDataScopeTypeEnum(DataScopeTypeEnum.codeToEnum((Integer)sysRole.getDataScopeType()));
        return roleResponse;
    }

    @Override
    public PageResult<SysRole> findPage(SysRoleRequest sysRoleRequest) {
        LambdaQueryWrapper<SysRole> wrapper = this.createWrapper(sysRoleRequest);
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    public List<SimpleDict> findList(SysRoleRequest sysRoleParam) {
        ArrayList dictList = CollectionUtil.newArrayList((Object[])new SimpleDict[0]);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (ObjectUtil.isNotNull((Object)sysRoleParam) && ObjectUtil.isNotEmpty((Object)sysRoleParam.getRoleName())) {
            queryWrapper.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(SysRole::getRoleName, (Object)sysRoleParam.getRoleName())).or()).like(SysRole::getRoleCode, (Object)sysRoleParam.getRoleName());
            });
        }
        queryWrapper.eq(SysRole::getStatusFlag, (Object)StatusEnum.ENABLE.getCode());
        queryWrapper.orderByAsc(SysRole::getRoleSort);
        this.list((Wrapper)queryWrapper).forEach(sysRole -> {
            SimpleDict simpleDict = new SimpleDict();
            simpleDict.setId(sysRole.getRoleId());
            simpleDict.setName(sysRole.getRoleName() + "[" + sysRole.getRoleCode() + "]");
            dictList.add(simpleDict);
        });
        return dictList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void grantMenuAndButton(SysRoleRequest sysRoleMenuButtonRequest) {
        List menuButtonList;
        LambdaQueryWrapper sysRoleMenuLqw = new LambdaQueryWrapper();
        sysRoleMenuLqw.eq(SysRoleMenu::getRoleId, (Object)sysRoleMenuButtonRequest.getRoleId());
        this.roleMenuService.remove((Wrapper)sysRoleMenuLqw);
        LambdaQueryWrapper menuButtonLqw = new LambdaQueryWrapper();
        menuButtonLqw.eq(SysRoleMenuButton::getRoleId, (Object)sysRoleMenuButtonRequest.getRoleId());
        this.sysRoleMenuButtonService.remove((Wrapper)menuButtonLqw);
        List menuIdList = sysRoleMenuButtonRequest.getGrantMenuIdList();
        if (ObjectUtil.isNotEmpty((Object)menuIdList)) {
            SysRoleMenu item;
            ArrayList<SysRoleMenu> sysRoleMenus = new ArrayList<SysRoleMenu>();
            Long roleId = sysRoleMenuButtonRequest.getRoleId();
            Set allParentMenuId = this.menuServiceApi.getMenuAllParentMenuId(new HashSet(menuIdList));
            for (Long menuId : allParentMenuId) {
                item = new SysRoleMenu();
                item.setRoleId(roleId);
                item.setMenuId(menuId);
                sysRoleMenus.add(item);
            }
            for (Long menuId : menuIdList) {
                item = new SysRoleMenu();
                item.setRoleId(roleId);
                item.setMenuId(menuId);
                sysRoleMenus.add(item);
            }
            this.roleMenuService.saveBatch(sysRoleMenus);
        }
        if (ObjectUtil.isNotEmpty((Object)(menuButtonList = sysRoleMenuButtonRequest.getGrantMenuButtonIdList()))) {
            ArrayList<SysRoleMenuButton> sysRoleMenuButtons = new ArrayList<SysRoleMenuButton>();
            for (SysRoleMenuButtonRequest menuButton : menuButtonList) {
                SysRoleMenuButton item = new SysRoleMenuButton();
                item.setRoleId(sysRoleMenuButtonRequest.getRoleId());
                item.setButtonId(menuButton.getButtonId());
                item.setButtonCode(menuButton.getButtonCode());
                sysRoleMenuButtons.add(item);
            }
            this.sysRoleMenuButtonService.saveBatch(sysRoleMenuButtons);
        }
    }

    @Override
    public void grantMenu(SysRoleRequest sysRoleMenuButtonRequest) {
        Boolean grantAddMenuFlag = sysRoleMenuButtonRequest.getGrantAddMenuFlag();
        if (grantAddMenuFlag.booleanValue()) {
            SysRoleMenu item = new SysRoleMenu();
            item.setRoleId(sysRoleMenuButtonRequest.getRoleId());
            item.setMenuId(sysRoleMenuButtonRequest.getGrantMenuId());
            this.roleMenuService.save((Object)item);
        } else {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(SysRoleMenu::getRoleId, (Object)sysRoleMenuButtonRequest.getRoleId());
            wrapper.eq(SysRoleMenu::getMenuId, (Object)sysRoleMenuButtonRequest.getGrantMenuId());
            this.roleMenuService.remove((Wrapper)wrapper);
        }
    }

    @Override
    public void grantButton(SysRoleRequest sysRoleMenuButtonRequest) {
        List selectedButtonIds;
        List modularButtonIds = sysRoleMenuButtonRequest.getModularButtonIds();
        if (ObjectUtil.isNotEmpty((Object)modularButtonIds)) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.in(SysRoleMenuButton::getButtonId, (Collection)modularButtonIds);
            wrapper.eq(SysRoleMenuButton::getRoleId, (Object)sysRoleMenuButtonRequest.getRoleId());
            this.sysRoleMenuButtonService.remove((Wrapper)wrapper);
        }
        if (ObjectUtil.isNotEmpty((Object)(selectedButtonIds = sysRoleMenuButtonRequest.getSelectedButtonIds()))) {
            ArrayList<SysRoleMenuButton> sysRoleMenuButtons = new ArrayList<SysRoleMenuButton>();
            for (Long selectButtonId : selectedButtonIds) {
                SysRoleMenuButton sysRoleMenuButton = new SysRoleMenuButton();
                sysRoleMenuButton.setRoleId(sysRoleMenuButtonRequest.getRoleId());
                sysRoleMenuButton.setButtonId(selectButtonId);
                String buttonCode = this.menuServiceApi.getMenuButtonCodeByButtonId(selectButtonId);
                sysRoleMenuButton.setButtonCode(buttonCode);
                sysRoleMenuButtons.add(sysRoleMenuButton);
            }
            this.sysRoleMenuButtonService.saveBatch(sysRoleMenuButtons, sysRoleMenuButtons.size());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void grantDataScope(SysRoleRequest sysRoleRequest) {
        SysRole sysRole = this.querySysRole(sysRoleRequest);
        boolean superAdmin = LoginContext.me().getSuperAdminFlag();
        Integer dataScopeType = sysRoleRequest.getDataScopeType();
        DataScopeTypeEnum dataScopeTypeEnum = DataScopeTypeEnum.codeToEnum((Integer)dataScopeType);
        if (!superAdmin) {
            if (DataScopeTypeEnum.ALL.equals((Object)dataScopeTypeEnum)) {
                throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.ONLY_SUPER_ERROR);
            }
            if (DataScopeTypeEnum.DEFINE.getCode().equals(dataScopeType)) {
                if (ObjectUtil.isEmpty((Object)sysRoleRequest.getGrantOrgIdList())) {
                    throw new SystemModularException((AbstractExceptionEnum)SysRoleExceptionEnum.PLEASE_FILL_DATA_SCOPE);
                }
                for (Long orgId : sysRoleRequest.getGrantOrgIdList()) {
                    DataScopeUtil.quickValidateDataScope((Long)orgId);
                }
            }
        }
        sysRole.setDataScopeType(sysRoleRequest.getDataScopeType());
        this.updateById((Object)sysRole);
        this.sysRoleDataScopeService.grantDataScope(sysRoleRequest);
        this.roleDataScopeCacheApi.remove(new String[]{String.valueOf(sysRoleRequest.getRoleId())});
    }

    @Override
    public List<SimpleDict> dropDown() {
        ArrayList dictList = CollectionUtil.newArrayList((Object[])new SimpleDict[0]);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (!LoginContext.me().getSuperAdminFlag()) {
            List roles = LoginContext.me().getLoginUser().getSimpleRoleInfoList();
            Set loginUserRoleIds = roles.stream().map(SimpleRoleInfo::getRoleId).collect(Collectors.toSet());
            if (ObjectUtil.isEmpty(loginUserRoleIds)) {
                return dictList;
            }
            queryWrapper.in(SysRole::getRoleId, loginUserRoleIds);
        }
        ((LambdaQueryWrapper)queryWrapper.eq(SysRole::getStatusFlag, (Object)StatusEnum.ENABLE.getCode())).eq(SysRole::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        this.list((Wrapper)queryWrapper).forEach(sysRole -> {
            SimpleDict simpleDict = new SimpleDict();
            simpleDict.setId(sysRole.getRoleId());
            simpleDict.setCode(sysRole.getRoleCode());
            simpleDict.setName(sysRole.getRoleName());
            dictList.add(simpleDict);
        });
        return dictList;
    }

    @Override
    public List<Long> getRoleDataScope(SysRoleRequest sysRoleRequest) {
        SysRole sysRole = this.querySysRole(sysRoleRequest);
        return this.sysRoleDataScopeService.getRoleDataScopeIdList(CollectionUtil.newArrayList((Object[])new Long[]{sysRole.getRoleId()}));
    }

    public List<SysRoleDTO> getRolesByIds(List<Long> roleIds) {
        ArrayList<SysRoleDTO> sysRoleResponses = new ArrayList<SysRoleDTO>();
        for (Long roleId : roleIds) {
            SysRoleRequest sysRoleRequest = new SysRoleRequest();
            sysRoleRequest.setRoleId(roleId);
            SysRoleDTO detail2 = this.detail(sysRoleRequest);
            sysRoleResponses.add(detail2);
        }
        return sysRoleResponses;
    }

    public List<Long> getRoleDataScopes(List<Long> roleIds) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (ObjectUtil.isEmpty(roleIds)) {
            return result;
        }
        for (Long roleId : roleIds) {
            String key = String.valueOf(roleId);
            List scopes = (List)this.roleDataScopeCacheApi.get(key);
            if (scopes != null) {
                result.addAll(scopes);
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysRoleDataScope::getRoleId, (Object)roleId);
            List list = this.sysRoleDataScopeService.list((Wrapper)queryWrapper);
            if (list.isEmpty()) continue;
            List realScopes = list.stream().map(SysRoleDataScope::getOrganizationId).collect(Collectors.toList());
            result.addAll(realScopes);
            this.roleDataScopeCacheApi.put(key, realScopes);
        }
        return result;
    }

    public List<Long> getMenuIdsByRoleIds(List<Long> roleIds) {
        if (roleIds == null || roleIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleMenu::getRoleId, roleIds);
        queryWrapper.select(new SFunction[]{SysRoleMenu::getMenuId});
        List roleMenus = this.roleMenuService.list((Wrapper)queryWrapper);
        if (roleMenus == null || roleMenus.isEmpty()) {
            return new ArrayList<Long>();
        }
        return roleMenus.stream().map(SysRoleMenu::getMenuId).collect(Collectors.toList());
    }

    public Set<String> getRoleResourceCodeList(List<Long> roleIdList) {
        HashSet<String> result = new HashSet<String>();
        for (Long roleId : roleIdList) {
            String key = String.valueOf(roleId);
            List resourceCodesCache = (List)this.roleResourceCacheApi.get(key);
            if (ObjectUtil.isNotEmpty((Object)resourceCodesCache)) {
                result.addAll(resourceCodesCache);
                continue;
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.select(new SFunction[]{SysRoleResource::getResourceCode});
            queryWrapper.eq(SysRoleResource::getRoleId, (Object)roleId);
            List sysRoleResources = this.sysRoleResourceService.list((Wrapper)queryWrapper);
            List sysResourceCodes = sysRoleResources.parallelStream().map(SysRoleResource::getResourceCode).collect(Collectors.toList());
            if (!ObjectUtil.isNotEmpty(sysResourceCodes)) continue;
            result.addAll(sysResourceCodes);
            this.roleResourceCacheApi.put(key, sysResourceCodes);
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(SysRoleMenu::getRoleId, roleIdList);
        wrapper.select(new SFunction[]{SysRoleMenu::getMenuId});
        List list = this.roleMenuService.list((Wrapper)wrapper);
        List menuIds = list.stream().map(SysRoleMenu::getMenuId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.in(SysRoleMenuButton::getRoleId, roleIdList);
        wrapper2.select(new SFunction[]{SysRoleMenuButton::getButtonId});
        List roleMenuButtons = this.sysRoleMenuButtonService.list((Wrapper)wrapper2);
        List buttonIds = roleMenuButtons.stream().map(SysRoleMenuButton::getButtonId).collect(Collectors.toList());
        ArrayList businessIds = new ArrayList();
        businessIds.addAll(menuIds);
        businessIds.addAll(buttonIds);
        List menuButtonResources = this.menuServiceApi.getResourceCodesByBusinessId(businessIds);
        result.addAll(menuButtonResources);
        return result;
    }

    public List<SysRoleResourceDTO> getRoleResourceList(List<Long> roleIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleResource::getRoleId, roleIdList);
        List sysRoleResources = this.sysRoleResourceService.list((Wrapper)queryWrapper);
        return sysRoleResources.parallelStream().map(item -> (SysRoleResourceDTO)BeanUtil.copyProperties((Object)item, SysRoleResourceDTO.class, (String[])new String[0])).collect(Collectors.toList());
    }

    public Set<String> getRoleButtonCodes(List<Long> roleIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleMenuButton::getRoleId, roleIdList);
        queryWrapper.select(new SFunction[]{SysRoleMenuButton::getButtonCode});
        List list = this.sysRoleMenuButtonService.list((Wrapper)queryWrapper);
        return list.stream().map(SysRoleMenuButton::getButtonCode).collect(Collectors.toSet());
    }

    public List<SysRoleMenuDTO> getRoleMenuList(List<Long> roleIdList) {
        LambdaQueryWrapper sysRoleMenuLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleMenuLambdaQueryWrapper.in(SysRoleMenu::getRoleId, roleIdList);
        List roleMenus = this.roleMenuService.list((Wrapper)sysRoleMenuLambdaQueryWrapper);
        return roleMenus.parallelStream().map(item -> (SysRoleMenuDTO)BeanUtil.copyProperties((Object)item, SysRoleMenuDTO.class, (String[])new String[0])).collect(Collectors.toList());
    }

    public List<SysRoleMenuButtonDTO> getRoleMenuButtonList(List<Long> roleIdList) {
        LambdaQueryWrapper sysRoleMenuButtonLambdaQueryWrapper = new LambdaQueryWrapper();
        sysRoleMenuButtonLambdaQueryWrapper.in(SysRoleMenuButton::getRoleId, roleIdList);
        List sysRoleMenuButtons = this.sysRoleMenuButtonService.list((Wrapper)sysRoleMenuButtonLambdaQueryWrapper);
        return sysRoleMenuButtons.parallelStream().map(item -> (SysRoleMenuButtonDTO)BeanUtil.copyProperties((Object)item, SysRoleMenuButtonDTO.class, (String[])new String[0])).collect(Collectors.toList());
    }

    private SysRole querySysRole(SysRoleRequest sysRoleRequest) {
        String key = String.valueOf(sysRoleRequest.getRoleId());
        SysRole sysRoleCache = (SysRole)((Object)this.roleInfoCacheApi.get(key));
        if (sysRoleCache != null) {
            return sysRoleCache;
        }
        SysRole sysRole = (SysRole)((Object)this.getById(sysRoleRequest.getRoleId()));
        if (ObjectUtil.isNull((Object)((Object)sysRole))) {
            throw new SystemModularException((AbstractExceptionEnum)SysRoleExceptionEnum.ROLE_NOT_EXIST);
        }
        this.roleInfoCacheApi.put(key, (Object)sysRole);
        return sysRole;
    }

    private LambdaQueryWrapper<SysRole> createWrapper(SysRoleRequest sysRoleRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRole::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        queryWrapper.orderByAsc(SysRole::getRoleSort);
        if (ObjectUtil.isEmpty((Object)sysRoleRequest)) {
            return queryWrapper;
        }
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)sysRoleRequest.getRoleName()), SysRole::getRoleName, (Object)sysRoleRequest.getRoleName());
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)sysRoleRequest.getRoleCode()), SysRole::getRoleCode, (Object)sysRoleRequest.getRoleCode());
        return queryWrapper;
    }
}

