/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.role.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.system.api.pojo.role.request.SysRoleRequest;
import cn.stylefeng.roses.kernel.system.modular.role.entity.SysRoleResource;
import cn.stylefeng.roses.kernel.system.modular.role.mapper.SysRoleResourceMapper;
import cn.stylefeng.roses.kernel.system.modular.role.service.SysRoleResourceService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysRoleResourceServiceImpl
extends ServiceImpl<SysRoleResourceMapper, SysRoleResource>
implements SysRoleResourceService {
    @Resource(name="roleResourceCacheApi")
    private CacheOperatorApi<List<String>> roleResourceCacheApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void grantResource(SysRoleRequest sysRoleRequest) {
        Long roleId = sysRoleRequest.getRoleId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleResource::getRoleId, (Object)roleId);
        this.remove((Wrapper)queryWrapper);
        this.roleResourceCacheApi.remove(new String[]{String.valueOf(roleId)});
        List grantResourceList = sysRoleRequest.getGrantResourceList();
        ArrayList<SysRoleResource> sysRoleResources = new ArrayList<SysRoleResource>();
        for (String resourceId : grantResourceList) {
            SysRoleResource sysRoleMenu = new SysRoleResource();
            sysRoleMenu.setRoleId(roleId);
            sysRoleMenu.setResourceCode(resourceId);
            sysRoleResources.add(sysRoleMenu);
        }
        this.saveBatch(sysRoleResources);
    }

    @Override
    public void grantResourceV2(SysRoleRequest sysRoleRequest) {
        List selectedResource;
        List modularTotalResource = sysRoleRequest.getModularTotalResource();
        if (ObjectUtil.isNotEmpty((Object)modularTotalResource)) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.in(SysRoleResource::getResourceCode, (Collection)modularTotalResource);
            wrapper.eq(SysRoleResource::getRoleId, (Object)sysRoleRequest.getRoleId());
            this.remove((Wrapper)wrapper);
        }
        if (ObjectUtil.isNotEmpty((Object)(selectedResource = sysRoleRequest.getSelectedResource()))) {
            ArrayList<SysRoleResource> menuResources = new ArrayList<SysRoleResource>();
            for (String resourceCode : selectedResource) {
                SysRoleResource sysRoleResource = new SysRoleResource();
                sysRoleResource.setRoleId(sysRoleRequest.getRoleId());
                sysRoleResource.setResourceCode(resourceCode);
                menuResources.add(sysRoleResource);
            }
            this.saveBatch(menuResources, menuResources.size());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRoleResourceListByResourceIds(List<Long> resourceIds) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.select(new SFunction[]{SysRoleResource::getRoleId});
        wrapper1.in(SysRoleResource::getResourceCode, resourceIds);
        wrapper1.groupBy(SysRoleResource::getRoleId);
        List toGetRoles = this.list((Wrapper)wrapper1);
        List roleIds = toGetRoles.stream().map(SysRoleResource::getRoleId).collect(Collectors.toList());
        for (Long roleId : roleIds) {
            this.roleResourceCacheApi.remove(new String[]{String.valueOf(roleId)});
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleResource::getResourceCode, resourceIds);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRoleResourceListByRoleId(Long roleId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleResource::getRoleId, (Object)roleId);
        this.remove((Wrapper)queryWrapper);
        this.roleResourceCacheApi.remove(new String[]{String.valueOf(roleId)});
    }
}

