/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.organization.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.UserOrgServiceApi;
import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.organization.PositionExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.organization.HrPositionRequest;
import cn.stylefeng.roses.kernel.system.modular.organization.entity.HrPosition;
import cn.stylefeng.roses.kernel.system.modular.organization.mapper.HrPositionMapper;
import cn.stylefeng.roses.kernel.system.modular.organization.service.HrPositionService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class HrPositionServiceImpl
extends ServiceImpl<HrPositionMapper, HrPosition>
implements HrPositionService {
    @Resource
    private UserOrgServiceApi userOrgServiceApi;

    @Override
    public void add(HrPositionRequest hrPositionRequest) {
        HrPosition sysPosition = new HrPosition();
        BeanUtil.copyProperties((Object)hrPositionRequest, (Object)((Object)sysPosition), (String[])new String[0]);
        sysPosition.setStatusFlag(StatusEnum.ENABLE.getCode());
        this.save((Object)sysPosition);
    }

    @Override
    public void del(HrPositionRequest hrPositionRequest) {
        HrPosition sysPosition = this.querySysPositionById(hrPositionRequest);
        Boolean userOrgFlag = this.userOrgServiceApi.getUserOrgFlag(null, sysPosition.getPositionId());
        if (userOrgFlag.booleanValue()) {
            throw new SystemModularException((AbstractExceptionEnum)PositionExceptionEnum.CANT_DELETE_POSITION);
        }
        sysPosition.setDelFlag(YesOrNotEnum.Y.getCode());
        this.updateById((Object)sysPosition);
    }

    @Override
    public void edit(HrPositionRequest hrPositionRequest) {
        HrPosition sysPosition = this.querySysPositionById(hrPositionRequest);
        BeanUtil.copyProperties((Object)hrPositionRequest, (Object)((Object)sysPosition), (String[])new String[0]);
        this.updateById((Object)sysPosition);
    }

    @Override
    public void changeStatus(HrPositionRequest hrPositionRequest) {
        HrPosition sysPosition = this.querySysPositionById(hrPositionRequest);
        sysPosition.setStatusFlag(hrPositionRequest.getStatusFlag());
        this.updateById((Object)sysPosition);
    }

    @Override
    public HrPosition detail(HrPositionRequest hrPositionRequest) {
        return this.querySysPositionById(hrPositionRequest);
    }

    @Override
    public List<HrPosition> findList(HrPositionRequest hrPositionRequest) {
        return this.list((Wrapper)this.createWrapper(hrPositionRequest));
    }

    @Override
    public PageResult<HrPosition> findPage(HrPositionRequest hrPositionRequest) {
        LambdaQueryWrapper<HrPosition> wrapper = this.createWrapper(hrPositionRequest);
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public void batchDel(HrPositionRequest hrPositionRequest) {
        List positionIds = hrPositionRequest.getPositionIds();
        for (Long userId : positionIds) {
            HrPositionRequest tempRequest = new HrPositionRequest();
            tempRequest.setPositionId(userId);
            this.del(tempRequest);
        }
    }

    private HrPosition querySysPositionById(HrPositionRequest hrPositionRequest) {
        HrPosition hrPosition = (HrPosition)((Object)this.getById(hrPositionRequest.getPositionId()));
        if (ObjectUtil.isEmpty((Object)((Object)hrPosition)) || YesOrNotEnum.Y.getCode().equals(hrPosition.getDelFlag())) {
            throw new SystemModularException((AbstractExceptionEnum)PositionExceptionEnum.CANT_FIND_POSITION, new Object[]{hrPositionRequest.getPositionId()});
        }
        return hrPosition;
    }

    private LambdaQueryWrapper<HrPosition> createWrapper(HrPositionRequest hrPositionRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long positionId = hrPositionRequest.getPositionId();
        String positionName = hrPositionRequest.getPositionName();
        String positionCode = hrPositionRequest.getPositionCode();
        Integer statusFlag = hrPositionRequest.getStatusFlag();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)positionId), HrPosition::getPositionId, (Object)positionId);
        queryWrapper.like(StrUtil.isNotEmpty((CharSequence)positionName), HrPosition::getPositionName, (Object)positionName);
        queryWrapper.eq(StrUtil.isNotEmpty((CharSequence)positionCode), HrPosition::getPositionCode, (Object)positionCode);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)statusFlag), HrPosition::getStatusFlag, (Object)statusFlag);
        queryWrapper.eq(HrPosition::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        queryWrapper.orderByAsc(HrPosition::getPositionSort);
        return queryWrapper;
    }
}

