/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.menu.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.config.api.InitConfigApi;
import cn.stylefeng.roses.kernel.rule.util.GunsResourceCodeUtil;
import cn.stylefeng.roses.kernel.system.api.pojo.menu.SysMenuResourceRequest;
import cn.stylefeng.roses.kernel.system.modular.menu.entity.SysMenuResource;
import cn.stylefeng.roses.kernel.system.modular.menu.mapper.SysMenuResourceMapper;
import cn.stylefeng.roses.kernel.system.modular.menu.service.SysMenuResourceService;
import cn.stylefeng.roses.kernel.system.modular.resource.pojo.ResourceTreeNode;
import cn.stylefeng.roses.kernel.system.modular.resource.service.SysResourceService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysMenuResourceServiceImpl
extends ServiceImpl<SysMenuResourceMapper, SysMenuResource>
implements SysMenuResourceService {
    @Resource
    private SysResourceService sysResourceService;
    @Resource
    private InitConfigApi initConfigApi;

    @Override
    public List<ResourceTreeNode> getMenuResourceTree(Long businessId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysMenuResource::getBusinessId, (Object)businessId);
        List list2 = this.list((Wrapper)wrapper);
        List resourceCodes = list2.stream().map(SysMenuResource::getResourceCode).collect(Collectors.toList());
        return this.sysResourceService.getResourceList(resourceCodes, Boolean.valueOf(true), null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addMenuResourceBind(SysMenuResourceRequest sysMenuResourceRequest) {
        List selectedResource;
        List modularTotalResource = sysMenuResourceRequest.getModularTotalResource();
        if (ObjectUtil.isNotEmpty((Object)modularTotalResource)) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.in(SysMenuResource::getResourceCode, (Collection)modularTotalResource);
            wrapper.eq(SysMenuResource::getBusinessId, (Object)sysMenuResourceRequest.getBusinessId());
            this.remove((Wrapper)wrapper);
        }
        if (ObjectUtil.isNotEmpty((Object)(selectedResource = sysMenuResourceRequest.getSelectedResource()))) {
            ArrayList<SysMenuResource> menuResources = new ArrayList<SysMenuResource>();
            for (String resourceCode : selectedResource) {
                SysMenuResource sysMenuResource = new SysMenuResource();
                sysMenuResource.setBusinessType(sysMenuResourceRequest.getBusinessType());
                sysMenuResource.setBusinessId(sysMenuResourceRequest.getBusinessId());
                sysMenuResource.setResourceCode(resourceCode);
                menuResources.add(sysMenuResource);
            }
            this.saveBatch(menuResources, menuResources.size());
        }
    }

    @Override
    public void updateNewAppCode(Boolean decisionFirstStart, String newAppCode) {
        Boolean initConfigFlag;
        if (decisionFirstStart.booleanValue() && (initConfigFlag = this.initConfigApi.getInitConfigFlag()).booleanValue()) {
            return;
        }
        List list2 = this.list();
        for (SysMenuResource sysMenuResource : list2) {
            String newResourceCode = GunsResourceCodeUtil.replace((String)sysMenuResource.getResourceCode(), (String)newAppCode);
            sysMenuResource.setResourceCode(newResourceCode);
        }
        this.updateBatchById(list2);
    }
}

