/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.menu.factory;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.rule.constants.TreeConstants;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import cn.stylefeng.roses.kernel.system.api.AppServiceApi;
import cn.stylefeng.roses.kernel.system.api.pojo.app.SysAppResult;
import cn.stylefeng.roses.kernel.system.api.pojo.login.v3.IndexMenuInfo;
import cn.stylefeng.roses.kernel.system.modular.menu.entity.SysMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Antdv3MenusFactory {
    public static List<IndexMenuInfo> createTotalMenus(Map<String, List<SysMenu>> appSortedMenus, List<String> appNames) {
        ArrayList<IndexMenuInfo> appSortedAntdMenus = new ArrayList<IndexMenuInfo>();
        if (ObjectUtil.isEmpty(appNames)) {
            return appSortedAntdMenus;
        }
        for (Map.Entry<String, List<SysMenu>> entry : appSortedMenus.entrySet()) {
            IndexMenuInfo rootAppMenu = Antdv3MenusFactory.createRootAppMenu(entry.getKey());
            List treeStructMenu = new DefaultTreeBuildFactory(TreeConstants.DEFAULT_PARENT_ID.toString()).doTreeBuild(entry.getValue());
            List<IndexMenuInfo> antdSysMenuDTOS = Antdv3MenusFactory.doModelReBuild(treeStructMenu);
            if (ObjectUtil.isNotEmpty(antdSysMenuDTOS)) {
                rootAppMenu.setHide(Boolean.valueOf(false));
                rootAppMenu.setChildren(antdSysMenuDTOS);
            }
            appSortedAntdMenus.add(rootAppMenu);
        }
        appSortedAntdMenus.sort((antdSysMenuDTO, antdSysMenuDTO2) -> {
            int one = appNames.indexOf(antdSysMenuDTO.getTitle());
            int two = appNames.indexOf(antdSysMenuDTO2.getTitle());
            return Integer.compare(one, two);
        });
        return appSortedAntdMenus;
    }

    private static List<IndexMenuInfo> doModelReBuild(List<SysMenu> sysMenuList) {
        if (ObjectUtil.isEmpty(sysMenuList)) {
            return null;
        }
        ArrayList<IndexMenuInfo> resultMenus = new ArrayList<IndexMenuInfo>();
        for (SysMenu sysMenu : sysMenuList) {
            IndexMenuInfo antdvMenuItem = new IndexMenuInfo();
            antdvMenuItem.setMenuId(sysMenu.getMenuId());
            antdvMenuItem.setParentId(sysMenu.getMenuParentId());
            antdvMenuItem.setTitle(sysMenu.getMenuName());
            antdvMenuItem.setPath(sysMenu.getAntdvRouter());
            antdvMenuItem.setIcon(sysMenu.getAntdvIcon());
            antdvMenuItem.setComponent(sysMenu.getAntdvComponent());
            antdvMenuItem.setHide(Boolean.valueOf(YesOrNotEnum.N.getCode().equals(sysMenu.getAntdvVisible())));
            antdvMenuItem.setActive(sysMenu.getAntdvActiveUrl());
            antdvMenuItem.setSortNumber(sysMenu.getMenuSort());
            if (ObjectUtil.isNotEmpty(sysMenu.getChildren())) {
                antdvMenuItem.setChildren(Antdv3MenusFactory.doModelReBuild(sysMenu.getChildren()));
            }
            resultMenus.add(antdvMenuItem);
        }
        return resultMenus;
    }

    private static IndexMenuInfo createRootAppMenu(String appCode) {
        IndexMenuInfo indexMenuInfo = new IndexMenuInfo();
        AppServiceApi appServiceApi = (AppServiceApi)SpringUtil.getBean(AppServiceApi.class);
        SysAppResult appInfoByAppCode = appServiceApi.getAppInfoByAppCode(appCode);
        indexMenuInfo.setTitle(appInfoByAppCode.getAppName());
        indexMenuInfo.setIcon(appInfoByAppCode.getAppIcon());
        indexMenuInfo.setPath("/" + appCode);
        indexMenuInfo.setComponent(null);
        indexMenuInfo.setHide(Boolean.valueOf(true));
        indexMenuInfo.setActive(null);
        indexMenuInfo.setAuthority(null);
        return indexMenuInfo;
    }
}

