/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.menu.factory;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.rule.constants.TreeConstants;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import cn.stylefeng.roses.kernel.system.api.AppServiceApi;
import cn.stylefeng.roses.kernel.system.api.pojo.app.SysAppResult;
import cn.stylefeng.roses.kernel.system.api.pojo.menu.MenuAndButtonTreeResponse;
import cn.stylefeng.roses.kernel.system.api.pojo.menu.antd.AntdMenuSelectTreeNode;
import cn.stylefeng.roses.kernel.system.api.pojo.menu.antd.AntdSysMenuDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.role.dto.SysRoleMenuButtonDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.role.dto.SysRoleMenuDTO;
import cn.stylefeng.roses.kernel.system.modular.menu.entity.SysMenu;
import cn.stylefeng.roses.kernel.system.modular.menu.entity.SysMenuButton;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AntdMenusFactory {
    public static List<AntdSysMenuDTO> createTotalMenus(Map<String, List<SysMenu>> appSortedMenus, List<String> appNames) {
        ArrayList<AntdSysMenuDTO> appSortedAntdMenus = new ArrayList<AntdSysMenuDTO>();
        for (Map.Entry<String, List<SysMenu>> entry : appSortedMenus.entrySet()) {
            AntdSysMenuDTO rootAppMenu = AntdMenusFactory.createRootAppMenu(entry.getKey());
            List treeStructMenu = new DefaultTreeBuildFactory(TreeConstants.DEFAULT_PARENT_ID.toString()).doTreeBuild(entry.getValue());
            List<AntdSysMenuDTO> antdSysMenuDTOS = AntdMenusFactory.doModelTransfer(treeStructMenu);
            rootAppMenu.setChildren(antdSysMenuDTOS);
            appSortedAntdMenus.add(rootAppMenu);
        }
        if (ObjectUtil.isEmpty(appNames)) {
            return appSortedAntdMenus;
        }
        appSortedAntdMenus.sort((antdSysMenuDTO, antdSysMenuDTO2) -> {
            int one = appNames.indexOf(antdSysMenuDTO.getTitle());
            int two = appNames.indexOf(antdSysMenuDTO2.getTitle());
            return Integer.compare(one, two);
        });
        return appSortedAntdMenus;
    }

    public static AntdMenuSelectTreeNode parseMenuBaseTreeNode(SysMenu sysMenu) {
        AntdMenuSelectTreeNode menuTreeNode = new AntdMenuSelectTreeNode();
        menuTreeNode.setId(sysMenu.getMenuId());
        menuTreeNode.setParentId(sysMenu.getMenuParentId());
        menuTreeNode.setValue(String.valueOf(sysMenu.getMenuId()));
        menuTreeNode.setTitle(sysMenu.getMenuName());
        menuTreeNode.setWeight(sysMenu.getMenuSort());
        return menuTreeNode;
    }

    public static AntdMenuSelectTreeNode createRootNode() {
        AntdMenuSelectTreeNode antdMenuSelectTreeNode = new AntdMenuSelectTreeNode();
        antdMenuSelectTreeNode.setId(Long.valueOf(-1L));
        antdMenuSelectTreeNode.setParentId(Long.valueOf(-2L));
        antdMenuSelectTreeNode.setTitle("\u6839\u8282\u70b9");
        antdMenuSelectTreeNode.setValue(String.valueOf(antdMenuSelectTreeNode.getId()));
        antdMenuSelectTreeNode.setWeight(new BigDecimal(-1));
        return antdMenuSelectTreeNode;
    }

    public static void fillLeafFlag(List<SysMenu> sysMenuList) {
        for (SysMenu sysMenu : sysMenuList) {
            sysMenu.setLeafFlag(true);
            for (SysMenu tempMenu : sysMenuList) {
                if (!tempMenu.getMenuPids().contains("[" + sysMenu.getMenuId() + "]")) continue;
                sysMenu.setLeafFlag(false);
            }
        }
    }

    public static List<MenuAndButtonTreeResponse> parseMenuAndButtonTreeResponse(List<SysMenu> sysMenuList, List<SysRoleMenuDTO> roleBindMenus) {
        ArrayList<MenuAndButtonTreeResponse> result = new ArrayList<MenuAndButtonTreeResponse>();
        if (ObjectUtil.isEmpty(sysMenuList)) {
            return result;
        }
        for (SysMenu sysMenu : sysMenuList) {
            MenuAndButtonTreeResponse menuAndButtonTreeResponse = new MenuAndButtonTreeResponse();
            menuAndButtonTreeResponse.setId(sysMenu.getMenuId());
            menuAndButtonTreeResponse.setName(sysMenu.getMenuName());
            menuAndButtonTreeResponse.setCode(sysMenu.getMenuCode());
            menuAndButtonTreeResponse.setPid(sysMenu.getMenuParentId());
            menuAndButtonTreeResponse.setChecked(Boolean.valueOf(false));
            if (ObjectUtil.isNotEmpty(roleBindMenus)) {
                for (SysRoleMenuDTO roleBindMenu : roleBindMenus) {
                    if (!roleBindMenu.getMenuId().equals(sysMenu.getMenuId())) continue;
                    menuAndButtonTreeResponse.setChecked(Boolean.valueOf(true));
                }
            }
            result.add(menuAndButtonTreeResponse);
        }
        return result;
    }

    public static List<MenuAndButtonTreeResponse> parseMenuAndButtonTreeResponseWithChildren(List<SysMenu> sysMenuList, List<SysRoleMenuDTO> roleBindMenus) {
        List<MenuAndButtonTreeResponse> menuAndButtonTreeResponses = AntdMenusFactory.parseMenuAndButtonTreeResponse(sysMenuList, roleBindMenus);
        for (SysMenu sysMenu : sysMenuList) {
            if (!ObjectUtil.isNotEmpty(sysMenu.getChildren())) continue;
            for (MenuAndButtonTreeResponse menuAndButtonTreeRespons : menuAndButtonTreeResponses) {
                if (!sysMenu.getMenuId().equals(menuAndButtonTreeRespons.getId())) continue;
                List<MenuAndButtonTreeResponse> subLevelItems = AntdMenusFactory.parseMenuAndButtonTreeResponse(sysMenu.getChildren(), roleBindMenus);
                menuAndButtonTreeRespons.setChildren(subLevelItems);
            }
        }
        return menuAndButtonTreeResponses;
    }

    public static void fillButtons(List<MenuAndButtonTreeResponse> sysMenuList, List<SysMenuButton> buttonList, List<SysRoleMenuButtonDTO> roleMenuButtonList) {
        for (MenuAndButtonTreeResponse menuAndButtonTreeResponse : sysMenuList) {
            if (ObjectUtil.isEmpty(buttonList)) continue;
            ArrayList<MenuAndButtonTreeResponse> menuButtonList = new ArrayList<MenuAndButtonTreeResponse>();
            for (SysMenuButton sysMenuButton : buttonList) {
                if (!menuAndButtonTreeResponse.getId().equals(sysMenuButton.getMenuId())) continue;
                MenuAndButtonTreeResponse buttonInfo = new MenuAndButtonTreeResponse();
                buttonInfo.setId(sysMenuButton.getButtonId());
                buttonInfo.setName(sysMenuButton.getButtonName());
                buttonInfo.setCode(sysMenuButton.getButtonCode());
                buttonInfo.setChecked(Boolean.valueOf(false));
                if (ObjectUtil.isNotEmpty(roleMenuButtonList)) {
                    for (SysRoleMenuButtonDTO sysRoleMenuButtonDTO : roleMenuButtonList) {
                        if (!sysRoleMenuButtonDTO.getButtonId().equals(sysMenuButton.getButtonId())) continue;
                        buttonInfo.setChecked(Boolean.valueOf(true));
                    }
                }
                menuButtonList.add(buttonInfo);
            }
            menuAndButtonTreeResponse.setButtons(menuButtonList);
        }
    }

    public static List<MenuAndButtonTreeResponse> fillButtons(List<SysMenu> sysMenuList, List<SysMenuButton> buttonList) {
        ArrayList<MenuAndButtonTreeResponse> result = new ArrayList<MenuAndButtonTreeResponse>();
        for (SysMenu sysMenu : sysMenuList) {
            MenuAndButtonTreeResponse menuAndButtonTreeResponse = new MenuAndButtonTreeResponse();
            menuAndButtonTreeResponse.setId(sysMenu.getMenuId());
            menuAndButtonTreeResponse.setName(sysMenu.getMenuName());
            menuAndButtonTreeResponse.setCode(sysMenu.getMenuCode());
            menuAndButtonTreeResponse.setPid(sysMenu.getMenuParentId());
            menuAndButtonTreeResponse.setChecked(Boolean.valueOf(false));
            List<SysMenu> children = sysMenu.getChildren();
            Set totalMenusIds = children.stream().map(SysMenu::getMenuId).collect(Collectors.toSet());
            totalMenusIds.add(sysMenu.getMenuId());
            ArrayList<MenuAndButtonTreeResponse> buttons = new ArrayList<MenuAndButtonTreeResponse>();
            for (SysMenuButton sysMenuButton : buttonList) {
                for (Long menuIdItem : totalMenusIds) {
                    if (!sysMenuButton.getMenuId().equals(menuIdItem)) continue;
                    MenuAndButtonTreeResponse buttonItem = new MenuAndButtonTreeResponse();
                    buttonItem.setId(sysMenuButton.getButtonId());
                    buttonItem.setName(sysMenuButton.getButtonName());
                    buttonItem.setCode(sysMenuButton.getButtonCode());
                    buttonItem.setChecked(Boolean.valueOf(false));
                    buttons.add(buttonItem);
                }
            }
            menuAndButtonTreeResponse.setButtons(buttons);
            result.add(menuAndButtonTreeResponse);
        }
        return result;
    }

    public static Map<String, List<SysMenu>> sortUserMenusByAppCode(List<SysMenu> currentUserMenus) {
        HashMap<String, List<SysMenu>> appMenus = new HashMap<String, List<SysMenu>>();
        for (SysMenu currentUserMenu : currentUserMenus) {
            String appCode = currentUserMenu.getAppCode();
            List<SysMenu> sysMenus = appMenus.get(appCode);
            if (sysMenus == null) {
                sysMenus = new ArrayList<SysMenu>();
            }
            sysMenus.add(currentUserMenu);
            appMenus.put(appCode, sysMenus);
        }
        return appMenus;
    }

    private static List<AntdSysMenuDTO> doModelTransfer(List<SysMenu> sysMenuList) {
        if (ObjectUtil.isEmpty(sysMenuList)) {
            return null;
        }
        ArrayList<AntdSysMenuDTO> resultMenus = new ArrayList<AntdSysMenuDTO>();
        for (SysMenu sysMenu : sysMenuList) {
            AntdSysMenuDTO antdvMenuItem = new AntdSysMenuDTO();
            antdvMenuItem.setTitle(sysMenu.getMenuName());
            antdvMenuItem.setIcon(sysMenu.getAntdvIcon());
            antdvMenuItem.setPath(sysMenu.getAntdvRouter());
            antdvMenuItem.setComponent(sysMenu.getAntdvComponent());
            antdvMenuItem.setHide(Boolean.valueOf(YesOrNotEnum.N.getCode().equals(sysMenu.getAntdvVisible())));
            antdvMenuItem.setActive(sysMenu.getAntdvActiveUrl());
            if (ObjectUtil.isNotEmpty(sysMenu.getChildren())) {
                antdvMenuItem.setChildren(AntdMenusFactory.doModelTransfer(sysMenu.getChildren()));
            }
            resultMenus.add(antdvMenuItem);
        }
        return resultMenus;
    }

    private static AntdSysMenuDTO createRootAppMenu(String appCode) {
        AntdSysMenuDTO antdSysMenuDTO = new AntdSysMenuDTO();
        AppServiceApi appServiceApi = (AppServiceApi)SpringUtil.getBean(AppServiceApi.class);
        SysAppResult appInfoByAppCode = appServiceApi.getAppInfoByAppCode(appCode);
        antdSysMenuDTO.setTitle(appInfoByAppCode.getAppName());
        antdSysMenuDTO.setIcon(appInfoByAppCode.getAppIcon());
        antdSysMenuDTO.setPath("/" + appCode);
        antdSysMenuDTO.setComponent(null);
        antdSysMenuDTO.setHide(Boolean.valueOf(false));
        antdSysMenuDTO.setActive(null);
        return antdSysMenuDTO;
    }

    public static List<MenuAndButtonTreeResponse> fillButtonsChecked(List<MenuAndButtonTreeResponse> menuAndButtonTreeResponses, List<SysRoleMenuButtonDTO> roleMenuButtonList) {
        for (MenuAndButtonTreeResponse menuAndButtonTreeResponse : menuAndButtonTreeResponses) {
            List buttons = menuAndButtonTreeResponse.getButtons();
            int totalSize = buttons.size();
            int totalSelectSize = 0;
            for (MenuAndButtonTreeResponse button : buttons) {
                for (SysRoleMenuButtonDTO sysRoleMenuButtonDTO : roleMenuButtonList) {
                    if (!sysRoleMenuButtonDTO.getButtonId().equals(button.getId())) continue;
                    button.setChecked(Boolean.valueOf(true));
                    ++totalSelectSize;
                }
            }
            if (totalSelectSize != totalSize || totalSelectSize == 0) continue;
            menuAndButtonTreeResponse.setChecked(Boolean.valueOf(true));
        }
        return menuAndButtonTreeResponses;
    }
}

