/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.api.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.enums.DataScopeTypeEnum;
import cn.stylefeng.roses.kernel.auth.api.exception.AuthException;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.organization.DataScopeExceptionEnum;
import java.util.Collection;
import java.util.Set;

public class DataScopeUtil {
    public static String getDataScopeTip() {
        LoginUser loginUser;
        StringBuilder tips = new StringBuilder();
        try {
            loginUser = LoginContext.me().getLoginUser();
        }
        catch (AuthException e) {
            return tips.append("\u7a7a\uff1a\u83b7\u53d6\u4e0d\u5230\u5f53\u524d\u7528\u6237").toString();
        }
        Set dataScopeTypes = loginUser.getDataScopeTypeEnums();
        if (dataScopeTypes == null) {
            return tips.append("\u7a7a\uff1a\u6570\u636e\u8303\u56f4\u4e3a\u7a7a").toString();
        }
        tips.append("\u7528\u6237\u6570\u636e\u8303\u56f4\u7c7b\u578b\uff1a");
        if (!dataScopeTypes.isEmpty()) {
            for (Object dataScopeType : dataScopeTypes) {
                tips.append(dataScopeType.getMessage()).append(",");
            }
        }
        Set userDataScope = loginUser.getDataScopeUserIds();
        tips.append("\u7528\u6237userId\u6570\u636e\u8303\u56f4\uff1a");
        if (userDataScope != null && !userDataScope.isEmpty()) {
            for (Long id : userDataScope) {
                tips.append(id).append(",");
            }
        }
        Set organizationDataScope = loginUser.getDataScopeOrganizationIds();
        tips.append("\u7528\u6237organizationId\u6570\u636e\u8303\u56f4\uff1a");
        if (organizationDataScope != null && !organizationDataScope.isEmpty()) {
            for (Long id : organizationDataScope) {
                tips.append(id).append(",");
            }
        }
        return tips.toString();
    }

    public static boolean validateDataScopeByOrganizationId(Long organizationId) {
        DataScopeTypeEnum dataScopeTypeEnum;
        LoginUser loginUser;
        try {
            loginUser = LoginContext.me().getLoginUser();
        }
        catch (AuthException e) {
            return false;
        }
        if (loginUser.getSuperAdmin().booleanValue()) {
            return true;
        }
        Set dataScopeTypes = loginUser.getDataScopeTypeEnums();
        Set organizationDataScope = loginUser.getDataScopeOrganizationIds();
        if (dataScopeTypes == null || dataScopeTypes.isEmpty()) {
            return false;
        }
        if (dataScopeTypes.contains(DataScopeTypeEnum.ALL)) {
            return true;
        }
        if (dataScopeTypes.size() == 1 && (dataScopeTypeEnum = (DataScopeTypeEnum)CollectionUtil.newArrayList((Collection)dataScopeTypes).get(0)).equals((Object)DataScopeTypeEnum.SELF)) {
            return false;
        }
        if (organizationDataScope == null || organizationDataScope.isEmpty()) {
            return false;
        }
        return organizationDataScope.contains(organizationId);
    }

    public static void quickValidateDataScope(Long organizationId) {
        boolean validateResult = DataScopeUtil.validateDataScopeByOrganizationId(organizationId);
        if (!validateResult) {
            throw new SystemModularException(DataScopeExceptionEnum.DATA_SCOPE_ERROR, DataScopeUtil.getDataScopeTip());
        }
    }
}

