/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.api.util;

import cn.hutool.core.util.IdUtil;
import cn.stylefeng.roses.kernel.rule.annotation.ChineseDescription;
import cn.stylefeng.roses.kernel.rule.enums.FieldTypeEnum;
import cn.stylefeng.roses.kernel.rule.util.ClassTypeUtil;
import cn.stylefeng.roses.kernel.scanner.api.context.MetadataContext;
import cn.stylefeng.roses.kernel.scanner.api.enums.FieldMetadataTypeEnum;
import cn.stylefeng.roses.kernel.scanner.api.enums.ParamTypeEnum;
import cn.stylefeng.roses.kernel.scanner.api.factory.ClassDetailMetadataFactory;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.FieldMetadata;
import cn.stylefeng.roses.kernel.scanner.api.util.ClassReflectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Set;

public class FieldDescriptionUtil {
    public static FieldMetadata createBasicMetadata(Field field, String uuid) {
        FieldMetadata fieldMetadataItem = new FieldMetadata();
        fieldMetadataItem.setMetadataId(IdUtil.fastSimpleUUID());
        ChineseDescription annotation = field.getAnnotation(ChineseDescription.class);
        if (annotation != null) {
            fieldMetadataItem.setChineseName(annotation.value());
        }
        Class<?> classType = field.getType();
        fieldMetadataItem.setFieldClassType(classType.getSimpleName());
        fieldMetadataItem.setFieldClassPath(classType.getName());
        fieldMetadataItem.setFieldName(field.getName());
        FieldDescriptionUtil.parsingAnnotation(field, fieldMetadataItem);
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            fieldMetadataItem.setGenericFieldMetadataType(FieldMetadataTypeEnum.GENERIC.getCode());
        } else {
            fieldMetadataItem.setGenericFieldMetadataType(FieldMetadataTypeEnum.FIELD.getCode());
        }
        FieldTypeEnum classFieldType = ClassTypeUtil.getClassFieldType((Type)genericType);
        fieldMetadataItem.setFieldType(classFieldType.getCode());
        ParamTypeEnum paramTypeMetadata = MetadataContext.getParamTypeMetadata(uuid);
        if (paramTypeMetadata != null) {
            fieldMetadataItem.setRequestParamType(paramTypeMetadata.getCode());
        }
        return fieldMetadataItem;
    }

    public static FieldMetadata createFieldMetadata(Field field, String uuid) {
        FieldMetadata fieldMetadata = FieldDescriptionUtil.createBasicMetadata(field, uuid);
        Type genericType = field.getGenericType();
        Set<FieldMetadata> fieldDetailMetadataSet = ClassDetailMetadataFactory.createFieldDetailMetadataSet(genericType, uuid);
        fieldMetadata.setGenericFieldMetadata(fieldDetailMetadataSet);
        return fieldMetadata;
    }

    private static void parsingAnnotation(Field declaredField, FieldMetadata fieldDescription) {
        Annotation[] annotations = declaredField.getAnnotations();
        if (annotations != null && annotations.length > 0) {
            fieldDescription.setAnnotations(ClassReflectUtil.annotationsToStrings(annotations));
            HashMap<String, Set<String>> groupAnnotations = new HashMap<String, Set<String>>();
            for (Annotation annotation : annotations) {
                Class[] validateGroupsClasses = ClassReflectUtil.invokeAnnotationMethodIgnoreError(annotation, "groups", Class[].class);
                if (validateGroupsClasses == null) continue;
                for (Class validateGroupsClass : validateGroupsClasses) {
                    ClassReflectUtil.addGroupValidateAnnotation(annotation, validateGroupsClass, groupAnnotations);
                }
            }
            fieldDescription.setGroupValidationMessage(groupAnnotations);
        }
    }
}

