/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.api.util;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.rule.enums.FieldTypeEnum;
import cn.stylefeng.roses.kernel.scanner.api.context.MetadataContext;
import cn.stylefeng.roses.kernel.scanner.api.enums.FieldMetadataTypeEnum;
import cn.stylefeng.roses.kernel.scanner.api.enums.ParamTypeEnum;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.FieldMetadata;
import java.lang.reflect.ParameterizedType;

public class ClassDescriptionUtil {
    public static FieldMetadata createClassMetadata(Class<?> clazz, FieldTypeEnum fieldTypeEnum, String uuid) {
        FieldMetadata fieldMetadataItem = new FieldMetadata();
        fieldMetadataItem.setMetadataId(IdUtil.fastSimpleUUID());
        fieldMetadataItem.setChineseName(clazz.getSimpleName());
        fieldMetadataItem.setFieldClassType(clazz.getSimpleName());
        fieldMetadataItem.setFieldClassPath(clazz.getName());
        String paramName = MetadataContext.getParamName(uuid);
        if (StrUtil.isNotBlank((CharSequence)paramName)) {
            fieldMetadataItem.setFieldName(paramName);
        }
        fieldMetadataItem.setGenericFieldMetadataType(FieldMetadataTypeEnum.FIELD.getCode());
        fieldMetadataItem.setFieldType(fieldTypeEnum.getCode());
        ParamTypeEnum paramTypeMetadata = MetadataContext.getParamTypeMetadata(uuid);
        if (paramTypeMetadata != null) {
            fieldMetadataItem.setRequestParamType(paramTypeMetadata.getCode());
        }
        return fieldMetadataItem;
    }

    public static FieldMetadata createParameterizedMetadata(ParameterizedType parameterizedType, FieldTypeEnum fieldTypeEnum, String uuid) {
        Class rawType = (Class)parameterizedType.getRawType();
        return ClassDescriptionUtil.createClassMetadata(rawType, fieldTypeEnum, uuid);
    }
}

