/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.rule.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.SecureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenSignUtil {
    private static final Logger log = LoggerFactory.getLogger(TokenSignUtil.class);

    public static String createSignStr(Long timestamp, String secretKey) {
        if (ObjectUtil.isEmpty((Object)timestamp) || ObjectUtil.isEmpty((Object)secretKey)) {
            return null;
        }
        return SecureUtil.md5((String)(timestamp + secretKey));
    }

    public static boolean validateSignStr(Long timestamp, String secretKey, String signStr, Integer expiredSeconds) {
        if (ObjectUtil.isEmpty((Object)timestamp) || ObjectUtil.isEmpty((Object)secretKey) || ObjectUtil.isEmpty((Object)signStr) || ObjectUtil.isEmpty((Object)expiredSeconds)) {
            return false;
        }
        long betweenSeconds = (System.currentTimeMillis() - timestamp) / 1000L;
        if (betweenSeconds > (long)expiredSeconds.intValue()) {
            return false;
        }
        String signRight = TokenSignUtil.createSignStr(timestamp, secretKey);
        return signRight.equals(signStr);
    }
}

