/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.jwt;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.stylefeng.roses.kernel.jwt.api.JwtApi;
import cn.stylefeng.roses.kernel.jwt.api.exception.JwtException;
import cn.stylefeng.roses.kernel.jwt.api.exception.enums.JwtExceptionEnum;
import cn.stylefeng.roses.kernel.jwt.api.pojo.config.JwtConfig;
import cn.stylefeng.roses.kernel.jwt.api.pojo.payload.DefaultJwtPayload;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import java.util.Map;

public class JwtTokenOperator
implements JwtApi {
    private final JwtConfig jwtConfig;

    public JwtTokenOperator(JwtConfig jwtConfig) {
        this.jwtConfig = jwtConfig;
    }

    public String generateToken(Map<String, Object> payload) {
        DateTime expirationDate = DateUtil.offsetMillisecond((Date)new Date(), (int)(Convert.toInt((Object)this.jwtConfig.getExpiredSeconds()) * 1000));
        return Jwts.builder().setClaims(payload).setIssuedAt(new Date()).setExpiration((Date)expirationDate).signWith(SignatureAlgorithm.HS512, this.jwtConfig.getJwtSecret()).compact();
    }

    public String generateTokenDefaultPayload(DefaultJwtPayload defaultJwtPayload) {
        DateTime expirationDate = DateUtil.offsetMillisecond((Date)new Date(), (int)(Convert.toInt((Object)this.jwtConfig.getExpiredSeconds()) * 1000));
        defaultJwtPayload.setExpirationDate(Long.valueOf(expirationDate.getTime()));
        return Jwts.builder().setClaims(BeanUtil.beanToMap((Object)defaultJwtPayload)).setSubject(defaultJwtPayload.getUserId().toString()).setIssuedAt(new Date()).setExpiration((Date)expirationDate).signWith(SignatureAlgorithm.HS512, this.jwtConfig.getJwtSecret()).compact();
    }

    public Claims getJwtPayloadClaims(String token) {
        return (Claims)Jwts.parser().setSigningKey(this.jwtConfig.getJwtSecret()).parseClaimsJws(token).getBody();
    }

    public DefaultJwtPayload getDefaultPayload(String token) {
        Claims jwtPayload = this.getJwtPayloadClaims(token);
        return (DefaultJwtPayload)BeanUtil.toBeanIgnoreError((Object)jwtPayload, DefaultJwtPayload.class);
    }

    public boolean validateToken(String token) {
        try {
            this.getJwtPayloadClaims(token);
            return true;
        }
        catch (io.jsonwebtoken.JwtException jwtException) {
            return false;
        }
    }

    public void validateTokenWithException(String token) throws JwtException {
        boolean tokenIsExpired = this.validateTokenIsExpired(token);
        if (tokenIsExpired) {
            throw new JwtException((AbstractExceptionEnum)JwtExceptionEnum.JWT_EXPIRED_ERROR, new Object[]{token});
        }
        try {
            this.getJwtPayloadClaims(token);
        }
        catch (io.jsonwebtoken.JwtException jwtException) {
            throw new JwtException((AbstractExceptionEnum)JwtExceptionEnum.JWT_PARSE_ERROR, new Object[]{token});
        }
    }

    public boolean validateTokenIsExpired(String token) {
        try {
            Claims claims = this.getJwtPayloadClaims(token);
            Date expiration = claims.getExpiration();
            return expiration.before(new Date());
        }
        catch (ExpiredJwtException expiredJwtException) {
            return true;
        }
    }
}

