/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.expand.modular.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.dict.api.DictApi;
import cn.stylefeng.roses.kernel.expand.modular.api.enums.FieldTypeEnum;
import cn.stylefeng.roses.kernel.expand.modular.api.pojo.ExpandDataInfo;
import cn.stylefeng.roses.kernel.expand.modular.api.pojo.ExpandFieldInfo;
import cn.stylefeng.roses.kernel.expand.modular.modular.entity.SysExpand;
import cn.stylefeng.roses.kernel.expand.modular.modular.entity.SysExpandData;
import cn.stylefeng.roses.kernel.expand.modular.modular.entity.SysExpandField;
import cn.stylefeng.roses.kernel.expand.modular.modular.enums.SysExpandExceptionEnum;
import cn.stylefeng.roses.kernel.expand.modular.modular.mapper.SysExpandMapper;
import cn.stylefeng.roses.kernel.expand.modular.modular.pojo.request.SysExpandFieldRequest;
import cn.stylefeng.roses.kernel.expand.modular.modular.pojo.request.SysExpandRequest;
import cn.stylefeng.roses.kernel.expand.modular.modular.service.SysExpandDataService;
import cn.stylefeng.roses.kernel.expand.modular.modular.service.SysExpandFieldService;
import cn.stylefeng.roses.kernel.expand.modular.modular.service.SysExpandService;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysExpandServiceImpl
extends ServiceImpl<SysExpandMapper, SysExpand>
implements SysExpandService {
    @Resource
    private SysExpandFieldService sysExpandFieldService;
    @Resource
    private SysExpandDataService sysExpandDataService;
    @Resource
    private DictApi dictApi;

    @Override
    public void add(SysExpandRequest sysExpandRequest) {
        SysExpand sysExpand = new SysExpand();
        BeanUtil.copyProperties((Object)((Object)sysExpandRequest), (Object)((Object)sysExpand), (String[])new String[0]);
        sysExpand.setExpandStatus(StatusEnum.ENABLE.getCode());
        this.save((Object)sysExpand);
    }

    @Override
    public void del(SysExpandRequest sysExpandRequest) {
        SysExpand sysExpand = this.querySysExpand(sysExpandRequest);
        this.removeById(sysExpand.getExpandId());
    }

    @Override
    public void edit(SysExpandRequest sysExpandRequest) {
        SysExpand sysExpand = this.querySysExpand(sysExpandRequest);
        BeanUtil.copyProperties((Object)((Object)sysExpandRequest), (Object)((Object)sysExpand), (String[])new String[0]);
        this.updateById((Object)sysExpand);
    }

    @Override
    public SysExpand detail(SysExpandRequest sysExpandRequest) {
        return this.querySysExpand(sysExpandRequest);
    }

    @Override
    public PageResult<SysExpand> findPage(SysExpandRequest sysExpandRequest) {
        LambdaQueryWrapper<SysExpand> wrapper = this.createWrapper(sysExpandRequest);
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    public void updateStatus(SysExpandRequest sysExpandRequest) {
        SysExpand sysExpand = this.querySysExpand(sysExpandRequest);
        sysExpand.setExpandStatus(sysExpandRequest.getExpandStatus());
        this.updateById((Object)sysExpand);
    }

    @Override
    public SysExpandData getByExpandCode(SysExpandRequest sysExpandRequest) {
        LambdaQueryWrapper sysExpandLambdaQueryWrapper = new LambdaQueryWrapper();
        sysExpandLambdaQueryWrapper.eq(SysExpand::getExpandCode, (Object)sysExpandRequest.getExpandCode());
        SysExpand sysExpand = (SysExpand)((Object)this.getOne((Wrapper)sysExpandLambdaQueryWrapper, false));
        if (sysExpand == null) {
            throw new ServiceException((AbstractExceptionEnum)SysExpandExceptionEnum.SYS_EXPAND_NOT_EXISTED);
        }
        SysExpandFieldRequest sysExpandFieldRequest = new SysExpandFieldRequest();
        sysExpandFieldRequest.setExpandId(sysExpand.getExpandId());
        List<SysExpandField> list = this.sysExpandFieldService.findList(sysExpandFieldRequest);
        SysExpandData sysExpandData = new SysExpandData();
        if (sysExpandRequest.getPrimaryFieldValue() != null && (sysExpandData = this.sysExpandDataService.detailByPrimaryFieldValue(sysExpandRequest.getPrimaryFieldValue())) == null) {
            sysExpandData = new SysExpandData();
        }
        sysExpandData.setExpandId(sysExpand.getExpandId());
        sysExpandData.setFieldInfoList(list);
        sysExpandData.setExpandInfo(sysExpand);
        return sysExpandData;
    }

    @Override
    public List<SysExpand> findList(SysExpandRequest sysExpandRequest) {
        LambdaQueryWrapper<SysExpand> wrapper = this.createWrapper(sysExpandRequest);
        wrapper.select(new SFunction[]{SysExpand::getExpandId, SysExpand::getExpandName, SysExpand::getExpandCode});
        wrapper.eq(SysExpand::getExpandStatus, (Object)StatusEnum.ENABLE.getCode());
        return this.list((Wrapper)wrapper);
    }

    public void saveOrUpdateExpandData(ExpandDataInfo expandDataInfo) {
        if (expandDataInfo == null) {
            return;
        }
        Map dynamicFormData = expandDataInfo.getExpandData();
        if (dynamicFormData == null || dynamicFormData.size() <= 0) {
            return;
        }
        String dynamicData = JSON.toJSONString((Object)dynamicFormData);
        SysExpandData saveData = new SysExpandData();
        saveData.setExpandId(expandDataInfo.getExpandId());
        saveData.setPrimaryFieldValue(expandDataInfo.getPrimaryFieldValue());
        saveData.setExpandData(dynamicData);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysExpandData::getExpandId, (Object)expandDataInfo.getExpandId());
        wrapper.eq(SysExpandData::getPrimaryFieldValue, (Object)expandDataInfo.getPrimaryFieldValue());
        SysExpandData sysExpandData = (SysExpandData)((Object)this.sysExpandDataService.getOne((Wrapper)wrapper, false));
        if (sysExpandData == null) {
            this.sysExpandDataService.save((Object)saveData);
        } else {
            saveData.setExpandDataId(sysExpandData.getExpandDataId());
            this.sysExpandDataService.updateById((Object)saveData);
        }
    }

    public List<ExpandFieldInfo> getPageListExpandFieldList(String expandCode) {
        SysExpandRequest sysExpandRequest = new SysExpandRequest();
        sysExpandRequest.setExpandCode(expandCode);
        SysExpandData sysExpandData = this.getByExpandCode(sysExpandRequest);
        List<SysExpandField> fieldInfoList = sysExpandData.getFieldInfoList();
        ArrayList<ExpandFieldInfo> expandFieldInfos = new ArrayList<ExpandFieldInfo>();
        for (SysExpandField sysExpandField : fieldInfoList) {
            String listShowFlag = sysExpandField.getListShowFlag();
            if (!YesOrNotEnum.Y.getCode().equals(listShowFlag)) continue;
            ExpandFieldInfo expandFieldInfo = new ExpandFieldInfo();
            expandFieldInfo.setExpandId(sysExpandField.getExpandId());
            expandFieldInfo.setFieldName(sysExpandField.getFieldName());
            expandFieldInfo.setFieldCode(sysExpandField.getFieldCode());
            expandFieldInfos.add(expandFieldInfo);
        }
        return expandFieldInfos;
    }

    public Map<String, Object> getExpandDataInfo(String expandCode, Long primaryFieldValue) {
        SysExpandRequest sysExpandRequest = new SysExpandRequest();
        sysExpandRequest.setExpandCode(expandCode);
        sysExpandRequest.setPrimaryFieldValue(primaryFieldValue);
        SysExpandData sysExpandData = this.getByExpandCode(sysExpandRequest);
        HashMap<String, Object> result = new HashMap<String, Object>();
        String expandData = sysExpandData.getExpandData();
        if (StrUtil.isEmpty((CharSequence)expandData)) {
            return result;
        }
        JSONObject jsonObject = JSON.parseObject((String)expandData);
        List<SysExpandField> fieldInfoList = sysExpandData.getFieldInfoList();
        for (SysExpandField sysExpandField : fieldInfoList) {
            if (!FieldTypeEnum.DICT.getCode().equals(sysExpandField.getFieldType())) continue;
            String dictTypeCode = sysExpandField.getFieldDictTypeCode();
            String dictValue = jsonObject.getString(sysExpandField.getFieldCode());
            String dictName = this.dictApi.getDictName(dictTypeCode, dictValue);
            jsonObject.put(sysExpandField.getFieldCode(), (Object)dictName);
        }
        return jsonObject;
    }

    private SysExpand querySysExpand(SysExpandRequest sysExpandRequest) {
        SysExpand sysExpand = (SysExpand)((Object)this.getById(sysExpandRequest.getExpandId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysExpand))) {
            throw new ServiceException((AbstractExceptionEnum)SysExpandExceptionEnum.SYS_EXPAND_NOT_EXISTED);
        }
        return sysExpand;
    }

    private LambdaQueryWrapper<SysExpand> createWrapper(SysExpandRequest sysExpandRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long expandId = sysExpandRequest.getExpandId();
        String expandName = sysExpandRequest.getExpandName();
        String expandCode = sysExpandRequest.getExpandCode();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)expandId), SysExpand::getExpandId, (Object)expandId);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)expandName), SysExpand::getExpandName, (Object)expandName);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)expandCode), SysExpand::getExpandCode, (Object)expandCode);
        return queryWrapper;
    }
}

