/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.db.api.factory;

import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.pojo.druid.DruidProperties;
import cn.stylefeng.roses.kernel.rule.enums.DbTypeEnum;
import com.alibaba.druid.pool.DruidDataSource;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidDatasourceFactory {
    private static final Logger log = LoggerFactory.getLogger(DruidDatasourceFactory.class);

    public static DruidDataSource createDruidDataSource(DruidProperties druidProperties) {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(druidProperties.getUrl());
        dataSource.setUsername(druidProperties.getUsername());
        dataSource.setPassword(druidProperties.getPassword());
        if (StrUtil.isNotBlank((CharSequence)druidProperties.getDriverClassName())) {
            dataSource.setDriverClassName(druidProperties.getDriverClassName());
        }
        dataSource.setInitialSize(druidProperties.getInitialSize().intValue());
        dataSource.setMaxActive(druidProperties.getMaxActive().intValue());
        dataSource.setMinIdle(druidProperties.getMinIdle().intValue());
        dataSource.setMaxWait((long)druidProperties.getMaxWait().intValue());
        dataSource.setPoolPreparedStatements(druidProperties.getPoolPreparedStatements().booleanValue());
        dataSource.setMaxPoolPreparedStatementPerConnectionSize(druidProperties.getMaxPoolPreparedStatementPerConnectionSize().intValue());
        if (StrUtil.isNotEmpty((CharSequence)druidProperties.getUrl())) {
            dataSource.setValidationQuery(DruidDatasourceFactory.getValidateQueryByUrl(druidProperties.getUrl()));
        }
        dataSource.setValidationQueryTimeout(druidProperties.getValidationQueryTimeout().intValue());
        dataSource.setTestOnBorrow(druidProperties.getTestOnBorrow().booleanValue());
        dataSource.setTestOnReturn(druidProperties.getTestOnReturn().booleanValue());
        dataSource.setTestWhileIdle(druidProperties.getTestWhileIdle().booleanValue());
        dataSource.setKeepAlive(druidProperties.getKeepAlive().booleanValue());
        dataSource.setTimeBetweenEvictionRunsMillis((long)druidProperties.getTimeBetweenEvictionRunsMillis().intValue());
        dataSource.setMinEvictableIdleTimeMillis((long)druidProperties.getMinEvictableIdleTimeMillis().intValue());
        try {
            dataSource.setFilters(druidProperties.getFilters());
        }
        catch (SQLException e) {
            log.error("\u6570\u636e\u5e93\u8fde\u63a5\u6c60\u521d\u59cb\u5316\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        return dataSource;
    }

    private static String getValidateQueryByUrl(String url) {
        for (DbTypeEnum value : DbTypeEnum.values()) {
            if (!url.contains(value.getUrlWords())) continue;
            return value.getValidateQuery();
        }
        return DbTypeEnum.MYSQL.getValidateQuery();
    }
}

