/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.cache.api;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.rule.tenant.TenantPrefixApi;
import java.util.Collection;
import java.util.Map;

public interface CacheOperatorApi<T> {
    public void put(String var1, T var2);

    public void put(String var1, T var2, Long var3);

    public T get(String var1);

    public void remove(String ... var1);

    public void expire(String var1, Long var2);

    public boolean contains(String var1);

    public Collection<String> getAllKeys();

    public Collection<T> getAllValues();

    public Map<String, T> getAllKeyValues();

    public String getCommonKeyPrefix();

    default public Boolean divideByTenant() {
        return false;
    }

    default public String getFinalPrefix() {
        String tenantPrefix = this.getTenantPrefix();
        return tenantPrefix + ":" + this.getCommonKeyPrefix() + ":";
    }

    default public String calcKey(String keyParam) {
        if (StrUtil.isEmpty((CharSequence)keyParam)) {
            return this.getFinalPrefix();
        }
        return this.getFinalPrefix() + keyParam;
    }

    default public String removePrefix(String finalKey) {
        if (ObjectUtil.isEmpty((Object)finalKey)) {
            return "";
        }
        return StrUtil.removePrefix((CharSequence)finalKey, (CharSequence)this.getFinalPrefix());
    }

    default public String getTenantPrefix() {
        Boolean divideByTenantFlag = this.divideByTenant();
        if (!divideByTenantFlag.booleanValue()) {
            return "master";
        }
        String tenantPrefix = "";
        try {
            TenantPrefixApi tenantPrefixApi = (TenantPrefixApi)SpringUtil.getBean(TenantPrefixApi.class);
            if (tenantPrefixApi != null) {
                tenantPrefix = tenantPrefixApi.getTenantPrefix();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ObjectUtil.isEmpty((Object)tenantPrefix)) {
            tenantPrefix = "master";
        }
        return tenantPrefix;
    }
}

