/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.auth;

import cn.stylefeng.roses.kernel.auth.api.LoginUserApi;
import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.context.LoginUserHolder;
import cn.stylefeng.roses.kernel.auth.api.exception.AuthException;
import cn.stylefeng.roses.kernel.auth.api.exception.enums.AuthExceptionEnum;
import cn.stylefeng.roses.kernel.auth.api.loginuser.CommonLoginUserUtil;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.UserServiceApi;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class LoginUserImpl
implements LoginUserApi {
    @Resource
    private SessionManagerApi sessionManagerApi;
    @Resource
    private UserServiceApi userServiceApi;

    public String getToken() {
        return CommonLoginUserUtil.getToken();
    }

    public LoginUser getLoginUser() throws AuthException {
        LoginUser currentUser = LoginUserHolder.get();
        if (currentUser != null) {
            return currentUser;
        }
        String token = this.getToken();
        LoginUser session = this.sessionManagerApi.getSession(token);
        if (session == null) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.AUTH_EXPIRED_ERROR);
        }
        return session;
    }

    public LoginUser getLoginUserNullable() {
        LoginUser currentUser = LoginUserHolder.get();
        if (currentUser != null) {
            return currentUser;
        }
        String token = null;
        try {
            token = this.getToken();
        }
        catch (Exception e) {
            return null;
        }
        return this.sessionManagerApi.getSession(token);
    }

    public boolean getSuperAdminFlag() {
        LoginUser loginUser = this.getLoginUser();
        return loginUser.getSuperAdmin();
    }

    public boolean hasLogin() {
        String token = null;
        try {
            token = this.getToken();
        }
        catch (Exception e) {
            return false;
        }
        return this.sessionManagerApi.haveSession(token);
    }

    public boolean haveButton(String buttonCode) {
        LoginUser loginUser = this.getLoginUser();
        if (loginUser.getButtonCodes() == null) {
            return false;
        }
        return loginUser.getButtonCodes().contains(buttonCode);
    }
}

