/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.guns.generator.engine.base;

import cn.stylefeng.guns.generator.engine.base.AbstractTemplateEngine;
import cn.stylefeng.roses.core.util.ToolUtil;
import com.sun.javafx.PlatformUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;

public abstract class GunsTemplateEngine
extends AbstractTemplateEngine {
    private GroupTemplate groupTemplate;

    public GunsTemplateEngine() {
        this.initBeetlEngine();
    }

    protected void initBeetlEngine() {
        Properties properties = new Properties();
        properties.put("RESOURCE.root", "");
        properties.put("DELIMITER_STATEMENT_START", "<%");
        properties.put("DELIMITER_STATEMENT_END", "%>");
        properties.put("HTML_TAG_FLAG", "##");
        Configuration cfg = null;
        try {
            cfg = new Configuration(properties);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader();
        this.groupTemplate = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
        this.groupTemplate.registerFunctionPackage("tool", (Object)new ToolUtil());
    }

    protected void configTemplate(Template template) {
        template.binding("controller", (Object)this.controllerConfig);
        template.binding("context", (Object)this.contextConfig);
        template.binding("dao", (Object)this.daoConfig);
        template.binding("service", (Object)this.serviceConfig);
        template.binding("sqls", (Object)this.sqlConfig);
        template.binding("table", (Object)this.tableInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateFile(String template, String filePath) {
        Template pageTemplate = this.groupTemplate.getTemplate(template);
        this.configTemplate(pageTemplate);
        filePath = PlatformUtil.isWindows() ? filePath.replaceAll("/+|\\\\+", "\\\\") : filePath.replaceAll("/+|\\\\+", "/");
        File file = new File(filePath);
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            pageTemplate.renderTo((OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void start() {
        super.initConfig();
        if (this.contextConfig.getControllerSwitch().booleanValue()) {
            this.generateController();
        }
        if (this.contextConfig.getIndexPageSwitch().booleanValue()) {
            this.generatePageHtml();
        }
        if (this.contextConfig.getAddPageSwitch().booleanValue()) {
            this.generatePageAddHtml();
        }
        if (this.contextConfig.getEditPageSwitch().booleanValue()) {
            this.generatePageEditHtml();
        }
        if (this.contextConfig.getJsSwitch().booleanValue()) {
            this.generatePageJs();
        }
        if (this.contextConfig.getInfoJsSwitch().booleanValue()) {
            this.generatePageInfoJs();
        }
        if (this.contextConfig.getSqlSwitch().booleanValue()) {
            this.generateSqls();
        }
    }

    protected abstract void generatePageEditHtml();

    protected abstract void generatePageAddHtml();

    protected abstract void generatePageInfoJs();

    protected abstract void generatePageJs();

    protected abstract void generatePageHtml();

    protected abstract void generateController();

    protected abstract void generateSqls();
}

