/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.anti_reptile.rule;

import cn.keking.anti_reptile.config.AntiReptileProperties;
import cn.keking.anti_reptile.rule.AbstractRule;
import eu.bitwalker.useragentutils.DeviceType;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.UserAgent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class UaRule
extends AbstractRule {
    @Autowired
    private AntiReptileProperties properties;

    @Override
    protected boolean doExecute(HttpServletRequest request, HttpServletResponse response) {
        AntiReptileProperties.UaRule uaRule = this.properties.getUaRule();
        UserAgent userAgent = UserAgent.parseUserAgentString((String)request.getHeader("User-Agent"));
        OperatingSystem os = userAgent.getOperatingSystem();
        OperatingSystem osGroup = userAgent.getOperatingSystem().getGroup();
        DeviceType deviceType = userAgent.getOperatingSystem().getDeviceType();
        if (DeviceType.UNKNOWN.equals((Object)deviceType)) {
            System.out.println("Intercepted request, uri: " + request.getRequestURI() + " Unknown device, User-Agent: " + userAgent.toString());
            return true;
        }
        if (OperatingSystem.UNKNOWN.equals((Object)os) || OperatingSystem.UNKNOWN_MOBILE.equals((Object)os) || OperatingSystem.UNKNOWN_TABLET.equals((Object)os)) {
            System.out.println("Intercepted request, uri: " + request.getRequestURI() + " Unknown OperatingSystem, User-Agent: " + userAgent.toString());
            return true;
        }
        if (!uaRule.isAllowedLinux() && (OperatingSystem.LINUX.equals((Object)osGroup) || OperatingSystem.LINUX.equals((Object)os))) {
            System.out.println("Intercepted request, uri: " + request.getRequestURI() + " Not Allowed Linux request, User-Agent: " + userAgent.toString());
            return true;
        }
        if (!uaRule.isAllowedMobile() && (DeviceType.MOBILE.equals((Object)deviceType) || DeviceType.TABLET.equals((Object)deviceType))) {
            System.out.println("Intercepted request, uri: " + request.getRequestURI() + " Not Allowed Mobile Device request, User-Agent: " + userAgent.toString());
            return true;
        }
        if (!uaRule.isAllowedPc() && DeviceType.COMPUTER.equals((Object)deviceType)) {
            System.out.println("Intercepted request, uri: " + request.getRequestURI() + " Not Allowed PC request, User-Agent: " + userAgent.toString());
            return true;
        }
        if (!uaRule.isAllowedIot() && (DeviceType.DMR.equals((Object)deviceType) || DeviceType.GAME_CONSOLE.equals((Object)deviceType) || DeviceType.WEARABLE.equals((Object)deviceType))) {
            System.out.println("Intercepted request, uri: " + request.getRequestURI() + " Not Allowed Iot Device request, User-Agent: " + userAgent.toString());
            return true;
        }
        if (!uaRule.isAllowedProxy() && OperatingSystem.PROXY.equals((Object)os)) {
            System.out.println("Intercepted request, uri: " + request.getRequestURI() + " Not Allowed Proxy request, User-Agent: " + userAgent.toString());
            return true;
        }
        return false;
    }

    @Override
    public void reset(HttpServletRequest request, String realRequestUri) {
    }

    @Override
    public int getOrder() {
        return 1;
    }
}

